/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.server;

import com.vmware.vapi.config.Configurator;
import com.vmware.vapi.config.PropertyConfigurator;
import com.vmware.vapi.config.SpringConfigurator;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.protocol.ProtocolConnection;
import com.vmware.vapi.protocol.ProtocolHandler;
import com.vmware.vapi.protocol.local.LocalConnection;
import com.vmware.vapi.protocol.local.LocalProtocol;
import com.vmware.vapi.server.ServerInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
implements ServerInterface {
    static Logger logger = LoggerFactory.getLogger(Server.class);
    private volatile Thread mainLoop;
    private ApiProvider primary;
    private List<ProtocolHandler> handlers;
    private LocalProtocol localProtocol;
    private volatile boolean shutdown = false;
    private volatile CountDownLatch shutdownLatch = new CountDownLatch(1);

    public Server(Properties props) throws Exception {
        this(new PropertyConfigurator(props));
    }

    public Server(Configurator configurator) {
        this.primary = configurator.getApiProvider();
        this.handlers = configurator.getProtocolHandlers();
        this.localProtocol = new LocalProtocol(this.primary);
        for (ProtocolHandler protocol : this.handlers) {
            protocol.start();
        }
    }

    @Override
    public void stop() {
        this.shutdown = true;
        if (this.mainLoop != null) {
            this.mainLoop.interrupt();
        }
    }

    @Override
    public boolean waitForShutdown(long timeoutMillis) throws InterruptedException {
        return this.shutdownLatch.await(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        this.mainLoop = Thread.currentThread();
        while (!this.shutdown) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (ProtocolHandler handler : this.handlers) {
            handler.stop();
        }
        this.shutdownLatch.countDown();
    }

    @Override
    public ProtocolConnection getLocalConnection() {
        return new LocalConnection(this.localProtocol);
    }

    private static InputStream getClasspathResource(String classpathResource) {
        if (!classpathResource.startsWith("/")) {
            classpathResource = "/" + classpathResource;
        }
        return Server.class.getResourceAsStream(classpathResource);
    }

    private static Configurator buildSpringConfigurator(String configFileName) {
        return new SpringConfigurator(Arrays.asList(configFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Configurator buildPropertiesConfigurator(String propFileName) throws IOException, FileNotFoundException {
        Properties props = new Properties();
        File propFile = new File(propFileName);
        try (InputStream inPropsStream = null;){
            InputStream inputStream = inPropsStream = propFile.isFile() ? new FileInputStream(propFile) : Server.getClasspathResource(propFileName);
            if (inPropsStream == null) {
                throw new IllegalArgumentException("Property file '" + propFileName + "' does not exist on the file system" + " nor on the classpath");
            }
            props.load(inPropsStream);
        }
        return new PropertyConfigurator(props);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Please specify provider configuration as argument (either .properties or Spring .xml configuration");
            System.exit(1);
        }
        String configFileName = args[0];
        Configurator configurator = null;
        if (configFileName.endsWith(".xml")) {
            configurator = Server.buildSpringConfigurator(configFileName);
        } else if (configFileName.endsWith(".properties")) {
            configurator = Server.buildPropertiesConfigurator(configFileName);
        } else {
            System.err.println("Unsupported provider configuration (expected .properties or Spring .xml config");
            System.exit(1);
        }
        Server s = new Server(configurator);
        s.run();
    }
}

