/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.std.activation.impl;

import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.activation.Activations;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.DecoratorApiProvider;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorDefinition;
import com.vmware.vapi.internal.std.activation.impl.ActivationRegistry;
import com.vmware.vapi.provider.introspection.ErrorAugmentingFilter;
import com.vmware.vapi.std.StandardDataFactory;
import com.vmware.vapi.util.async.DecoratorAsyncHandle;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.Validate;

public final class ActivationFilter
extends DecoratorApiProvider {
    public static final InterfaceIdentifier ACTIVATION_MANAGER_ID = new InterfaceIdentifier("com.vmware.vapi.std.activation.activation_manager");
    private static final Set<ErrorDefinition> ACTIVATION_FILTER_ERROR_DEFS = Collections.singleton(StandardDataFactory.createStandardErrorDefinition("com.vmware.vapi.std.errors.already_exists"));
    private final ActivationRegistry activationRegistry;

    public ActivationFilter(ApiProvider decoratedProvider, ActivationRegistry activationRegistry) {
        super(new ErrorAugmentingFilter(decoratedProvider, ACTIVATION_FILTER_ERROR_DEFS));
        Validate.notNull((Object)activationRegistry);
        this.activationRegistry = activationRegistry;
    }

    @Override
    public void invoke(String serviceId, String operationId, DataValue input, ExecutionContext ctx, AsyncHandle<MethodResult> asyncHandle) {
        ExecutionContext delegatedCtx;
        String activationId;
        MethodIdentifier method = new MethodIdentifier(new InterfaceIdentifier(serviceId), operationId);
        if (ACTIVATION_MANAGER_ID.equals(method.getInterfaceIdentifier())) {
            this.decoratedProvider.invoke(serviceId, operationId, input, ctx, asyncHandle);
            return;
        }
        String activationIdFromClient = Activations.getActivationId(ctx);
        if (activationIdFromClient == null) {
            activationId = Activations.newActivationId();
            delegatedCtx = Activations.setActivationId(ctx, activationId);
        } else {
            activationId = activationIdFromClient;
            delegatedCtx = ctx;
        }
        try {
            this.activationRegistry.register(activationId, method);
        }
        catch (IllegalStateException ex) {
            asyncHandle.setResult(MethodResult.newErrorResult(StandardDataFactory.createErrorValueForMessages("com.vmware.vapi.std.errors.already_exists", Collections.singletonList(MessageFactory.getMessage("vapi.activation.id.duplicate", activationId)))));
            return;
        }
        DecoratorAsyncHandle<MethodResult> cb = new DecoratorAsyncHandle<MethodResult>(asyncHandle){

            @Override
            public void setResult(MethodResult result) {
                ActivationFilter.this.activationRegistry.unregister(activationId);
                super.setResult(result);
            }

            @Override
            public void setError(RuntimeException error) {
                ActivationFilter.this.activationRegistry.unregister(activationId);
                super.setError(error);
            }
        };
        this.decoratedProvider.invoke(serviceId, operationId, input, delegatedCtx, (AsyncHandle<MethodResult>)cb);
    }
}

