/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.cis.authn.json;

import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.dsig.json.SignatureException;
import com.vmware.vapi.dsig.json.StsTrustChain;
import com.vmware.vapi.internal.cis.authn.Signer;
import com.vmware.vapi.internal.cis.authn.json.JsonSignatureStruct;
import com.vmware.vapi.internal.dsig.json.Canonicalizer;
import com.vmware.vapi.internal.dsig.json.Verifier;
import com.vmware.vapi.internal.protocol.common.json.JsonSecurityContextSerializer;
import com.vmware.vapi.saml.ConfirmationType;
import com.vmware.vapi.saml.SamlToken;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.Validate;

public final class JsonSignerImpl
implements Signer,
Verifier {
    private static final String UTF_8 = "UTF-8";
    private static final String SHA256_WITH_RSA = "SHA256withRSA";
    private static final Message SIGN_ERROR = MessageFactory.getMessage((String)"vapi.signature.sign", (String[])new String[0]);
    private static final Message VERIFY_ERROR = MessageFactory.getMessage((String)"vapi.signature.verify", (String[])new String[0]);
    private static final Message HOK_ERROR = MessageFactory.getMessage((String)"vapi.signature.hokexpected", (String[])new String[0]);
    private final Canonicalizer jsonCanonicalizer;
    private final StsTrustChain stsTrustChain;
    private final JsonSecurityContextSerializer deserializer = new JsonSecurityContextSerializer();

    public JsonSignerImpl(Canonicalizer jsonCanonicalizer) {
        this(jsonCanonicalizer, null);
    }

    public JsonSignerImpl(Canonicalizer jsonCanonicalizer, StsTrustChain stsTrustChain) {
        Validate.notNull((Object)jsonCanonicalizer);
        this.jsonCanonicalizer = jsonCanonicalizer;
        this.stsTrustChain = stsTrustChain;
    }

    @Override
    public String sign(String jsonMessage, SamlToken token, PrivateKey privateKey) {
        String signatureValue;
        Validate.notNull((Object)jsonMessage);
        Validate.notNull((Object)token);
        if (!token.getConfirmationType().equals((Object)ConfirmationType.HOLDER_OF_KEY)) {
            throw new SignatureException(HOK_ERROR);
        }
        Validate.notNull((Object)privateKey);
        try {
            signatureValue = this.sign(this.jsonCanonicalizer.asCanonicalString(jsonMessage), privateKey);
        }
        catch (InvalidKeyException e) {
            throw new SignatureException(SIGN_ERROR, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException(SIGN_ERROR, (Throwable)e);
        }
        catch (java.security.SignatureException e) {
            throw new SignatureException(SIGN_ERROR, (Throwable)e);
        }
        return signatureValue;
    }

    public boolean verifySignature(String jsonMessage, Map<String, Object> signature, long clockToleranceSec) {
        Validate.notNull((Object)jsonMessage);
        Validate.notNull(signature);
        Validate.isTrue((clockToleranceSec > -1L ? 1 : 0) != 0);
        if (this.stsTrustChain == null) {
            throw new IllegalStateException("STS trust chain retriever not set");
        }
        String message = this.stripSignature(jsonMessage);
        try {
            JsonSignatureStruct jsonSignature = JsonSignatureStruct.parseJsonSignatureStruct(signature, this.stsTrustChain.getStsTrustChain(), clockToleranceSec);
            if (!jsonSignature.getAlg().equalsIgnoreCase("RS256")) {
                throw new SignatureException(MessageFactory.getMessage((String)"vapi.signature.unknowndsigalg", (String[])new String[]{jsonSignature.getAlg()}));
            }
            return this.verify(jsonSignature.getSamlToken().getConfirmationCertificate(), this.jsonCanonicalizer.asCanonicalString(message), jsonSignature.getSigValue());
        }
        catch (InvalidKeyException e) {
            throw new SignatureException(VERIFY_ERROR, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException(VERIFY_ERROR, (Throwable)e);
        }
        catch (java.security.SignatureException e) {
            throw new SignatureException(VERIFY_ERROR, (Throwable)e);
        }
    }

    private String sign(String payload, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, java.security.SignatureException {
        assert (payload != null);
        assert (privateKey != null);
        Signature rsa = Signature.getInstance(SHA256_WITH_RSA);
        rsa.initSign(privateKey);
        try {
            rsa.update(payload.getBytes(UTF_8));
        }
        catch (UnsupportedEncodingException e) {
            throw new SignatureException(SIGN_ERROR, (Throwable)e);
        }
        return Base64.encodeBase64String((byte[])rsa.sign());
    }

    private boolean verify(X509Certificate certificate, String jsonMessage, String b64Signature) throws NoSuchAlgorithmException, InvalidKeyException, java.security.SignatureException {
        assert (certificate != null);
        assert (jsonMessage != null);
        assert (b64Signature != null);
        Signature rsa = Signature.getInstance(SHA256_WITH_RSA);
        rsa.initVerify(certificate);
        try {
            rsa.update(jsonMessage.getBytes(UTF_8));
        }
        catch (UnsupportedEncodingException e) {
            throw new SignatureException(VERIFY_ERROR, (Throwable)e);
        }
        return rsa.verify(Base64.decodeBase64((String)b64Signature));
    }

    private String stripSignature(String jsonMessage) {
        assert (jsonMessage != null);
        return this.deserializer.removeSignature(jsonMessage);
    }
}

