## @class Com::Vmware::Vcenter::Vm::GuestOS
#
# The  ``Com::Vmware::Vcenter::Vm::GuestOS``   *enumerated type*  defines the valid
#     guest operating system types used for configuring a virtual machine.
#
#
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DOS #
#MS-DOS.
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_31 #
#Windows 3.1
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_95 #
#Windows 95
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_98 #
#Windows 98
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_ME #
#Windows Millennium Edition
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_NT #
#Windows NT 4
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_2000_PRO #
#Windows 2000 Professional
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_2000_SERV #
#Windows 2000 Server
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_2000_ADV_SERV #
#Windows 2000 Advanced Server
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_XP_HOME #
#Windows XP Home Edition
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_XP_PRO #
#Windows XP Professional
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_XP_PRO_64 #
#Windows XP Professional Edition (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_NET_WEB #
#Windows Server 2003, Web Edition
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_NET_STANDARD #
#Windows Server 2003, Standard Edition
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_NET_ENTERPRISE #
#Windows Server 2003, Enterprise Edition
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_NET_DATACENTER #
#Windows Server 2003, Datacenter Edition
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_NET_BUSINESS #
#Windows Small Business Server 2003
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_NET_STANDARD_64 #
#Windows Server 2003, Standard Edition (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_NET_ENTERPRISE_64 #
#Windows Server 2003, Enterprise Edition (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_LONGHORN #
#Windows Longhorn (experimental)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_LONGHORN_64 #
#Windows Longhorn (64 bit) (experimental)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_NET_DATACENTER_64 #
#Windows Server 2003, Datacenter Edition (64 bit) (experimental)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_VISTA #
#Windows Vista
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WIN_VISTA_64 #
#Windows Vista (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WINDOWS_7 #
#Windows 7
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WINDOWS_7_64 #
#Windows 7 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WINDOWS_7_SERVER_64 #
#Windows Server 2008 R2 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WINDOWS_8 #
#Windows 8
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WINDOWS_8_64 #
#Windows 8 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WINDOWS_8_SERVER_64 #
#Windows 8 Server (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WINDOWS_9 #
#Windows 10
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WINDOWS_9_64 #
#Windows 10 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WINDOWS_9_SERVER_64 #
#Windows 10 Server (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::WINDOWS_HYPERV #
#Windows Hyper-V
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::FREEBSD #
#FreeBSD
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::FREEBSD_64 #
#FreeBSD x64
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::REDHAT #
#Red Hat Linux 2.1
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::RHEL_2 #
#Red Hat Enterprise Linux 2
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::RHEL_3 #
#Red Hat Enterprise Linux 3
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::RHEL_3_64 #
#Red Hat Enterprise Linux 3 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::RHEL_4 #
#Red Hat Enterprise Linux 4
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::RHEL_4_64 #
#Red Hat Enterprise Linux 4 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::RHEL_5 #
#Red Hat Enterprise Linux 5
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::RHEL_5_64 #
#Red Hat Enterprise Linux 5 (64 bit) (experimental)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::RHEL_6 #
#Red Hat Enterprise Linux 6
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::RHEL_6_64 #
#Red Hat Enterprise Linux 6 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::RHEL_7 #
#Red Hat Enterprise Linux 7
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::RHEL_7_64 #
#Red Hat Enterprise Linux 7 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::CENTOS #
#CentOS 4/5
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::CENTOS_64 #
#CentOS 4/5 (64-bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::CENTOS_6 #
#CentOS 6
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::CENTOS_6_64 #
#CentOS 6 (64-bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::CENTOS_7 #
#CentOS 7
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::CENTOS_7_64 #
#CentOS 7 (64-bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::ORACLE_LINUX #
#Oracle Linux 4/5
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::ORACLE_LINUX_64 #
#Oracle Linux 4/5 (64-bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::ORACLE_LINUX_6 #
#Oracle Linux 6
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::ORACLE_LINUX_6_64 #
#Oracle Linux 6 (64-bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::ORACLE_LINUX_7 #
#Oracle Linux 7
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::ORACLE_LINUX_7_64 #
#Oracle Linux 7 (64-bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::SUSE #
#Suse Linux
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::SUSE_64 #
#Suse Linux (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::SLES #
#Suse Linux Enterprise Server 9
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::SLES_64 #
#Suse Linux Enterprise Server 9 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::SLES_10 #
#Suse linux Enterprise Server 10
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::SLES_10_64 #
#Suse Linux Enterprise Server 10 (64 bit) (experimental)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::SLES_11 #
#Suse linux Enterprise Server 11
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::SLES_11_64 #
#Suse Linux Enterprise Server 11 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::SLES_12 #
#Suse linux Enterprise Server 12
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::SLES_12_64 #
#Suse Linux Enterprise Server 12 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::NLD_9 #
#Novell Linux Desktop 9
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::OES #
#Open Enterprise Server
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::SJDS #
#Sun Java Desktop System
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::MANDRAKE #
#Mandrake Linux
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::MANDRIVA #
#Mandriva Linux
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::MANDRIVA_64 #
#Mandriva Linux (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::TURBO_LINUX #
#Turbolinux
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::TURBO_LINUX_64 #
#Turbolinux (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::UBUNTU #
#Ubuntu Linux
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::UBUNTU_64 #
#Ubuntu Linux (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DEBIAN_4 #
#Debian GNU/Linux 4
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DEBIAN_4_64 #
#Debian GNU/Linux 4 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DEBIAN_5 #
#Debian GNU/Linux 5
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DEBIAN_5_64 #
#Debian GNU/Linux 5 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DEBIAN_6 #
#Debian GNU/Linux 6
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DEBIAN_6_64 #
#Debian GNU/Linux 6 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DEBIAN_7 #
#Debian GNU/Linux 7
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DEBIAN_7_64 #
#Debian GNU/Linux 7 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DEBIAN_8 #
#Debian GNU/Linux 8
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DEBIAN_8_64 #
#Debian GNU/Linux 8 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DEBIAN_9 #
#Debian GNU/Linux 9
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DEBIAN_9_64 #
#Debian GNU/Linux 9 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DEBIAN_10 #
#Debian GNU/Linux 10
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DEBIAN_10_64 #
#Debian GNU/Linux 10 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::ASIANUX_3 #
#Asianux Server 3
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::ASIANUX_3_64 #
#Asianux Server 3 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::ASIANUX_4 #
#Asianux Server 4
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::ASIANUX_4_64 #
#Asianux Server 4 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::ASIANUX_5_64 #
#Asianux Server 5 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::ASIANUX_7_64 #
#Asianux Server 7 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::OPENSUSE #
#OpenSUSE Linux
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::OPENSUSE_64 #
#OpenSUSE Linux (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::FEDORA #
#Fedora Linux
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::FEDORA_64 #
#Fedora Linux (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::COREOS_64 #
#CoreOS Linux (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::VMWARE_PHOTON_64 #
#VMware Photon (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::OTHER_24X_LINUX #
#Linux 2.4x Kernel
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::OTHER_24X_LINUX_64 #
#Linux 2.4x Kernel (64 bit) (experimental)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::OTHER_26X_LINUX #
#Linux 2.6x Kernel
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::OTHER_26X_LINUX_64 #
#Linux 2.6x Kernel (64 bit) (experimental)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::OTHER_3X_LINUX #
#Linux 3.x Kernel
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::OTHER_3X_LINUX_64 #
#Linux 3.x Kernel (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::OTHER_LINUX #
#Linux 2.2x Kernel
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::GENERIC_LINUX #
#Other Linux
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::OTHER_LINUX_64 #
#Linux (64 bit) (experimental)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::SOLARIS_6 #
#Solaris 6
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::SOLARIS_7 #
#Solaris 7
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::SOLARIS_8 #
#Solaris 8
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::SOLARIS_9 #
#Solaris 9
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::SOLARIS_10 #
#Solaris 10 (32 bit) (experimental)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::SOLARIS_10_64 #
#Solaris 10 (64 bit) (experimental)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::SOLARIS_11_64 #
#Solaris 11 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::O_S2 #
#OS/2
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::ECOMSTATION #
#eComStation 1.x
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::ECOMSTATION_2 #
#eComStation 2.0
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::NETWARE_4 #
#Novell NetWare 4
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::NETWARE_5 #
#Novell NetWare 5.1
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::NETWARE_6 #
#Novell NetWare 6.x
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::OPENSERVER_5 #
#SCO OpenServer 5
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::OPENSERVER_6 #
#SCO OpenServer 6
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::UNIXWARE_7 #
#SCO UnixWare 7
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DARWIN #
#Mac OS 10.5
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DARWIN_64 #
#Mac OS 10.5 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DARWIN_10 #
#Mac OS 10.6
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DARWIN_10_64 #
#Mac OS 10.6 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DARWIN_11 #
#Mac OS 10.7
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DARWIN_11_64 #
#Mac OS 10.7 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DARWIN_12_64 #
#Mac OS 10.8 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DARWIN_13_64 #
#Mac OS 10.9 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DARWIN_14_64 #
#Mac OS 10.10 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DARWIN_15_64 #
#Mac OS 10.11 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::DARWIN_16_64 #
#Mac OS 10.12 (64 bit)
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::VMKERNEL #
#VMware ESX 4
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::VMKERNEL_5 #
#VMware ESX 5
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::VMKERNEL_6 #
#VMware ESX 6
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::VMKERNEL_65 #
#VMware ESX 6.5
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::OTHER #
#Other Operating System
#
# Constant Com::Vmware::Vcenter::Vm::GuestOS::OTHER_64 #
#Other Operating System (64 bit) (experimental)

package Com::Vmware::Vcenter::Vm::GuestOS;

use constant {
    DOS =>  'DOS',
    WIN_31 =>  'WIN_31',
    WIN_95 =>  'WIN_95',
    WIN_98 =>  'WIN_98',
    WIN_ME =>  'WIN_ME',
    WIN_NT =>  'WIN_NT',
    WIN_2000_PRO =>  'WIN_2000_PRO',
    WIN_2000_SERV =>  'WIN_2000_SERV',
    WIN_2000_ADV_SERV =>  'WIN_2000_ADV_SERV',
    WIN_XP_HOME =>  'WIN_XP_HOME',
    WIN_XP_PRO =>  'WIN_XP_PRO',
    WIN_XP_PRO_64 =>  'WIN_XP_PRO_64',
    WIN_NET_WEB =>  'WIN_NET_WEB',
    WIN_NET_STANDARD =>  'WIN_NET_STANDARD',
    WIN_NET_ENTERPRISE =>  'WIN_NET_ENTERPRISE',
    WIN_NET_DATACENTER =>  'WIN_NET_DATACENTER',
    WIN_NET_BUSINESS =>  'WIN_NET_BUSINESS',
    WIN_NET_STANDARD_64 =>  'WIN_NET_STANDARD_64',
    WIN_NET_ENTERPRISE_64 =>  'WIN_NET_ENTERPRISE_64',
    WIN_LONGHORN =>  'WIN_LONGHORN',
    WIN_LONGHORN_64 =>  'WIN_LONGHORN_64',
    WIN_NET_DATACENTER_64 =>  'WIN_NET_DATACENTER_64',
    WIN_VISTA =>  'WIN_VISTA',
    WIN_VISTA_64 =>  'WIN_VISTA_64',
    WINDOWS_7 =>  'WINDOWS_7',
    WINDOWS_7_64 =>  'WINDOWS_7_64',
    WINDOWS_7_SERVER_64 =>  'WINDOWS_7_SERVER_64',
    WINDOWS_8 =>  'WINDOWS_8',
    WINDOWS_8_64 =>  'WINDOWS_8_64',
    WINDOWS_8_SERVER_64 =>  'WINDOWS_8_SERVER_64',
    WINDOWS_9 =>  'WINDOWS_9',
    WINDOWS_9_64 =>  'WINDOWS_9_64',
    WINDOWS_9_SERVER_64 =>  'WINDOWS_9_SERVER_64',
    WINDOWS_HYPERV =>  'WINDOWS_HYPERV',
    FREEBSD =>  'FREEBSD',
    FREEBSD_64 =>  'FREEBSD_64',
    REDHAT =>  'REDHAT',
    RHEL_2 =>  'RHEL_2',
    RHEL_3 =>  'RHEL_3',
    RHEL_3_64 =>  'RHEL_3_64',
    RHEL_4 =>  'RHEL_4',
    RHEL_4_64 =>  'RHEL_4_64',
    RHEL_5 =>  'RHEL_5',
    RHEL_5_64 =>  'RHEL_5_64',
    RHEL_6 =>  'RHEL_6',
    RHEL_6_64 =>  'RHEL_6_64',
    RHEL_7 =>  'RHEL_7',
    RHEL_7_64 =>  'RHEL_7_64',
    CENTOS =>  'CENTOS',
    CENTOS_64 =>  'CENTOS_64',
    CENTOS_6 =>  'CENTOS_6',
    CENTOS_6_64 =>  'CENTOS_6_64',
    CENTOS_7 =>  'CENTOS_7',
    CENTOS_7_64 =>  'CENTOS_7_64',
    ORACLE_LINUX =>  'ORACLE_LINUX',
    ORACLE_LINUX_64 =>  'ORACLE_LINUX_64',
    ORACLE_LINUX_6 =>  'ORACLE_LINUX_6',
    ORACLE_LINUX_6_64 =>  'ORACLE_LINUX_6_64',
    ORACLE_LINUX_7 =>  'ORACLE_LINUX_7',
    ORACLE_LINUX_7_64 =>  'ORACLE_LINUX_7_64',
    SUSE =>  'SUSE',
    SUSE_64 =>  'SUSE_64',
    SLES =>  'SLES',
    SLES_64 =>  'SLES_64',
    SLES_10 =>  'SLES_10',
    SLES_10_64 =>  'SLES_10_64',
    SLES_11 =>  'SLES_11',
    SLES_11_64 =>  'SLES_11_64',
    SLES_12 =>  'SLES_12',
    SLES_12_64 =>  'SLES_12_64',
    NLD_9 =>  'NLD_9',
    OES =>  'OES',
    SJDS =>  'SJDS',
    MANDRAKE =>  'MANDRAKE',
    MANDRIVA =>  'MANDRIVA',
    MANDRIVA_64 =>  'MANDRIVA_64',
    TURBO_LINUX =>  'TURBO_LINUX',
    TURBO_LINUX_64 =>  'TURBO_LINUX_64',
    UBUNTU =>  'UBUNTU',
    UBUNTU_64 =>  'UBUNTU_64',
    DEBIAN_4 =>  'DEBIAN_4',
    DEBIAN_4_64 =>  'DEBIAN_4_64',
    DEBIAN_5 =>  'DEBIAN_5',
    DEBIAN_5_64 =>  'DEBIAN_5_64',
    DEBIAN_6 =>  'DEBIAN_6',
    DEBIAN_6_64 =>  'DEBIAN_6_64',
    DEBIAN_7 =>  'DEBIAN_7',
    DEBIAN_7_64 =>  'DEBIAN_7_64',
    DEBIAN_8 =>  'DEBIAN_8',
    DEBIAN_8_64 =>  'DEBIAN_8_64',
    DEBIAN_9 =>  'DEBIAN_9',
    DEBIAN_9_64 =>  'DEBIAN_9_64',
    DEBIAN_10 =>  'DEBIAN_10',
    DEBIAN_10_64 =>  'DEBIAN_10_64',
    ASIANUX_3 =>  'ASIANUX_3',
    ASIANUX_3_64 =>  'ASIANUX_3_64',
    ASIANUX_4 =>  'ASIANUX_4',
    ASIANUX_4_64 =>  'ASIANUX_4_64',
    ASIANUX_5_64 =>  'ASIANUX_5_64',
    ASIANUX_7_64 =>  'ASIANUX_7_64',
    OPENSUSE =>  'OPENSUSE',
    OPENSUSE_64 =>  'OPENSUSE_64',
    FEDORA =>  'FEDORA',
    FEDORA_64 =>  'FEDORA_64',
    COREOS_64 =>  'COREOS_64',
    VMWARE_PHOTON_64 =>  'VMWARE_PHOTON_64',
    OTHER_24X_LINUX =>  'OTHER_24X_LINUX',
    OTHER_24X_LINUX_64 =>  'OTHER_24X_LINUX_64',
    OTHER_26X_LINUX =>  'OTHER_26X_LINUX',
    OTHER_26X_LINUX_64 =>  'OTHER_26X_LINUX_64',
    OTHER_3X_LINUX =>  'OTHER_3X_LINUX',
    OTHER_3X_LINUX_64 =>  'OTHER_3X_LINUX_64',
    OTHER_LINUX =>  'OTHER_LINUX',
    GENERIC_LINUX =>  'GENERIC_LINUX',
    OTHER_LINUX_64 =>  'OTHER_LINUX_64',
    SOLARIS_6 =>  'SOLARIS_6',
    SOLARIS_7 =>  'SOLARIS_7',
    SOLARIS_8 =>  'SOLARIS_8',
    SOLARIS_9 =>  'SOLARIS_9',
    SOLARIS_10 =>  'SOLARIS_10',
    SOLARIS_10_64 =>  'SOLARIS_10_64',
    SOLARIS_11_64 =>  'SOLARIS_11_64',
    OS2 =>  'OS2',
    ECOMSTATION =>  'ECOMSTATION',
    ECOMSTATION_2 =>  'ECOMSTATION_2',
    NETWARE_4 =>  'NETWARE_4',
    NETWARE_5 =>  'NETWARE_5',
    NETWARE_6 =>  'NETWARE_6',
    OPENSERVER_5 =>  'OPENSERVER_5',
    OPENSERVER_6 =>  'OPENSERVER_6',
    UNIXWARE_7 =>  'UNIXWARE_7',
    DARWIN =>  'DARWIN',
    DARWIN_64 =>  'DARWIN_64',
    DARWIN_10 =>  'DARWIN_10',
    DARWIN_10_64 =>  'DARWIN_10_64',
    DARWIN_11 =>  'DARWIN_11',
    DARWIN_11_64 =>  'DARWIN_11_64',
    DARWIN_12_64 =>  'DARWIN_12_64',
    DARWIN_13_64 =>  'DARWIN_13_64',
    DARWIN_14_64 =>  'DARWIN_14_64',
    DARWIN_15_64 =>  'DARWIN_15_64',
    DARWIN_16_64 =>  'DARWIN_16_64',
    VMKERNEL =>  'VMKERNEL',
    VMKERNEL_5 =>  'VMKERNEL_5',
    VMKERNEL_6 =>  'VMKERNEL_6',
    VMKERNEL_65 =>  'VMKERNEL_65',
    OTHER =>  'OTHER',
    OTHER_64 =>  'OTHER_64',
};

#
# Base class
#
use base qw(Com::Vmware::Vapi::Bindings::VapiEnum);

## @method new ()
# Constructor to initialize the Com::Vmware::Vcenter::Vm::GuestOS enumeration.
#
# @retval
# Blessed object
#
sub new {
   my ($class, %args) = @_;
   $class = ref($class) || $class;
   my $self = $class->SUPER::new();
   my $bindingType = new Com::Vmware::Vapi::Bindings::Type::EnumType(
                           'name' => 'com.vmware.vcenter.vm.guest_OS',
                           'binding_class' => 'Com::Vmware::Vcenter::Vm::GuestOS');
   $class->SUPER::set_binding_type('binding_type' => $bindingType);

   bless $self, $class;
   return $self;
}

1;

