#!/usr/bin/perl

#
# Perl Core Modules
#
use strict;

#
# vApi runtime libraries
#
use Com::Vmware::Vcenter::Folder;
use Com::Vmware::Vapi::Util::Logger qw(log_info log_dumper log_framework log_warning set_verbosity);

#
# Helper class with methods to get identifier of a folder
#
package Vcenter::Helpers::FolderHelper;

#
# Returns the identifier of a folder
#
# Note: The method assumes that there is only one folder and datacenter
# with the mentioned names.
# @param stubFactory Stub factory for the api endpoint
# @param sessionStubConfig stub configuration for the current session
# @param datacenterName name of the datacenter
# @param folderName name of the folder
# @return identifier of a datacenter
#
sub getFolder
{
    my (%args) = @_;
    my $stubFactory = $args {'stubFactory'};
    my $sessionStubConfig = $args {'sessionStubConfig'};
    my $datacenterName = $args {'datacenterName'};
    my $folderName = $args {'vmFolderName'};

    # Get the datacenter
	my $get_datacenter = Vcenter::Helpers::DatacenterHelper::getDatacenter('stubFactory' => $stubFactory, 'sessionStubConfig' => $sessionStubConfig, 'datacenterName' => $datacenterName);
	my @datacenters = ($get_datacenter);
	# Get the folder
	my $folder_service = $stubFactory->create_stub( 'service_name' => 'Com::Vmware::Vcenter::Folder',
                                            'stub_config'  => $sessionStubConfig );
    my @vmFolders = ($folderName);
    my $folderFilterSpec = new Com::Vmware::Vcenter::Folder::FilterSpec();
    $folderFilterSpec->set_names('names' => \@vmFolders);
    $folderFilterSpec->set_datacenters('datacenters' => \@datacenters);

    my $folderSummaries = $folder_service->list('filter' => $folderFilterSpec);
    if (scalar(@$folderSummaries) == 0){
        Com::Vmware::Vapi::Util::Logger::log_info(MSG => "Folder '".$folderName."' not found in datacenter: '".$datacenterName."'" );
        exit();
    }
    return $folderSummaries->[0]->get_folder();
}

1;
