"""
Helper functions for configuring logging in vapi runtime
"""

__author__ = 'VMware, Inc.'
__copyright__ = 'Copyright (c) 2016 VMware, Inc.  All rights reserved.'

import logging

RAW_REQUEST_LOGGER = '%s.rawrequest' % __name__

_raw_request_logger = logging.getLogger(RAW_REQUEST_LOGGER)

# Turn off propagation so that the log events do not reach parent handlers.
_raw_request_logger.propagate = False

# Add a null handler otherwise logging will complain that no handlers are
# configured. Typically root logger has handlers configured and each logger in
# the hierarchy gets those handlers too due to propagation.
_raw_request_logger.addHandler(logging.NullHandler())


def get_raw_request_logger():
    """
    Return the the raw request logger that is not propagated to root logger and
    disabled by default.
    :rtype: :class:`logging.Logger`
    :return: Raw request logger
    """
    return _raw_request_logger
