/*
 * Decompiled with CFR 0.152.
 */
package javax.cim;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsignedInteger32
extends Number
implements Comparable<UnsignedInteger32> {
    private static final long serialVersionUID = -8861436527534071393L;
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    public static final long MIN_VALUE = 0L;
    private long iValue;

    private void setValue(long pValue) throws NumberFormatException {
        if (pValue > 0xFFFFFFFFL || pValue < 0L) {
            String msg = "uint32:" + pValue + " is out of range!";
            throw new NumberFormatException(msg);
        }
        this.iValue = pValue;
    }

    public UnsignedInteger32(long pValue) throws NumberFormatException {
        this.setValue(pValue);
    }

    public UnsignedInteger32(String pValue) throws NumberFormatException {
        this.setValue(Long.parseLong(pValue));
    }

    public boolean equals(Object pObj) {
        if (!(pObj instanceof UnsignedInteger32)) {
            return false;
        }
        return this.iValue == ((UnsignedInteger32)pObj).iValue;
    }

    @Override
    public byte byteValue() {
        return (byte)this.iValue;
    }

    @Override
    public short shortValue() {
        return (short)this.iValue;
    }

    @Override
    public long longValue() {
        return this.iValue;
    }

    @Override
    public double doubleValue() {
        return this.iValue;
    }

    @Override
    public float floatValue() {
        return this.iValue;
    }

    @Override
    public int intValue() {
        return (int)this.iValue;
    }

    @Override
    public int compareTo(UnsignedInteger32 pOther) {
        UnsignedInteger32 that = pOther;
        long d = this.iValue - that.iValue;
        if (d == 0L) {
            return 0;
        }
        return d < 0L ? -1 : 1;
    }

    public String toString() {
        return Long.toString(this.iValue);
    }
}

