/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.cimxml.sax.node;

import javax.cim.CIMObjectPath;
import org.sblim.cimclient.internal.cimxml.LocalPathBuilder;
import org.sblim.cimclient.internal.cimxml.sax.SAXSession;
import org.sblim.cimclient.internal.cimxml.sax.node.AbstractObjectPathNode;
import org.sblim.cimclient.internal.cimxml.sax.node.ClassNameNode;
import org.sblim.cimclient.internal.cimxml.sax.node.LocalNameSpacePathNode;
import org.sblim.cimclient.internal.cimxml.sax.node.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LocalClassPathNode
extends AbstractObjectPathNode {
    private boolean iHasLocalNameSpacePath;
    private String iNameSpaceStr;
    private String iClassNameStr;
    private CIMObjectPath iLocalPath;

    public LocalClassPathNode() {
        super("LOCALCLASSPATH");
    }

    public void init(Attributes pAttribs, SAXSession pSession) {
        this.iLocalPath = pSession.getDefLocalPath();
        this.iHasLocalNameSpacePath = false;
        this.iClassNameStr = null;
    }

    public void parseData(String pData) {
    }

    public void testChild(String pNodeNameEnum) throws SAXException {
        if (pNodeNameEnum == "LOCALNAMESPACEPATH") {
            if (this.iNameSpaceStr != null) {
                throw new SAXException("LOCALCLASSPATH node already has a LOCALNAMESPACEPATH child node!");
            }
        } else if (pNodeNameEnum == "CLASSNAME") {
            if (this.iClassNameStr != null) {
                throw new SAXException("LOCALCLASSPATH node already has a CLASSNAME child node!");
            }
        } else {
            throw new SAXException("LOCALCLASSPATH node cannot have " + pNodeNameEnum + " child node!" + "It can have LOCALNAMESPACEPATH and CLASSNAME child nodes only!");
        }
    }

    public void childParsed(Node pChild) {
        if (pChild instanceof LocalNameSpacePathNode) {
            this.iNameSpaceStr = ((LocalNameSpacePathNode)pChild).getNameSpace();
            this.iHasLocalNameSpacePath = true;
        } else {
            this.iClassNameStr = ((ClassNameNode)pChild).getClassName();
        }
    }

    public void testCompletness() throws SAXException {
        if (!this.iHasLocalNameSpacePath) {
            throw new SAXException("LOCALNAMESPACE child node is mandatory for LOCALCLASSPATH node!");
        }
        if (this.iClassNameStr == null) {
            throw new SAXException("CLASSNAME child node is mandatory for LOCALCLASSPATH node!");
        }
    }

    public CIMObjectPath getCIMObjectPath() {
        return LocalPathBuilder.build(this.iLocalPath, this.iClassNameStr, this.iNameSpaceStr);
    }
}

