/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.uri;

import javax.cim.CIMDateTime;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMDateTimeInterval;
import org.sblim.cimclient.internal.uri.QuotedValue;
import org.sblim.cimclient.internal.uri.Value;

public class DateTimeValue
extends Value
implements QuotedValue {
    private CIMDateTime iDateTime;

    public static Value parse(String pStrVal, boolean pThrow) throws IllegalArgumentException {
        CIMDateTime dateTime;
        try {
            dateTime = new CIMDateTimeAbsolute(pStrVal);
        }
        catch (IllegalArgumentException e0) {
            try {
                dateTime = new CIMDateTimeInterval(pStrVal);
            }
            catch (IllegalArgumentException e1) {
                if (pThrow) {
                    String msg = "Value=" + pStrVal + "\nFailed to parse as DateTimeAbsolute!:\n" + e0.getMessage() + "\nFailed to parse as DateTimeInterval!:\n" + e1.getMessage();
                    throw new IllegalArgumentException(msg);
                }
                return null;
            }
        }
        return new DateTimeValue(dateTime);
    }

    public static Value parse(String pStrVal) {
        return DateTimeValue.parse(pStrVal, false);
    }

    private DateTimeValue(CIMDateTime pDateTime) {
        this.iDateTime = pDateTime;
    }

    public CIMDateTime getDateTime() {
        return this.iDateTime;
    }

    public String toString() {
        return this.iDateTime.toString();
    }

    public String toQuotedString() {
        return "\"" + this.iDateTime.toString() + '\"';
    }

    public String getTypeInfo() {
        return "datetime";
    }
}

