/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.wbem.indications;

import java.util.LinkedList;
import java.util.logging.Level;
import javax.wbem.listener.IndicationListener;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.sblim.cimclient.internal.wbem.indications.CIMEvent;

public class CIMEventDispatcher
extends Thread {
    protected LinkedList<CIMEvent> iEventQueue = new LinkedList();
    protected IndicationListener iListener = null;
    private boolean iAlive = true;
    private LogAndTraceBroker iLogger = LogAndTraceBroker.getBroker();

    public CIMEventDispatcher(IndicationListener pListener) {
        this.iListener = pListener;
        this.setDaemon(true);
        this.setName("CIMEventDispatcher");
        this.start();
    }

    public synchronized void dispatchEvent(CIMEvent pEvent) {
        if (pEvent != null) {
            this.iEventQueue.add(pEvent);
            this.iLogger.trace(Level.FINE, "Added CIMEvent (id=" + pEvent.getID() + " to the queue (" + this.iEventQueue.size() + " elements total)");
            this.notify();
        } else {
            this.iLogger.trace(Level.WARNING, "CIMEvent to dispatch was null");
        }
    }

    public synchronized void startup() {
        this.iAlive = true;
        this.start();
    }

    public synchronized void kill() {
        this.iAlive = false;
        this.notify();
    }

    public synchronized void close() {
        this.kill();
    }

    private synchronized CIMEvent getEvent() {
        CIMEvent event = null;
        while (event == null) {
            try {
                if (this.iEventQueue.size() == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.iAlive) break;
            if (this.iEventQueue.size() <= 0) continue;
            event = this.iEventQueue.remove(0);
            this.iLogger.trace(Level.FINER, "Removed CIMEvent (id=" + event.getID() + "from the queue (" + this.iEventQueue.size() + " elements left)");
        }
        return event;
    }

    public void run() {
        while (this.iAlive) {
            try {
                CIMEvent event = this.getEvent();
                if (event == null) continue;
                this.iLogger.trace(Level.FINER, "Processing CIMEvent (id=" + event.getID() + ")");
                try {
                    this.iListener.indicationOccured(event.getID(), event.getIndication());
                }
                catch (Throwable t) {
                    this.iLogger.trace(Level.FINE, "Exception caught in listener (" + this.iListener.getClass().getName() + ") while processing CIMEvent", t);
                }
            }
            catch (Throwable t) {
                this.iLogger.trace(Level.FINE, "Exception in event dispatcher loop", t);
            }
        }
    }
}

