/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal.msg;

import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.Socket;
import org.sblim.slp.ServiceLocationException;
import org.sblim.slp.internal.msg.AttributeReply;
import org.sblim.slp.internal.msg.AttributeRequest;
import org.sblim.slp.internal.msg.DAAdvert;
import org.sblim.slp.internal.msg.FunctionIDs;
import org.sblim.slp.internal.msg.MsgHeader;
import org.sblim.slp.internal.msg.SAAdvert;
import org.sblim.slp.internal.msg.SLPInputStream;
import org.sblim.slp.internal.msg.SLPMessage;
import org.sblim.slp.internal.msg.ServiceAcknowledgment;
import org.sblim.slp.internal.msg.ServiceDeregistration;
import org.sblim.slp.internal.msg.ServiceRegistration;
import org.sblim.slp.internal.msg.ServiceReply;
import org.sblim.slp.internal.msg.ServiceRequest;
import org.sblim.slp.internal.msg.ServiceTypeReply;
import org.sblim.slp.internal.msg.ServiceTypeRequest;

public class MsgFactory
implements FunctionIDs {
    private static FactoryEntry[] cFactoryArray;

    private static void placeFactory(int pFnID, FactoryEntry pEntry) {
        MsgFactory.cFactoryArray[pFnID - 1] = pEntry;
    }

    private static synchronized void createFactoryArray() {
        if (cFactoryArray != null) {
            return;
        }
        cFactoryArray = new FactoryEntry[11];
        for (int i = 0; i < cFactoryArray.length; ++i) {
            MsgFactory.cFactoryArray[i] = null;
        }
        MsgFactory.placeFactory(7, new FactoryEntry(){

            public SLPMessage parse(MsgHeader pHdr, SLPInputStream pInStr) throws ServiceLocationException, IOException {
                return AttributeReply.parse(pHdr, pInStr);
            }
        });
        MsgFactory.placeFactory(6, new FactoryEntry(){

            public SLPMessage parse(MsgHeader pHdr, SLPInputStream pInStr) throws ServiceLocationException, IOException {
                return AttributeRequest.parse(pHdr, pInStr);
            }
        });
        MsgFactory.placeFactory(8, new FactoryEntry(){

            public SLPMessage parse(MsgHeader pHdr, SLPInputStream pInStr) throws ServiceLocationException, IOException {
                return DAAdvert.parse(pHdr, pInStr);
            }
        });
        MsgFactory.placeFactory(11, new FactoryEntry(){

            public SLPMessage parse(MsgHeader pHdr, SLPInputStream pInStr) throws ServiceLocationException, IOException {
                return SAAdvert.parse(pHdr, pInStr);
            }
        });
        MsgFactory.placeFactory(5, new FactoryEntry(){

            public SLPMessage parse(MsgHeader pHdr, SLPInputStream pInStr) throws ServiceLocationException, IOException {
                return ServiceAcknowledgment.parse(pHdr, pInStr);
            }
        });
        MsgFactory.placeFactory(4, new FactoryEntry(){

            public SLPMessage parse(MsgHeader pHdr, SLPInputStream pInStr) throws ServiceLocationException, IOException {
                return ServiceDeregistration.parse(pHdr, pInStr);
            }
        });
        MsgFactory.placeFactory(3, new FactoryEntry(){

            public SLPMessage parse(MsgHeader pHdr, SLPInputStream pInStr) throws ServiceLocationException, IOException {
                return ServiceRegistration.parse(pHdr, pInStr);
            }
        });
        MsgFactory.placeFactory(2, new FactoryEntry(){

            public SLPMessage parse(MsgHeader pHdr, SLPInputStream pInStr) throws ServiceLocationException, IOException {
                return ServiceReply.parse(pHdr, pInStr);
            }
        });
        MsgFactory.placeFactory(1, new FactoryEntry(){

            public SLPMessage parse(MsgHeader pHdr, SLPInputStream pInStr) throws ServiceLocationException, IOException {
                return ServiceRequest.parse(pHdr, pInStr);
            }
        });
        MsgFactory.placeFactory(10, new FactoryEntry(){

            public SLPMessage parse(MsgHeader pHdr, SLPInputStream pInStr) throws ServiceLocationException, IOException {
                return ServiceTypeReply.parse(pHdr, pInStr);
            }
        });
        MsgFactory.placeFactory(9, new FactoryEntry(){

            public SLPMessage parse(MsgHeader pHdr, SLPInputStream pInStr) throws ServiceLocationException, IOException {
                return ServiceTypeRequest.parse(pHdr, pInStr);
            }
        });
    }

    private static FactoryEntry getFactory(int pFnID) {
        MsgFactory.createFactoryArray();
        return cFactoryArray[pFnID - 1];
    }

    public static SLPMessage parse(Socket pSock) throws ServiceLocationException, IOException {
        return MsgFactory.parse(pSock.getInputStream());
    }

    public static SLPMessage parse(InputStream pInStr) throws ServiceLocationException, IOException {
        return MsgFactory.parse(new SLPInputStream(pInStr));
    }

    public static SLPMessage parse(DatagramPacket pPacket) throws ServiceLocationException, IOException {
        return MsgFactory.parse(new SLPInputStream(pPacket));
    }

    public static SLPMessage parse(SLPInputStream pInStr) throws ServiceLocationException, IOException {
        MsgHeader hdr = MsgHeader.parse(pInStr);
        FactoryEntry factory = MsgFactory.getFactory(hdr.getFunctionID());
        if (factory == null) {
            throw new ServiceLocationException(16, "FunctionID=" + hdr.getFunctionID() + " is not implemented!");
        }
        return factory.parse(hdr, pInStr);
    }

    private static interface FactoryEntry {
        public SLPMessage parse(MsgHeader var1, SLPInputStream var2) throws ServiceLocationException, IOException;
    }
}

