/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal.msg;

import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.sblim.slp.ServiceLocationException;
import org.sblim.slp.internal.msg.MsgHeader;
import org.sblim.slp.internal.msg.SLPMessage;
import org.sblim.slp.internal.msg.SLPOutputStream;
import org.sblim.slp.internal.msg.SerializeOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequestMessage
extends SLPMessage {
    private SortedSet<String> iPrevResponderSet;
    private List<String> iScopeList;

    public RequestMessage(int pFunctionID, SortedSet<String> pPrevResponderSet, List<String> pScopeList) {
        super(pFunctionID);
        this.init(pPrevResponderSet, pScopeList);
    }

    public RequestMessage(int pFunctionID, String pLangTag, SortedSet<String> pPrevResponderSet, List<String> pScopeList) {
        super(pFunctionID, pLangTag);
        this.init(pPrevResponderSet, pScopeList);
    }

    public RequestMessage(MsgHeader pHeader, SortedSet<String> pPrevResponderSet, List<String> pScopeList) {
        super(pHeader);
        this.init(pPrevResponderSet, pScopeList);
    }

    public SortedSet<String> getPrevResponderSet() {
        return this.iPrevResponderSet;
    }

    public Iterator<String> getPrevRespondersItr() {
        return this.iPrevResponderSet == null ? null : this.iPrevResponderSet.iterator();
    }

    public boolean updatePrevResponders(String pResponder) {
        if (this.iPrevResponderSet == null) {
            this.iPrevResponderSet = new TreeSet<String>();
        }
        return this.iPrevResponderSet.add(pResponder);
    }

    public List<String> getScopeList() {
        return this.iScopeList;
    }

    public boolean isAllowedResponseType(SLPMessage pRspMsg) {
        if (pRspMsg == null) {
            return false;
        }
        int id = pRspMsg.getFunctionID();
        int[] rspIDs = this.getAllowedResponseIDs();
        if (rspIDs == null) {
            return true;
        }
        for (int i = 0; i < rspIDs.length; ++i) {
            if (id != rspIDs[i]) continue;
            return true;
        }
        return false;
    }

    public byte[] serializeWithoutResponders(boolean pSetMulticastFlag, boolean pDatagramLimited, boolean pKeepXID) throws ServiceLocationException {
        return this.serialize(pSetMulticastFlag, pDatagramLimited, pKeepXID, new SkipResponders());
    }

    @Override
    protected boolean serializeBody(SLPOutputStream pOutStr, SerializeOption pSkipResponders) throws ServiceLocationException {
        if (!pOutStr.writeStringList(pSkipResponders == null ? this.getPrevRespondersItr() : null)) {
            throw new ServiceLocationException(100, "Previous responder list has overflowed!");
        }
        return this.serializeRequestBody(pOutStr);
    }

    protected abstract boolean serializeRequestBody(SLPOutputStream var1) throws ServiceLocationException;

    protected abstract int[] getAllowedResponseIDs();

    private void init(SortedSet<String> pPrevResponderSet, List<String> pScopeList) {
        this.iPrevResponderSet = pPrevResponderSet;
        this.iScopeList = pScopeList;
    }

    class SkipResponders
    extends SerializeOption {
        SkipResponders() {
        }
    }
}

