/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal.sa;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.sblim.slp.internal.SLPConfig;
import org.sblim.slp.internal.TRC;
import org.sblim.slp.internal.sa.RecieverThread;
import org.sblim.slp.internal.sa.ServiceAgent;

public class TCPThread
extends RecieverThread {
    private ServerSocket iListenerSocket;

    public TCPThread(ServiceAgent pSrvAgent) {
        super("TCP receiver", pSrvAgent);
    }

    protected void init() throws IOException {
        this.iListenerSocket = new ServerSocket(SLPConfig.getGlobalCfg().getPort());
        this.iListenerSocket.setReuseAddress(true);
        this.iListenerSocket.setSoTimeout(100);
    }

    protected void mainLoop() throws IOException {
        try {
            new ConnectionThread(this.iListenerSocket.accept());
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
    }

    protected void close() {
        if (this.iListenerSocket == null) {
            return;
        }
        try {
            this.iListenerSocket.close();
        }
        catch (IOException e) {
            TRC.error(e);
        }
    }

    private class ConnectionThread
    implements Runnable {
        private Socket iSock;

        public ConnectionThread(Socket pSock) {
            this.iSock = pSock;
            new Thread(this).start();
        }

        public void run() {
            TCPThread.this.iSrvAgent.processMessage(this.iSock);
        }
    }
}

