/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.spbm.samples;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.pbm.InvalidArgumentFaultMsg;
import com.vmware.pbm.PbmCapabilityProfile;
import com.vmware.pbm.PbmDuplicateNameFaultMsg;
import com.vmware.pbm.PbmFaultProfileStorageFaultFaultMsg;
import com.vmware.pbm.PbmProfileOperationOutcome;
import com.vmware.pbm.PbmServiceInstanceContent;
import com.vmware.spbm.connection.ConnectedServiceBase;
import com.vmware.spbm.connection.helpers.PbmUtil;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Sample(name="deleteprofile", description="Deletes a specified storage profile.")
public class DeleteProfile
extends ConnectedServiceBase {
    private PbmServiceInstanceContent spbmsc;
    private String profileName;
    private PbmCapabilityProfile profile;

    @Action
    public void deleteProfile() throws RuntimeFaultFaultMsg, com.vmware.pbm.RuntimeFaultFaultMsg, InvalidArgumentFaultMsg, PbmDuplicateNameFaultMsg, PbmFaultProfileStorageFaultFaultMsg {
        Object object2;
        this.spbmsc = this.connection.getPbmServiceContent();
        ManagedObjectReference managedObjectReference = this.spbmsc.getProfileManager();
        List list = this.connection.getPbmPort().pbmQueryProfile(managedObjectReference, PbmUtil.getStorageResourceType(), null);
        if (list == null || list.isEmpty()) {
            throw new RuntimeFaultFaultMsg("No storage Profiles exist.", null);
        }
        List list2 = this.connection.getPbmPort().pbmRetrieveContent(managedObjectReference, list);
        for (Object object2 : list2) {
            if (!object2.getName().equals(this.profileName)) continue;
            this.profile = (PbmCapabilityProfile)object2;
        }
        if (this.profile == null) {
            throw new InvalidArgumentFaultMsg("Specified storage profile name does not exist.", null);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.profile.getProfileId());
        object2 = this.connection.getPbmPort().pbmDelete(managedObjectReference, (List)arrayList);
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            PbmProfileOperationOutcome pbmProfileOperationOutcome = (PbmProfileOperationOutcome)iterator.next();
            if (pbmProfileOperationOutcome.getFault() == null) continue;
            throw new RuntimeFaultFaultMsg("Unable to delete the Profile." + pbmProfileOperationOutcome.getFault().getFault(), null);
        }
        System.out.println("Profile " + this.profileName + " deleted. ");
    }

    @Option(name="profilename", description="Name of the storage profile", required=true)
    public void setProfileName(String string) {
        this.profileName = string;
    }
}

