/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.spbm.samples;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.pbm.InvalidArgumentFaultMsg;
import com.vmware.pbm.PbmCapabilityProfile;
import com.vmware.pbm.PbmProfile;
import com.vmware.pbm.PbmServiceInstanceContent;
import com.vmware.spbm.connection.ConnectedServiceBase;
import com.vmware.spbm.connection.helpers.PbmUtil;
import com.vmware.spbm.connection.helpers.VCUtil;
import com.vmware.vim25.AlreadyExistsFaultMsg;
import com.vmware.vim25.ConfigTarget;
import com.vmware.vim25.DatastoreSummary;
import com.vmware.vim25.DuplicateNameFaultMsg;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.InsufficientResourcesFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidNameFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NetworkSummary;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.OutOfBoundsFaultMsg;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInProgressFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.VirtualCdrom;
import com.vmware.vim25.VirtualCdromIsoBackingInfo;
import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualDeviceBackingInfo;
import com.vmware.vim25.VirtualDeviceConfigSpec;
import com.vmware.vim25.VirtualDeviceConfigSpecFileOperation;
import com.vmware.vim25.VirtualDeviceConfigSpecOperation;
import com.vmware.vim25.VirtualDisk;
import com.vmware.vim25.VirtualDiskFlatVer2BackingInfo;
import com.vmware.vim25.VirtualEthernetCardNetworkBackingInfo;
import com.vmware.vim25.VirtualFloppy;
import com.vmware.vim25.VirtualFloppyDeviceBackingInfo;
import com.vmware.vim25.VirtualIDEController;
import com.vmware.vim25.VirtualLsiLogicController;
import com.vmware.vim25.VirtualMachineConfigOption;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VirtualMachineDatastoreInfo;
import com.vmware.vim25.VirtualMachineDefinedProfileSpec;
import com.vmware.vim25.VirtualMachineFileInfo;
import com.vmware.vim25.VirtualMachineNetworkInfo;
import com.vmware.vim25.VirtualPCNet32;
import com.vmware.vim25.VirtualSCSISharing;
import com.vmware.vim25.VmConfigFaultFaultMsg;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Sample(name="vm-create", description="This sample creates a VM based on a storage profile.")
public class VMCreate
extends ConnectedServiceBase {
    private String dataStore;
    private String virtualMachineName;
    private long vmMemory = 1024L;
    private int numCpus = 1;
    private String dataCenterName;
    private int diskSize = 1;
    private String hostname;
    private String guestOsId = "windows7Guest";
    private String profileName;

    VirtualDeviceConfigSpec createVirtualDisk(String string, int n, ManagedObjectReference managedObjectReference) {
        String string2 = this.getVolumeName(string);
        VirtualDeviceConfigSpec virtualDeviceConfigSpec = new VirtualDeviceConfigSpec();
        virtualDeviceConfigSpec.setFileOperation(VirtualDeviceConfigSpecFileOperation.CREATE);
        virtualDeviceConfigSpec.setOperation(VirtualDeviceConfigSpecOperation.ADD);
        VirtualDisk virtualDisk = new VirtualDisk();
        VirtualDiskFlatVer2BackingInfo virtualDiskFlatVer2BackingInfo = new VirtualDiskFlatVer2BackingInfo();
        virtualDiskFlatVer2BackingInfo.setFileName(string2);
        virtualDiskFlatVer2BackingInfo.setDiskMode("persistent");
        virtualDisk.setKey(new Integer(0).intValue());
        virtualDisk.setControllerKey(new Integer(n));
        virtualDisk.setUnitNumber(new Integer(0));
        virtualDisk.setBacking((VirtualDeviceBackingInfo)virtualDiskFlatVer2BackingInfo);
        virtualDisk.setCapacityInKB(1024L);
        virtualDeviceConfigSpec.setDevice((VirtualDevice)virtualDisk);
        return virtualDeviceConfigSpec;
    }

    void createVirtualMachine() throws RemoteException, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg, OutOfBoundsFaultMsg, DuplicateNameFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, AlreadyExistsFaultMsg, InvalidDatastoreFaultMsg, FileFaultFaultMsg, InvalidStateFaultMsg, InvalidNameFaultMsg, TaskInProgressFaultMsg, InvalidArgumentFaultMsg, com.vmware.pbm.RuntimeFaultFaultMsg {
        ManagedObjectReference managedObjectReference = this.getMOREFsInContainerByType(this.connection.getVimServiceContent().getRootFolder(), "Datacenter").get(this.dataCenterName);
        if (managedObjectReference == null) {
            System.out.println("Datacenter " + this.dataCenterName + " not found.");
            return;
        }
        ManagedObjectReference managedObjectReference2 = this.getMOREFsInContainerByType(managedObjectReference, "HostSystem").get(this.hostname);
        if (managedObjectReference2 == null) {
            System.out.println("Host " + this.hostname + " not found");
            return;
        }
        ManagedObjectReference managedObjectReference3 = (ManagedObjectReference)VCUtil.getEntityProps(this.connection, managedObjectReference2, new String[]{"parent"}).get("parent");
        if (managedObjectReference3 == null) {
            System.out.println("No Compute Resource Found On Specified Host");
            return;
        }
        ManagedObjectReference managedObjectReference4 = (ManagedObjectReference)VCUtil.getEntityProps(this.connection, managedObjectReference3, new String[]{"resourcePool"}).get("resourcePool");
        ManagedObjectReference managedObjectReference5 = (ManagedObjectReference)VCUtil.getEntityProps(this.connection, managedObjectReference, new String[]{"vmFolder"}).get("vmFolder");
        VirtualMachineConfigSpec virtualMachineConfigSpec = this.createVmConfigSpec(this.virtualMachineName, this.dataStore, this.diskSize, managedObjectReference3, managedObjectReference2, this.getPbmProfileSpec(this.profileName));
        virtualMachineConfigSpec.setName(this.virtualMachineName);
        virtualMachineConfigSpec.setAnnotation("VirtualMachine Annotation");
        virtualMachineConfigSpec.setMemoryMB(new Long(this.vmMemory));
        virtualMachineConfigSpec.setNumCPUs(Integer.valueOf(this.numCpus));
        virtualMachineConfigSpec.setGuestId(this.guestOsId);
        ManagedObjectReference managedObjectReference6 = this.connection.getVimPort().createVMTask(managedObjectReference5, virtualMachineConfigSpec, managedObjectReference4, managedObjectReference2);
        if (!this.getTaskResultAfterDone(managedObjectReference6)) {
            String string = "Failure: Creating [ " + this.virtualMachineName + "] VM";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Creating VM  - [ %s ] %n", this.virtualMachineName);
        ManagedObjectReference managedObjectReference7 = (ManagedObjectReference)VCUtil.getEntityProps(this.connection, managedObjectReference6, new String[]{"info.result"}).get("info.result");
        System.out.println("Powering on the newly created VM " + this.virtualMachineName);
        this.powerOnVM(managedObjectReference7);
    }

    VirtualMachineConfigSpec createVmConfigSpec(String string, String string2, int n, ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference2, VirtualMachineDefinedProfileSpec virtualMachineDefinedProfileSpec) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        Object object;
        VirtualCdromIsoBackingInfo virtualCdromIsoBackingInfo;
        VirtualDeviceConfigSpec virtualDeviceConfigSpec;
        DatastoreSummary datastoreSummary;
        VirtualMachineDatastoreInfo virtualMachineDatastoreInfo;
        int n2;
        boolean bl;
        ConfigTarget configTarget = this.getConfigTargetForHost(managedObjectReference, managedObjectReference2);
        List<VirtualDevice> list = this.getDefaultDevices(managedObjectReference, managedObjectReference2);
        VirtualMachineConfigSpec virtualMachineConfigSpec = new VirtualMachineConfigSpec();
        virtualMachineConfigSpec.getVmProfile().add(virtualMachineDefinedProfileSpec);
        String string3 = null;
        if (configTarget.getNetwork() != null) {
            for (int i = 0; i < configTarget.getNetwork().size(); ++i) {
                VirtualMachineNetworkInfo virtualMachineNetworkInfo = (VirtualMachineNetworkInfo)configTarget.getNetwork().get(i);
                NetworkSummary networkSummary = virtualMachineNetworkInfo.getNetwork();
                if (!networkSummary.isAccessible()) continue;
                string3 = networkSummary.getName();
                break;
            }
        }
        ManagedObjectReference managedObjectReference3 = null;
        if (string2 != null) {
            bl = false;
            for (n2 = 0; n2 < configTarget.getDatastore().size(); ++n2) {
                virtualMachineDatastoreInfo = (VirtualMachineDatastoreInfo)configTarget.getDatastore().get(n2);
                datastoreSummary = virtualMachineDatastoreInfo.getDatastore();
                if (!datastoreSummary.getName().equals(string2)) continue;
                bl = true;
                if (datastoreSummary.isAccessible()) {
                    managedObjectReference3 = datastoreSummary.getDatastore();
                    break;
                }
                throw new RuntimeException("Specified Datastore is not accessible");
            }
            if (!bl) {
                throw new RuntimeException("Specified Datastore is not Found");
            }
        } else {
            bl = false;
            for (n2 = 0; n2 < configTarget.getDatastore().size(); ++n2) {
                virtualMachineDatastoreInfo = (VirtualMachineDatastoreInfo)configTarget.getDatastore().get(n2);
                datastoreSummary = virtualMachineDatastoreInfo.getDatastore();
                if (!datastoreSummary.isAccessible()) continue;
                string2 = datastoreSummary.getName();
                managedObjectReference3 = datastoreSummary.getDatastore();
                bl = true;
                break;
            }
            if (!bl) {
                throw new RuntimeException("No Datastore found on host");
            }
        }
        String string4 = this.getVolumeName(string2);
        VirtualMachineFileInfo virtualMachineFileInfo = new VirtualMachineFileInfo();
        virtualMachineFileInfo.setVmPathName(string4);
        virtualMachineConfigSpec.setFiles(virtualMachineFileInfo);
        int n3 = 1;
        datastoreSummary = new VirtualDeviceConfigSpec();
        datastoreSummary.setOperation(VirtualDeviceConfigSpecOperation.ADD);
        VirtualLsiLogicController virtualLsiLogicController = new VirtualLsiLogicController();
        virtualLsiLogicController.setBusNumber(0);
        datastoreSummary.setDevice((VirtualDevice)virtualLsiLogicController);
        virtualLsiLogicController.setKey(n3);
        virtualLsiLogicController.setSharedBus(VirtualSCSISharing.NO_SHARING);
        String string5 = virtualLsiLogicController.getClass().getName();
        string5 = string5.substring(string5.lastIndexOf(".") + 1);
        VirtualDevice virtualDevice = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof VirtualIDEController)) continue;
            virtualDevice = list.get(i);
            break;
        }
        VirtualDeviceConfigSpec virtualDeviceConfigSpec2 = new VirtualDeviceConfigSpec();
        virtualDeviceConfigSpec2.setOperation(VirtualDeviceConfigSpecOperation.ADD);
        VirtualFloppy virtualFloppy = new VirtualFloppy();
        VirtualFloppyDeviceBackingInfo virtualFloppyDeviceBackingInfo = new VirtualFloppyDeviceBackingInfo();
        virtualFloppyDeviceBackingInfo.setDeviceName("/dev/fd0");
        virtualFloppy.setBacking((VirtualDeviceBackingInfo)virtualFloppyDeviceBackingInfo);
        virtualFloppy.setKey(3);
        virtualDeviceConfigSpec2.setDevice((VirtualDevice)virtualFloppy);
        VirtualDeviceConfigSpec virtualDeviceConfigSpec3 = null;
        if (virtualDevice != null) {
            virtualDeviceConfigSpec3 = new VirtualDeviceConfigSpec();
            virtualDeviceConfigSpec3.setOperation(VirtualDeviceConfigSpecOperation.ADD);
            virtualDeviceConfigSpec = new VirtualCdrom();
            virtualCdromIsoBackingInfo = new VirtualCdromIsoBackingInfo();
            virtualCdromIsoBackingInfo.setDatastore(managedObjectReference3);
            virtualCdromIsoBackingInfo.setFileName(string4 + "testcd.iso");
            virtualDeviceConfigSpec.setBacking((VirtualDeviceBackingInfo)virtualCdromIsoBackingInfo);
            virtualDeviceConfigSpec.setKey(20);
            virtualDeviceConfigSpec.setControllerKey(new Integer(virtualDevice.getKey()));
            virtualDeviceConfigSpec.setUnitNumber(new Integer(0));
            virtualDeviceConfigSpec3.setDevice((VirtualDevice)virtualDeviceConfigSpec);
        }
        virtualDeviceConfigSpec = null;
        virtualDeviceConfigSpec = this.createVirtualDisk(string2, n3, managedObjectReference3);
        virtualDeviceConfigSpec.getProfile().add(virtualMachineDefinedProfileSpec);
        virtualCdromIsoBackingInfo = new VirtualDeviceConfigSpec();
        if (string3 != null) {
            virtualCdromIsoBackingInfo.setOperation(VirtualDeviceConfigSpecOperation.ADD);
            object = new VirtualPCNet32();
            VirtualEthernetCardNetworkBackingInfo virtualEthernetCardNetworkBackingInfo = new VirtualEthernetCardNetworkBackingInfo();
            virtualEthernetCardNetworkBackingInfo.setDeviceName(string3);
            object.setAddressType("generated");
            object.setBacking((VirtualDeviceBackingInfo)virtualEthernetCardNetworkBackingInfo);
            object.setKey(4);
            virtualCdromIsoBackingInfo.setDevice((VirtualDevice)object);
        }
        object = new ArrayList();
        object.add(datastoreSummary);
        object.add(virtualDeviceConfigSpec2);
        object.add(virtualDeviceConfigSpec);
        if (virtualDevice != null) {
            object.add(virtualDeviceConfigSpec3);
            object.add(virtualCdromIsoBackingInfo);
        } else {
            object = new ArrayList();
            object.add(virtualCdromIsoBackingInfo);
        }
        virtualMachineConfigSpec.getDeviceChange().addAll(object);
        return virtualMachineConfigSpec;
    }

    ConfigTarget getConfigTargetForHost(ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference2) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        ManagedObjectReference managedObjectReference3 = (ManagedObjectReference)VCUtil.getEntityProps(this.connection, managedObjectReference, new String[]{"environmentBrowser"}).get("environmentBrowser");
        ConfigTarget configTarget = this.connection.getVimPort().queryConfigTarget(managedObjectReference3, managedObjectReference2);
        if (configTarget == null) {
            throw new RuntimeException("No ConfigTarget found in ComputeResource");
        }
        return configTarget;
    }

    List<VirtualDevice> getDefaultDevices(ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference2) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        ManagedObjectReference managedObjectReference3 = (ManagedObjectReference)VCUtil.getEntityProps(this.connection, managedObjectReference, new String[]{"environmentBrowser"}).get("environmentBrowser");
        VirtualMachineConfigOption virtualMachineConfigOption = this.connection.getVimPort().queryConfigOption(managedObjectReference3, null, managedObjectReference2);
        List list = null;
        if (virtualMachineConfigOption == null) {
            throw new RuntimeException("No VirtualHardwareInfo found in ComputeResource");
        }
        List list2 = virtualMachineConfigOption.getDefaultDevice();
        if (list2 == null) {
            throw new RuntimeException("No Datastore found in ComputeResource");
        }
        list = list2;
        return list;
    }

    Map<String, ManagedObjectReference> getMOREFsInContainerByType(ManagedObjectReference managedObjectReference, String string) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        String string2 = "name";
        ManagedObjectReference managedObjectReference2 = this.connection.getVimServiceContent().getViewManager();
        ManagedObjectReference managedObjectReference3 = this.connection.getVimPort().createContainerView(managedObjectReference2, managedObjectReference, Arrays.asList(string), true);
        HashMap<String, ManagedObjectReference> hashMap = new HashMap<String, ManagedObjectReference>();
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.FALSE);
        propertySpec.setType(string);
        propertySpec.getPathSet().add(string2);
        TraversalSpec traversalSpec = new TraversalSpec();
        traversalSpec.setName("view");
        traversalSpec.setPath("view");
        traversalSpec.setSkip(Boolean.valueOf(false));
        traversalSpec.setType("ContainerView");
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(managedObjectReference3);
        objectSpec.setSkip(Boolean.TRUE);
        objectSpec.getSelectSet().add(traversalSpec);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>();
        arrayList.add(propertyFilterSpec);
        RetrieveResult retrieveResult = this.connection.getVimPort().retrievePropertiesEx(this.connection.getVimServiceContent().getPropertyCollector(), arrayList, new RetrieveOptions());
        ArrayList arrayList2 = new ArrayList();
        if (retrieveResult != null && retrieveResult.getObjects() != null && !retrieveResult.getObjects().isEmpty()) {
            arrayList2.addAll(retrieveResult.getObjects());
        }
        String string3 = null;
        if (retrieveResult != null && retrieveResult.getToken() != null) {
            string3 = retrieveResult.getToken();
        }
        while (string3 != null && !string3.isEmpty()) {
            retrieveResult = this.connection.getVimPort().continueRetrievePropertiesEx(this.connection.getVimServiceContent().getPropertyCollector(), string3);
            string3 = null;
            if (retrieveResult == null) continue;
            string3 = retrieveResult.getToken();
            if (retrieveResult.getObjects() == null || retrieveResult.getObjects().isEmpty()) continue;
            arrayList2.addAll(retrieveResult.getObjects());
        }
        for (ObjectContent objectContent : arrayList2) {
            ManagedObjectReference managedObjectReference4 = objectContent.getObj();
            String string4 = null;
            List list = objectContent.getPropSet();
            if (list != null) {
                for (DynamicProperty dynamicProperty : list) {
                    string4 = (String)dynamicProperty.getVal();
                }
            }
            hashMap.put(string4, managedObjectReference4);
        }
        return hashMap;
    }

    VirtualMachineDefinedProfileSpec getPbmProfileSpec(String string) throws InvalidArgumentFaultMsg, com.vmware.pbm.RuntimeFaultFaultMsg, RuntimeFaultFaultMsg {
        PbmServiceInstanceContent pbmServiceInstanceContent = this.connection.getPbmServiceContent();
        ManagedObjectReference managedObjectReference = pbmServiceInstanceContent.getProfileManager();
        List list = this.connection.getPbmPort().pbmQueryProfile(managedObjectReference, PbmUtil.getStorageResourceType(), null);
        if (list == null || list.isEmpty()) {
            throw new RuntimeFaultFaultMsg("No storage Profiles exist.", null);
        }
        List list2 = this.connection.getPbmPort().pbmRetrieveContent(managedObjectReference, list);
        for (PbmProfile pbmProfile : list2) {
            if (!pbmProfile.getName().equals(string)) continue;
            PbmCapabilityProfile pbmCapabilityProfile = (PbmCapabilityProfile)pbmProfile;
            VirtualMachineDefinedProfileSpec virtualMachineDefinedProfileSpec = new VirtualMachineDefinedProfileSpec();
            virtualMachineDefinedProfileSpec.setProfileId(pbmCapabilityProfile.getProfileId().getUniqueId());
            return virtualMachineDefinedProfileSpec;
        }
        throw new InvalidArgumentFaultMsg("Specified storage profile name does not exist.", null);
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = VCUtil.waitForTask(this.connection, managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    String getVolumeName(String string) {
        String string2 = null;
        string2 = string != null && string.length() > 0 ? "[" + string + "]" : "[Local]";
        return string2;
    }

    void powerOnVM(ManagedObjectReference managedObjectReference) throws RemoteException, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg, TaskInProgressFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, FileFaultFaultMsg, InvalidStateFaultMsg {
        ManagedObjectReference managedObjectReference2 = this.connection.getVimPort().powerOnVMTask(managedObjectReference, null);
        if (!this.getTaskResultAfterDone(managedObjectReference2)) {
            String string = "Failure: starting [ " + managedObjectReference.getValue() + "] VM";
            throw new RuntimeException(string);
        }
        System.out.println("Success: VM started Successfully");
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, VmConfigFaultFaultMsg, AlreadyExistsFaultMsg, InvalidDatastoreFaultMsg, FileFaultFaultMsg, InvalidStateFaultMsg, InvalidCollectorVersionFaultMsg, InvalidNameFaultMsg, OutOfBoundsFaultMsg, DuplicateNameFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidPropertyFaultMsg, RemoteException, TaskInProgressFaultMsg, InvalidArgumentFaultMsg, com.vmware.pbm.RuntimeFaultFaultMsg {
        this.createVirtualMachine();
    }

    @Option(name="cpucount", required=false, description="Total cpu count")
    public void setCpuCount(String string) {
        this.numCpus = Integer.parseInt(string);
    }

    @Option(name="datacentername", description="Name of the datacenter")
    public void setDataCenterName(String string) {
        this.dataCenterName = string;
    }

    @Option(name="datastorename", required=false, description="Name of dataStore")
    public void setDataStore(String string) {
        this.dataStore = string;
    }

    @Option(name="disksize", required=false, description="Size of the Disk")
    public void setDiskSize(String string) {
        this.diskSize = Integer.parseInt(string);
    }

    @Option(name="guestosid", required=false, description="Type of Guest OS [Windows|Posix]")
    public void setGuestOsId(String string) {
        this.guestOsId = string;
    }

    @Option(name="hostname", description="Name of the host")
    public void setHostname(String string) {
        this.hostname = string;
    }

    @Option(name="memorysize", required=false, description="Size of Memory in 1024MB blocks. eg. 2048")
    public void setMemorySize(String string) {
        this.vmMemory = Long.parseLong(string);
    }

    @Option(name="profilename", description="Name of the storage profile", required=true)
    public void setProfileName(String string) {
        this.profileName = string;
    }

    @Option(name="vmname", description="Name of the virtual machine")
    public void setVirtualMachineName(String string) {
        this.virtualMachineName = string;
    }
}

