/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.spbm.samples;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.pbm.InvalidArgumentFaultMsg;
import com.vmware.pbm.PbmCapabilityProfile;
import com.vmware.pbm.PbmFaultFaultMsg;
import com.vmware.pbm.PbmPlacementHub;
import com.vmware.pbm.PbmServiceInstanceContent;
import com.vmware.spbm.connection.ConnectedServiceBase;
import com.vmware.spbm.connection.helpers.PbmUtil;
import com.vmware.spbm.connection.helpers.VCUtil;
import com.vmware.vim25.ArrayOfManagedObjectReference;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.InsufficientResourcesFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.MigrationFaultFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.TimedoutFaultMsg;
import com.vmware.vim25.VirtualMachineDefinedProfileSpec;
import com.vmware.vim25.VirtualMachineRelocateSpec;
import com.vmware.vim25.VmConfigFaultFaultMsg;
import java.util.ArrayList;
import java.util.Map;

@Sample(name="vm-relocate", description="Used to relocate a virtual machine's virtual disks to a datastore compliant with the given storage profile. If multiple datastores are compliant, this sample picks one of them.")
public class VMRelocate
extends ConnectedServiceBase {
    private PbmServiceInstanceContent spbmsc;
    private String vmPathName;
    private String profileName;

    private String getDSName(PbmPlacementHub pbmPlacementHub) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        ManagedObjectReference managedObjectReference = new ManagedObjectReference();
        managedObjectReference.setType(pbmPlacementHub.getHubType());
        managedObjectReference.setValue(pbmPlacementHub.getHubId());
        Map<String, Object> map = VCUtil.getEntityProps(this.connection, managedObjectReference, new String[]{"name"});
        return (String)map.get("name");
    }

    private boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = VCUtil.waitForTask(this.connection, managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    private VirtualMachineDefinedProfileSpec getVMDefinedProfileSpec(String string) throws InvalidArgumentFaultMsg, com.vmware.pbm.RuntimeFaultFaultMsg, RuntimeFaultFaultMsg {
        PbmCapabilityProfile pbmCapabilityProfile = PbmUtil.getPbmProfile(this.connection, string);
        VirtualMachineDefinedProfileSpec virtualMachineDefinedProfileSpec = new VirtualMachineDefinedProfileSpec();
        virtualMachineDefinedProfileSpec.setProfileId(pbmCapabilityProfile.getProfileId().getUniqueId());
        return virtualMachineDefinedProfileSpec;
    }

    void relocate() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidDatastoreFaultMsg, FileFaultFaultMsg, MigrationFaultFaultMsg, InvalidStateFaultMsg, TimedoutFaultMsg, InvalidCollectorVersionFaultMsg, InvalidArgumentFaultMsg, com.vmware.pbm.RuntimeFaultFaultMsg, PbmFaultFaultMsg {
        PbmPlacementHub pbmPlacementHub;
        Object object2;
        this.spbmsc = this.connection.getPbmServiceContent();
        ManagedObjectReference managedObjectReference = this.connection.getVimPort().findByInventoryPath(this.connection.getVimServiceContent().getSearchIndex(), this.vmPathName);
        if (managedObjectReference == null) {
            System.out.printf("The VMPath specified [ %s ] is not found %n", this.vmPathName);
            return;
        }
        Map<String, Object> map = VCUtil.getEntityProps(this.connection, managedObjectReference, new String[]{"runtime.host"});
        ManagedObjectReference managedObjectReference2 = (ManagedObjectReference)map.get("runtime.host");
        map = VCUtil.getEntityProps(this.connection, managedObjectReference2, new String[]{"datastore"});
        ArrayOfManagedObjectReference arrayOfManagedObjectReference = (ArrayOfManagedObjectReference)map.get("datastore");
        ArrayList<PbmPlacementHub> arrayList = new ArrayList<PbmPlacementHub>();
        for (Object object2 : arrayOfManagedObjectReference.getManagedObjectReference()) {
            pbmPlacementHub = new PbmPlacementHub();
            pbmPlacementHub.setHubId(object2.getValue());
            pbmPlacementHub.setHubType(object2.getType());
            arrayList.add(pbmPlacementHub);
        }
        if (arrayList.size() == 0) {
            System.out.println("Error: There should be at least one datastore available on the current host to relocate.");
            return;
        }
        PbmCapabilityProfile pbmCapabilityProfile = PbmUtil.getPbmProfile(this.connection, this.profileName);
        object2 = this.connection.getPbmPort().pbmQueryMatchingHub(this.spbmsc.getPlacementSolver(), arrayList, pbmCapabilityProfile.getProfileId());
        if (object2.size() == 0) {
            System.out.println("Error: No compliant datastores matching the storage profile found on the host");
            return;
        }
        pbmPlacementHub = new ManagedObjectReference();
        PbmPlacementHub pbmPlacementHub2 = (PbmPlacementHub)object2.get(0);
        pbmPlacementHub.setType(pbmPlacementHub2.getHubType());
        pbmPlacementHub.setValue(pbmPlacementHub2.getHubId());
        VirtualMachineRelocateSpec virtualMachineRelocateSpec = new VirtualMachineRelocateSpec();
        virtualMachineRelocateSpec.setDatastore((ManagedObjectReference)pbmPlacementHub);
        virtualMachineRelocateSpec.getProfile().add(this.getVMDefinedProfileSpec(this.profileName));
        ManagedObjectReference managedObjectReference3 = this.connection.getVimPort().relocateVMTask(managedObjectReference, virtualMachineRelocateSpec, null);
        if (this.getTaskResultAfterDone(managedObjectReference3)) {
            System.out.println("VM's storage relocated successfully to datastore " + this.getDSName(pbmPlacementHub2));
        } else {
            System.out.println("Failure -: VM's storage cannot be relocated");
        }
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, InsufficientResourcesFaultFaultMsg, VmConfigFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidPropertyFaultMsg, FileFaultFaultMsg, InvalidStateFaultMsg, MigrationFaultFaultMsg, InvalidCollectorVersionFaultMsg, TimedoutFaultMsg, InvalidArgumentFaultMsg, com.vmware.pbm.RuntimeFaultFaultMsg, PbmFaultFaultMsg {
        this.relocate();
    }

    @Option(name="profilename", description="Name of the storage profile", required=true)
    public void setProfileName(String string) {
        this.profileName = string;
    }

    @Option(name="vmpath", description="inventory path of the VM", required=true)
    public void setVmPathName(String string) {
        this.vmPathName = string;
    }
}

