/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.spbm.samples;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.pbm.InvalidArgumentFaultMsg;
import com.vmware.pbm.PbmCapabilityDiscreteSet;
import com.vmware.pbm.PbmCapabilityInstance;
import com.vmware.pbm.PbmCapabilityProfile;
import com.vmware.pbm.PbmCapabilityPropertyInstance;
import com.vmware.pbm.PbmCapabilityRange;
import com.vmware.pbm.PbmCapabilitySubProfile;
import com.vmware.pbm.PbmCapabilitySubProfileConstraints;
import com.vmware.pbm.PbmDuplicateNameFaultMsg;
import com.vmware.pbm.PbmFaultFaultMsg;
import com.vmware.pbm.PbmFaultProfileStorageFaultFaultMsg;
import com.vmware.pbm.PbmPlacementHub;
import com.vmware.pbm.PbmServerObjectRef;
import com.vmware.pbm.PbmServiceInstanceContent;
import com.vmware.spbm.connection.ConnectedServiceBase;
import com.vmware.spbm.connection.helpers.PbmUtil;
import com.vmware.spbm.connection.helpers.VCUtil;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.util.List;
import java.util.Map;

@Sample(name="viewprofile", description="Display the contents of a storage profile.")
public class ViewProfile
extends ConnectedServiceBase {
    private PbmServiceInstanceContent spbmsc;
    private String profileName;
    private PbmCapabilityProfile profile;

    @Option(name="profilename", description="Name of the storage profile", required=true)
    public void setProfileName(String string) {
        this.profileName = string;
    }

    @Action
    public void viewProfile() throws RuntimeFaultFaultMsg, com.vmware.pbm.RuntimeFaultFaultMsg, InvalidArgumentFaultMsg, PbmDuplicateNameFaultMsg, PbmFaultProfileStorageFaultFaultMsg, PbmFaultFaultMsg, InvalidPropertyFaultMsg {
        Object object;
        Object object2;
        PbmCapabilityInstance pbmCapabilityInstance2;
        Object object3;
        Object object42;
        this.spbmsc = this.connection.getPbmServiceContent();
        ManagedObjectReference managedObjectReference = this.spbmsc.getProfileManager();
        ManagedObjectReference managedObjectReference2 = this.spbmsc.getPlacementSolver();
        List list = this.connection.getPbmPort().pbmQueryProfile(managedObjectReference, PbmUtil.getStorageResourceType(), null);
        if (list == null || list.isEmpty()) {
            throw new RuntimeFaultFaultMsg("No storage Profiles exist.", null);
        }
        List list2 = this.connection.getPbmPort().pbmRetrieveContent(managedObjectReference, list);
        for (Object object42 : list2) {
            if (!object42.getName().equals(this.profileName)) continue;
            this.profile = (PbmCapabilityProfile)object42;
        }
        if (this.profile == null) {
            throw new InvalidArgumentFaultMsg("Specified storage profile name does not exist.", null);
        }
        System.out.println("Profile Name: " + this.profile.getName());
        System.out.println("Profile Id: " + this.profile.getProfileId().getUniqueId());
        System.out.println("Description: " + this.profile.getDescription());
        PbmCapabilitySubProfileConstraints pbmCapabilitySubProfileConstraints = (PbmCapabilitySubProfileConstraints)this.profile.getConstraints();
        object42 = pbmCapabilitySubProfileConstraints.getSubProfiles();
        System.out.println("\nNo. of Rule-Sets: " + object42.size());
        System.out.println("List of Rules");
        System.out.println("-------------");
        Object object5 = object42.iterator();
        while (object5.hasNext()) {
            object3 = (PbmCapabilitySubProfile)object5.next();
            System.out.println("RuleSet Name: '" + object3.getName() + "'");
            for (PbmCapabilityInstance pbmCapabilityInstance2 : object3.getCapability()) {
                for (String[] stringArray : pbmCapabilityInstance2.getConstraint()) {
                    for (PbmCapabilityPropertyInstance pbmCapabilityPropertyInstance : stringArray.getPropertyInstance()) {
                        PbmCapabilityDiscreteSet pbmCapabilityDiscreteSet;
                        if (pbmCapabilityInstance2.getId().getNamespace().contains("tag")) {
                            System.out.println(" Tag Category: " + pbmCapabilityInstance2.getId().getId());
                            System.out.println(" Selected Tags:");
                            pbmCapabilityDiscreteSet = (PbmCapabilityDiscreteSet)pbmCapabilityPropertyInstance.getValue();
                            for (Object e : pbmCapabilityDiscreteSet.getValues()) {
                                System.out.println(" " + e);
                            }
                        }
                        if (pbmCapabilityInstance2.getId().getNamespace().contains("vSan")) {
                            System.out.println(" Capability: " + pbmCapabilityInstance2.getId().getId());
                            if (pbmCapabilityInstance2.getId().getId().equals("proportionalCapacity")) {
                                pbmCapabilityDiscreteSet = (PbmCapabilityRange)pbmCapabilityPropertyInstance.getValue();
                                System.out.println(" Min: " + pbmCapabilityDiscreteSet.getMin() + ", Max: " + pbmCapabilityDiscreteSet.getMax());
                            } else {
                                System.out.println(" Value: " + pbmCapabilityPropertyInstance.getValue());
                            }
                        }
                        System.out.println(" ---");
                    }
                }
            }
        }
        object5 = this.connection.getPbmPort().pbmQueryAssociatedEntity(managedObjectReference, this.profile.getProfileId(), "virtualMachine");
        System.out.println("\nNo. of Associated VM's: " + object5.size());
        if (object5.size() > 0) {
            System.out.println("List of VM's");
            System.out.println("----------- ");
            object3 = object5.iterator();
            while (object3.hasNext()) {
                object2 = (PbmServerObjectRef)object3.next();
                pbmCapabilityInstance2 = new ManagedObjectReference();
                pbmCapabilityInstance2.setType("VirtualMachine");
                pbmCapabilityInstance2.setValue(object2.getKey());
                object = VCUtil.getEntityProps(this.connection, (ManagedObjectReference)pbmCapabilityInstance2, new String[]{"name"});
                System.out.println(object.get("name"));
            }
        }
        object3 = this.connection.getPbmPort().pbmQueryMatchingHub(managedObjectReference2, null, this.profile.getProfileId());
        System.out.println("\nNo. of Matching Resources: " + object3.size());
        if (object3.size() > 0) {
            System.out.println("List of Resources:");
            System.out.println("----------- ");
            object2 = object3.iterator();
            while (object2.hasNext()) {
                String[] stringArray;
                pbmCapabilityInstance2 = (PbmPlacementHub)object2.next();
                object = new ManagedObjectReference();
                object.setType(pbmCapabilityInstance2.getHubType());
                object.setValue(pbmCapabilityInstance2.getHubId());
                stringArray = new String[]{"name"};
                Map<String, Object> map = VCUtil.getEntityProps(this.connection, (ManagedObjectReference)object, stringArray);
                System.out.println(map.get("name") + " : " + pbmCapabilityInstance2.getHubType());
            }
        }
    }
}

