/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.client.samples;

import com.rsa.names._2009._12.product.riat.wsdl.STSService;
import com.rsa.names._2009._12.product.riat.wsdl.STSServicePortType;
import com.vmware.sso.client.soaphandlers.HeaderHandlerResolver;
import com.vmware.sso.client.soaphandlers.SamlTokenExtractionHandler;
import com.vmware.sso.client.soaphandlers.TimeStampHandler;
import com.vmware.sso.client.soaphandlers.UserCredentialHandler;
import com.vmware.sso.client.soaphandlers.WsSecurityUserCertificateSignatureHandler;
import com.vmware.sso.client.utils.SecurityUtil;
import com.vmware.sso.client.utils.Utils;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import org.oasis_open.docs.ws_sx.ws_trust._200512.LifetimeType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RenewingType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RequestSecurityTokenType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0.AttributedDateTime;
import org.w3c.dom.Element;

public class AcquireHoKTokenByUserCredentialSample {
    public static Element getToken(String[] stringArray, PrivateKey privateKey, X509Certificate x509Certificate) throws DatatypeConfigurationException {
        STSService sTSService = new STSService();
        HeaderHandlerResolver headerHandlerResolver = new HeaderHandlerResolver();
        headerHandlerResolver.addHandler(new TimeStampHandler());
        UserCredentialHandler userCredentialHandler = new UserCredentialHandler(stringArray[1], stringArray[2]);
        headerHandlerResolver.addHandler(userCredentialHandler);
        WsSecurityUserCertificateSignatureHandler wsSecurityUserCertificateSignatureHandler = new WsSecurityUserCertificateSignatureHandler(privateKey, x509Certificate);
        headerHandlerResolver.addHandler(wsSecurityUserCertificateSignatureHandler);
        SamlTokenExtractionHandler samlTokenExtractionHandler = new SamlTokenExtractionHandler();
        headerHandlerResolver.addHandler(samlTokenExtractionHandler);
        sTSService.setHandlerResolver((HandlerResolver)headerHandlerResolver);
        STSServicePortType sTSServicePortType = sTSService.getSTSServicePort();
        RequestSecurityTokenType requestSecurityTokenType = new RequestSecurityTokenType();
        LifetimeType lifetimeType = new LifetimeType();
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        XMLGregorianCalendar xMLGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
        AttributedDateTime attributedDateTime = new AttributedDateTime();
        attributedDateTime.setValue(xMLGregorianCalendar.toXMLFormat());
        AttributedDateTime attributedDateTime2 = new AttributedDateTime();
        xMLGregorianCalendar.add(datatypeFactory.newDuration(1800000L));
        attributedDateTime2.setValue(xMLGregorianCalendar.toXMLFormat());
        lifetimeType.setCreated(attributedDateTime);
        lifetimeType.setExpires(attributedDateTime2);
        requestSecurityTokenType.setTokenType("urn:oasis:names:tc:SAML:2.0:assertion");
        requestSecurityTokenType.setRequestType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue");
        requestSecurityTokenType.setLifetime(lifetimeType);
        requestSecurityTokenType.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey");
        requestSecurityTokenType.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        requestSecurityTokenType.setDelegatable(Boolean.valueOf(true));
        RenewingType renewingType = new RenewingType();
        renewingType.setAllow(Boolean.TRUE);
        renewingType.setOK(Boolean.FALSE);
        requestSecurityTokenType.setRenewing(renewingType);
        Map map = ((BindingProvider)sTSServicePortType).getRequestContext();
        map.put("javax.xml.ws.service.endpoint.address", stringArray[0]);
        sTSServicePortType.issue(requestSecurityTokenType);
        return samlTokenExtractionHandler.getToken();
    }

    private static void printUsage() {
        System.out.println("To use a key/certificate pair generated at the runtime use:");
        System.out.println("  run.bat com.vmware.sso.client.samples.AcquireHoKTokenByUserCredentialSample [sso url] [username] [password]");
        System.out.println("*****OR*****");
        System.out.println("To load the key/certificate pair from individual files use:");
        System.out.println("  run.bat com.vmware.sso.client.samples.AcquireHoKTokenByUserCredentialSample [sso url] [username] [password] [path to key file] [path to certificate file]");
        System.out.println("*****OR*****");
        System.out.println("To load the key/certificate pair from a keystore use:");
        System.out.println("  run.bat com.vmware.sso.client.samples.AcquireHoKTokenByUserCredentialSample [sso url] [username] [password] [path to keystore file] [keystore password] [alias used in keystore]");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 3) {
            AcquireHoKTokenByUserCredentialSample.printUsage();
            return;
        }
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        Utils.trustAllHttpsCertificates();
        if (stringArray.length == 3) {
            System.out.println("Aquiring a HoK token by using user credentials, private key and certificate ");
            SecurityUtil securityUtil = SecurityUtil.generateKeyCertPair();
            Utils.printToken(AcquireHoKTokenByUserCredentialSample.getToken(stringArray, securityUtil.getPrivateKey(), securityUtil.getUserCert()));
        } else if (stringArray.length == 5) {
            System.out.println("Aquiring a HoK token by using user credentials, private key and certificate ");
            SecurityUtil securityUtil = SecurityUtil.loadFromFiles(stringArray[3], stringArray[4]);
            Utils.printToken(AcquireHoKTokenByUserCredentialSample.getToken(stringArray, securityUtil.getPrivateKey(), securityUtil.getUserCert()));
        } else if (stringArray.length == 6) {
            System.out.println("Aquiring a HoK token by using user credentials, private key and certificate ");
            SecurityUtil securityUtil = SecurityUtil.loadFromKeystore(stringArray[3], stringArray[4], stringArray[5]);
            Utils.printToken(AcquireHoKTokenByUserCredentialSample.getToken(stringArray, securityUtil.getPrivateKey(), securityUtil.getUserCert()));
        } else {
            AcquireHoKTokenByUserCredentialSample.printUsage();
            return;
        }
    }
}

