/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.common.samples.parameters;

import com.vmware.common.samples.SampleRegistry;
import com.vmware.common.samples.SystemParameters;
import com.vmware.common.samples.parameters.ComplexOptionReference;
import com.vmware.common.samples.parameters.ComplexSystemPropertyReference;
import com.vmware.common.samples.parameters.MissingSystemPropertyException;
import com.vmware.common.samples.parameters.OptionReference;
import com.vmware.common.samples.parameters.Options;
import com.vmware.common.samples.parameters.ParameterException;
import com.vmware.common.samples.parameters.ParameterInjectionException;
import com.vmware.common.samples.parameters.SampleParameters;
import com.vmware.common.samples.parameters.SystemPropertyReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class Parameters
implements SampleParameters {
    private final Class<?> sampleClass;
    private final Options options;
    private final Map<String, Object> parameters = new LinkedHashMap<String, Object>();

    @Override
    public Class<?> getSampleClass() {
        return this.sampleClass;
    }

    public Parameters(Class<?> sampleClass, Options options) {
        this.sampleClass = sampleClass;
        this.options = options;
    }

    public Options getOptions() {
        return this.options;
    }

    @Override
    public String get(String param) {
        return this.parameters.get(param.toLowerCase()).toString();
    }

    @Override
    public SampleParameters parse(String[] args, SystemParameters systemParameters) throws IllegalArgumentException {
        this.parameters.putAll(Parameters.systemArgs(this.options.list, systemParameters));
        this.parameters.putAll(Parameters.parseArgs(this.options.list, args));
        this.validate();
        return this;
    }

    public void validate() {
        for (OptionReference option : this.options.list) {
            if (option.required && !this.parameters.containsKey(option.name)) {
                throw new ParameterException("option " + option.toString() + " is required");
            }
            if (!option.required || !option.parameter || Parameters.validValue((String)this.parameters.get(option.name))) continue;
            throw new ParameterException("option " + option.toString() + " is required & must have a valid parameter entered after it");
        }
    }

    public static Map<String, Object> systemArgs(Collection<OptionReference> list, SystemParameters systemParameters) {
        return Parameters.systemArgs(list.toArray(new OptionReference[list.size()]), systemParameters);
    }

    public static Map<String, Object> systemArgs(OptionReference[] options, SystemParameters systemParameters) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (OptionReference option : options) {
            String val;
            if (option.systemProperty == null || (val = systemParameters.get(option.systemProperty)) == null) continue;
            params.put(option.name, val);
        }
        return params;
    }

    public static Map<String, Object> parseArgs(Collection<OptionReference> list, String[] args) {
        return Parameters.parseArgs(list.toArray(new OptionReference[list.size()]), args);
    }

    public static Map<String, Object> parseArgs(OptionReference[] options, String[] args) {
        boolean skip;
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (int index = 0; index < args.length; index += skip ? 2 : 1) {
            String param = args[index].trim();
            String key = null;
            Object value = null;
            skip = false;
            for (OptionReference option : options) {
                if (!option.match(param)) continue;
                key = option.name;
                if (option.parameter) {
                    value = index + 1 < args.length ? args[index + 1].trim() : "";
                    skip = Parameters.validValue((String)value);
                    continue;
                }
                value = Boolean.TRUE;
                skip = false;
            }
            if (key == null) continue;
            params.put(key, value);
        }
        return params;
    }

    private static boolean validValue(String val) {
        return val != null && !val.startsWith("--") && !val.isEmpty();
    }

    public static SampleParameters build(Class<?> sampleClass, Options options, String[] args, SystemParameters systemParameters) throws IllegalArgumentException {
        return new Parameters(sampleClass, options).parse(args, systemParameters);
    }

    @Override
    public Object inject(Object pojo) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Object value;
        HashMap<String, Object> objects = new HashMap<String, Object>();
        this.checkClass(pojo);
        HashMap<String, Method> setters = new HashMap<String, Method>();
        for (SystemPropertyReference ref : this.options.systemProperties) {
            if (ref instanceof ComplexSystemPropertyReference) {
                ComplexSystemPropertyReference cref = (ComplexSystemPropertyReference)ref;
                String value2 = System.getProperty(cref.property, cref.defaultValue);
                if ("".equals(value2)) continue;
                Object object = objects.get(cref.field);
                if (object == null) {
                    Class<?> concreteType = SampleRegistry.lookupType(cref.type);
                    object = concreteType.newInstance();
                    objects.put(cref.field, object);
                }
                cref.setter.invoke(object, value2);
                setters.put(cref.field, cref.method);
                continue;
            }
            value = System.getProperty(ref.property, ref.defaultValue);
            if (ref.required.booleanValue() && "".equals(value)) {
                throw new MissingSystemPropertyException(ref.property, ref.description);
            }
            ref.method.invoke(pojo, value);
        }
        for (OptionReference option : this.options.list) {
            Object valueObj;
            if (option instanceof ComplexOptionReference) {
                Object object;
                ComplexOptionReference copt = (ComplexOptionReference)option;
                if (!objects.containsKey(copt.property)) {
                    Class<?> concreteType = SampleRegistry.lookupType(copt.type);
                    objects.put(copt.property, concreteType.newInstance());
                }
                if ((object = this.parameters.get(option.name)) != null) {
                    copt.setter.invoke(objects.get(copt.property), object);
                }
                setters.put(copt.property, option.method);
                continue;
            }
            value = this.parameters.get(option.name);
            if (value == null || (valueObj = this.constructParameter(option.method, value)) == null) continue;
            option.method.invoke(pojo, valueObj);
        }
        for (String name : objects.keySet()) {
            Object object = objects.get(name);
            Method method = (Method)setters.get(name);
            method.invoke(pojo, object);
        }
        return pojo;
    }

    public Object constructParameter(Method setter, Object value) {
        Object valueObj = null;
        Class valueClass = String.class;
        try {
            Class<?>[] params = setter.getParameterTypes();
            if (params.length == 1) {
                valueClass = SampleRegistry.map(params[0]);
            }
            if (valueClass.equals(value.getClass())) {
                valueObj = value;
            } else if (valueClass.equals(Character.class)) {
                char[] chars = value.toString().toCharArray();
                if (chars.length > 0) {
                    valueObj = Character.valueOf(chars[0]);
                }
            } else if (valueClass.equals(Character[].class)) {
                valueObj = value.toString().toCharArray();
            } else {
                Constructor constructor = valueClass.getConstructor(value.getClass());
                valueObj = constructor.newInstance(value);
            }
        }
        catch (SecurityException e) {
            throw new ParametersInjectionException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new ParametersInjectionException(String.format("The class %s used by %s.%s does not have a constructor that takes %s", valueClass.getName(), setter.getDeclaringClass().getName(), setter.getName(), value.getClass().getName()), e);
        }
        catch (IllegalArgumentException e) {
            throw new ParametersInjectionException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new ParametersInjectionException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ParametersInjectionException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new ParametersInjectionException(e.getMessage(), e);
        }
        return valueObj;
    }

    private void checkClass(Object pojo) throws ParameterInjectionException {
        Class<?> sampleClass = this.getSampleClass();
        if (!pojo.getClass().equals(sampleClass)) {
            throw new ParameterInjectionException("Attempted to inject class " + pojo.getClass() + " when " + sampleClass.getCanonicalName() + " was expected.");
        }
    }

    class ParametersInjectionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParametersInjectionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

