/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.connection;

import com.vmware.connection.Connection;
import com.vmware.connection.ConnectionException;
import com.vmware.connection.ConnectionMalformedUrlException;
import com.vmware.sso.client.samples.AcquireHoKTokenByUserCredentialSample;
import com.vmware.sso.client.soaphandlers.HeaderHandlerResolver;
import com.vmware.sso.client.soaphandlers.SSOHeaderHandler;
import com.vmware.sso.client.soaphandlers.SamlTokenHandler;
import com.vmware.sso.client.soaphandlers.TimeStampHandler;
import com.vmware.sso.client.soaphandlers.WsSecuritySignatureAssertionHandler;
import com.vmware.sso.client.utils.SecurityUtil;
import com.vmware.sso.client.utils.Utils;
import com.vmware.vim25.InvalidLocaleFaultMsg;
import com.vmware.vim25.InvalidLoginFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.UserSession;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VimService;
import com.vmware.vsphere.soaphandlers.HeaderCookieExtractionHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SsoConnection
implements Connection {
    public static final String SSO_URL = "sso.url";
    private VimService vimService;
    private VimPortType vimPort;
    private ServiceContent serviceContent;
    private UserSession userSession;
    private ManagedObjectReference svcInstRef;
    URL url;
    private URL ssoUrl = null;
    private String username;
    private String password;
    private Map headers;
    private PrivateKey privateKey;
    private X509Certificate certificate;
    public final String pkeyFileName = System.getProperty("sso.pkey.file");
    public final String certFileName = System.getProperty("sso.cert.file");

    public URL getSsoUrl() throws MalformedURLException {
        if (this.ssoUrl != null) {
            return this.ssoUrl;
        }
        String string = System.getProperty(SSO_URL, this.getDefaultSsoUrl());
        this.ssoUrl = new URL(string);
        return this.ssoUrl;
    }

    public String getDefaultSsoUrl() {
        String string = System.getProperty("sso.host", this.url.getHost());
        String string2 = System.getProperty("sso.port", "");
        String string3 = System.getProperty("sso.path", "/sts/STSService");
        return String.format("https://%s:%s%s", string, string2, string3);
    }

    @Override
    public void setUrl(String string) {
        try {
            this.url = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConnectionMalformedUrlException(string, malformedURLException);
        }
    }

    @Override
    public String getUrl() {
        return this.url.toString();
    }

    @Override
    public String getHost() {
        return this.url.getHost();
    }

    @Override
    public Integer getPort() {
        return this.url.getPort();
    }

    @Override
    public void setUsername(String string) {
        this.username = string;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setPassword(String string) {
        this.password = string;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public VimService getVimService() {
        return this.vimService;
    }

    @Override
    public VimPortType getVimPort() {
        return this.vimPort;
    }

    @Override
    public ServiceContent getServiceContent() {
        return this.serviceContent;
    }

    @Override
    public UserSession getUserSession() {
        return this.userSession;
    }

    @Override
    public String getServiceInstanceName() {
        return "ServiceInstance";
    }

    @Override
    public Map getHeaders() {
        return this.headers;
    }

    @Override
    public ManagedObjectReference getServiceInstanceReference() {
        if (this.svcInstRef == null) {
            ManagedObjectReference managedObjectReference = new ManagedObjectReference();
            managedObjectReference.setType(this.getServiceInstanceName());
            managedObjectReference.setValue(this.getServiceInstanceName());
            this.svcInstRef = managedObjectReference;
        }
        return this.svcInstRef;
    }

    public Element login() {
        Element element = null;
        try {
            String[] stringArray = new String[]{this.getSsoUrl().toString(), this.username, this.password};
            element = AcquireHoKTokenByUserCredentialSample.getToken((String[])stringArray, (PrivateKey)this.privateKey, (X509Certificate)this.certificate);
        }
        catch (Exception exception) {
            throw new SSOLoginException("login fault", exception.getCause() != null ? exception.getCause() : exception);
        }
        return element;
    }

    public VimService setupVimService(Element element, SSOHeaderHandler ... sSOHeaderHandlerArray) {
        VimService vimService = new VimService();
        HeaderHandlerResolver headerHandlerResolver = new HeaderHandlerResolver();
        headerHandlerResolver.addHandler((SSOHeaderHandler)new TimeStampHandler());
        headerHandlerResolver.addHandler((SSOHeaderHandler)new SamlTokenHandler((Node)element));
        headerHandlerResolver.addHandler((SSOHeaderHandler)new WsSecuritySignatureAssertionHandler(this.privateKey, this.certificate, Utils.getNodeProperty((Node)element, (String)"ID")));
        for (SSOHeaderHandler sSOHeaderHandler : sSOHeaderHandlerArray) {
            headerHandlerResolver.addHandler(sSOHeaderHandler);
        }
        vimService.setHandlerResolver((HandlerResolver)headerHandlerResolver);
        return vimService;
    }

    @Override
    public Connection connect() {
        if (!this.isConnected()) {
            try {
                this._connection();
            }
            catch (Exception exception) {
                Throwable throwable = exception.getCause() != null ? exception.getCause() : exception;
                throw new SSOLoginException("could not connect: " + exception.getMessage() + " : " + throwable.getMessage(), throwable);
            }
        }
        return this;
    }

    private void _connection() throws RuntimeFaultFaultMsg, InvalidLocaleFaultMsg, InvalidLoginFaultMsg {
        this.loadUserCert();
        Element element = this.login();
        HeaderCookieExtractionHandler headerCookieExtractionHandler = new HeaderCookieExtractionHandler();
        this.vimService = this.setupVimService(element, new SSOHeaderHandler[]{headerCookieExtractionHandler});
        this.vimPort = this.vimService.getVimPort();
        Map map = ((BindingProvider)this.vimPort).getRequestContext();
        map.put("javax.xml.ws.service.endpoint.address", this.url.toString());
        map.put("javax.xml.ws.session.maintain", true);
        this.serviceContent = this.vimPort.retrieveServiceContent(this.getServiceInstanceReference());
        this.userSession = this.vimPort.loginByToken(this.serviceContent.getSessionManager(), null);
        this.headers = (Map)((BindingProvider)this.vimPort).getResponseContext().get("javax.xml.ws.http.response.headers");
    }

    public void loadUserCert() {
        if (this.privateKey != null && this.certificate != null) {
            return;
        }
        if (this.pkeyFileName != null && this.certFileName != null) {
            SecurityUtil securityUtil = SecurityUtil.loadFromFiles((String)this.pkeyFileName, (String)this.certFileName);
            this.privateKey = securityUtil.getPrivateKey();
            this.certificate = securityUtil.getUserCert();
        }
        if (this.privateKey == null || this.certificate == null) {
            this.generate();
        }
    }

    public void generate() {
        SecurityUtil securityUtil = SecurityUtil.generateKeyCertPair();
        this.privateKey = securityUtil.getPrivateKey();
        this.certificate = securityUtil.getUserCert();
    }

    @Override
    public boolean isConnected() {
        if (this.userSession == null) {
            return false;
        }
        long l = this.userSession.getLastActiveTime().toGregorianCalendar().getTime().getTime();
        return new Date().getTime() < l + 1800000L;
    }

    @Override
    public Connection disconnect() {
        if (this.isConnected()) {
            try {
                this.vimPort.logout(this.serviceContent.getSessionManager());
            }
            catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
                throw new SSOLogoutException("failure while logging out: " + runtimeFaultFaultMsg.getMessage(), runtimeFaultFaultMsg.getCause());
            }
            finally {
                this.userSession = null;
                this.serviceContent = null;
                this.vimPort = null;
                this.vimService = null;
            }
        }
        return this;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    public class SSOLogoutException
    extends ConnectionException {
        private static final long serialVersionUID = 1L;

        public SSOLogoutException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public class SSOLoginException
    extends ConnectionException {
        private static final long serialVersionUID = 1L;

        public SSOLoginException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

