/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.fcd.helpers.FcdHelper;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFoundFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VmConfigFaultFaultMsg;

@Sample(name="fcd-detachfromvm", description="This sample detaches a currently attached virtual storage object(FCD) from the given virtual machine.")
public class FcdDetachFromVM
extends ConnectedVimServiceBase {
    private String vStorageObjectId;
    private String vmName;

    @Option(name="vstorageobjectid", required=true, description="Uuid of the disk.")
    public void setVStorageObjectId(String string) {
        this.vStorageObjectId = string;
    }

    @Option(name="vmname", required=true, description="Name of virtual machine.")
    public void setVmName(String string) {
        this.vmName = string;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    void attachDiskToVM() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg, FileFaultFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, VmConfigFaultFaultMsg {
        ManagedObjectReference managedObjectReference = this.connection.getServiceContent().getPropertyCollector();
        ManagedObjectReference managedObjectReference2 = this.getMOREFs.vmByVMname(this.vmName, managedObjectReference);
        System.out.println("Operation:  Attaching a given vStorageObject to the given virtualMachine.");
        ManagedObjectReference managedObjectReference3 = this.vimPort.detachDiskTask(managedObjectReference2, FcdHelper.makeId(this.vStorageObjectId));
        if (!this.getTaskResultAfterDone(managedObjectReference3)) {
            String string = "Error: Detaching [ " + this.vStorageObjectId + " ] from the VM [ " + this.vmName + " ] failed.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Detached vStorageObjectId : [ Id = %s ] from VM [ Name = %s ]%n", this.vStorageObjectId, this.vmName);
    }

    @Action
    public void run() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg, FileFaultFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, VmConfigFaultFaultMsg {
        this.attachDiskToVM();
    }
}

