/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.general;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.VCenterSampleBase;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Sample(name="get-hostname", description="This sample gets the hostname and additional details of the ESX Servers in the inventory")
public class GetHostName
extends VCenterSampleBase {
    private static final List<String> hostSystemAttributesArr = new ArrayList<String>();

    public void setHostSystemAttributesList() {
        hostSystemAttributesArr.add("name");
        hostSystemAttributesArr.add("config.product.productLineId");
        hostSystemAttributesArr.add("summary.hardware.cpuMhz");
        hostSystemAttributesArr.add("summary.hardware.numCpuCores");
        hostSystemAttributesArr.add("summary.hardware.cpuModel");
        hostSystemAttributesArr.add("summary.hardware.uuid");
        hostSystemAttributesArr.add("summary.hardware.vendor");
        hostSystemAttributesArr.add("summary.hardware.model");
        hostSystemAttributesArr.add("summary.hardware.memorySize");
        hostSystemAttributesArr.add("summary.hardware.numNics");
        hostSystemAttributesArr.add("summary.config.name");
        hostSystemAttributesArr.add("summary.config.product.osType");
        hostSystemAttributesArr.add("summary.config.vmotionEnabled");
        hostSystemAttributesArr.add("summary.quickStats.overallCpuUsage");
        hostSystemAttributesArr.add("summary.quickStats.overallMemoryUsage");
    }

    @Action
    public void printHostProductDetails() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        this.setHostSystemAttributesList();
        Map<ManagedObjectReference, Map<String, Object>> map = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "HostSystem", hostSystemAttributesArr.toArray(new String[0]));
        for (ManagedObjectReference managedObjectReference : map.keySet()) {
            Map<String, Object> map2 = map.get(managedObjectReference);
            for (String string : map2.keySet()) {
                System.out.println(string + " : " + map2.get(string));
            }
            System.out.println("\n\n***************************************************************");
        }
    }
}

