/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.general;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.DuplicateNameFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidNameFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInfoState;
import java.util.Map;

@Sample(name="rename", description="This sample demonstrates renaming a manged entity")
public class Rename
extends ConnectedVimServiceBase {
    private String entityname;
    private String newentityname;

    @Option(name="entityname", description="name of the inventory object - a managed entity")
    public void setEntityname(String string) {
        this.entityname = string;
    }

    @Option(name="newname", description="new name of the inventory object - a managed entity")
    public void setNewentityname(String string) {
        this.newentityname = string;
    }

    public boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    @Action
    public void rename() throws DuplicateNameFaultMsg, RuntimeFaultFaultMsg, InvalidNameFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg {
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "ManagedEntity");
        ManagedObjectReference managedObjectReference = map.get(this.entityname);
        if (managedObjectReference == null) {
            System.out.println("Unable to find a Managed Entity '" + this.entityname + "' in the Inventory");
            return;
        }
        ManagedObjectReference managedObjectReference2 = this.vimPort.renameTask(managedObjectReference, this.newentityname);
        if (this.getTaskResultAfterDone(managedObjectReference2)) {
            System.out.println("ManagedEntity '" + this.entityname + "' renamed successfully.");
        } else {
            System.out.println("Failure -: Managed Entity Cannot Be Renamed");
        }
    }
}

