/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.general;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.TraversalSpec;
import java.util.ArrayList;
import java.util.List;

@Sample(name="task-list", description="This sample prints out a list of tasks if any are running")
public class TaskList
extends ConnectedVimServiceBase {
    private ManagedObjectReference propCollectorRef;

    List<PropertyFilterSpec> createPFSForRecentTasks(ManagedObjectReference managedObjectReference) {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.FALSE);
        propertySpec.setType("Task");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("info.entity");
        arrayList.add("info.entityName");
        arrayList.add("info.name");
        arrayList.add("info.state");
        arrayList.add("info.cancelled");
        arrayList.add("info.error");
        propertySpec.getPathSet().addAll(arrayList);
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(managedObjectReference);
        objectSpec.setSkip(Boolean.FALSE);
        TraversalSpec traversalSpec = new TraversalSpec();
        traversalSpec.setType("TaskManager");
        traversalSpec.setPath("recentTask");
        traversalSpec.setSkip(Boolean.FALSE);
        objectSpec.getSelectSet().add(traversalSpec);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        ArrayList<PropertyFilterSpec> arrayList2 = new ArrayList<PropertyFilterSpec>();
        arrayList2.add(propertyFilterSpec);
        return arrayList2;
    }

    List<ObjectContent> retrievePropertiesAllObjects(List<PropertyFilterSpec> list) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        ArrayList<ObjectContent> arrayList = new ArrayList<ObjectContent>();
        RetrieveResult retrieveResult = this.vimPort.retrievePropertiesEx(this.propCollectorRef, list, retrieveOptions);
        if (retrieveResult != null && retrieveResult.getObjects() != null && !retrieveResult.getObjects().isEmpty()) {
            arrayList.addAll(retrieveResult.getObjects());
        }
        String string = null;
        if (retrieveResult != null && retrieveResult.getToken() != null) {
            string = retrieveResult.getToken();
        }
        while (string != null && !string.isEmpty()) {
            retrieveResult = this.vimPort.continueRetrievePropertiesEx(this.propCollectorRef, string);
            string = null;
            if (retrieveResult == null) continue;
            string = retrieveResult.getToken();
            if (retrieveResult.getObjects() == null || retrieveResult.getObjects().isEmpty()) continue;
            arrayList.addAll(retrieveResult.getObjects());
        }
        return arrayList;
    }

    void displayTasks(List<ObjectContent> list) {
        for (int i = 0; i < list.size(); ++i) {
            System.out.println("Task");
            List list2 = list.get(i).getPropSet();
            if (list2 == null) continue;
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            for (int j = 0; j < list2.size(); ++j) {
                Object object;
                DynamicProperty dynamicProperty = (DynamicProperty)list2.get(j);
                if ("info.entity".equals(dynamicProperty.getName())) {
                    string3 = ((ManagedObjectReference)dynamicProperty.getVal()).getType();
                    continue;
                }
                if ("info.entityName".equals(dynamicProperty.getName())) {
                    string2 = (String)dynamicProperty.getVal();
                    continue;
                }
                if ("info.name".equals(dynamicProperty.getName())) {
                    string = (String)dynamicProperty.getVal();
                    continue;
                }
                if ("info.state".equals(dynamicProperty.getName())) {
                    object = (TaskInfoState)dynamicProperty.getVal();
                    if (TaskInfoState.ERROR.equals(object)) {
                        string4 = "-Error";
                        continue;
                    }
                    if (TaskInfoState.QUEUED.equals(object)) {
                        string4 = "-Queued";
                        continue;
                    }
                    if (TaskInfoState.RUNNING.equals(object)) {
                        string4 = "-Running";
                        continue;
                    }
                    if (!TaskInfoState.SUCCESS.equals(object)) continue;
                    string4 = "-Success";
                    continue;
                }
                if ("info.cancelled".equals(dynamicProperty.getName())) {
                    object = (Boolean)dynamicProperty.getVal();
                    if (object == null || !((Boolean)object).booleanValue()) continue;
                    string4 = string4 + "-Cancelled";
                    continue;
                }
                if ("info.error".equals(dynamicProperty.getName())) {
                    object = (LocalizedMethodFault)dynamicProperty.getVal();
                    if (object == null) continue;
                    string5 = object.getLocalizedMessage();
                    continue;
                }
                string = "Got unexpected property: " + dynamicProperty.getName() + " Value: " + dynamicProperty.getVal().toString();
            }
            System.out.println("Operation " + string);
            System.out.println("Name " + string2);
            System.out.println("Type " + string3);
            System.out.println("State " + string4);
            System.out.println("Error " + string5);
            System.out.println("======================");
        }
        if (list.size() == 0) {
            System.out.println("Currently no task running");
        }
    }

    @Action
    public List<ObjectContent> list() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        ManagedObjectReference managedObjectReference = this.serviceContent.getTaskManager();
        List<PropertyFilterSpec> list = this.createPFSForRecentTasks(managedObjectReference);
        List<ObjectContent> list2 = this.retrievePropertiesAllObjects(list);
        if (list2 != null) {
            this.displayTasks(list2);
        } else {
            System.out.println("Currently no task running");
        }
        return list2;
    }
}

