/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.host;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.AlreadyExistsFaultMsg;
import com.vmware.vim25.HostConfigFaultFaultMsg;
import com.vmware.vim25.HostConfigManager;
import com.vmware.vim25.HostVirtualSwitchSpec;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ResourceInUseFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.util.Map;

@Sample(name="add-virtual-switch", description="This sample is used to add a virtual switch")
public class AddVirtualSwitch
extends ConnectedVimServiceBase {
    private String host;
    private String virtualswitchid;

    @Option(name="hostname", description="Name of the host")
    public void setHost(String string) {
        this.host = string;
    }

    @Option(name="vswitchid", description="Name of the switch to be added")
    public void setVirtualswitchid(String string) {
        this.virtualswitchid = string;
    }

    void addVirtualSwitch() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "HostSystem");
        ManagedObjectReference managedObjectReference = map.get(this.host);
        if (managedObjectReference != null) {
            try {
                HostConfigManager hostConfigManager = (HostConfigManager)this.getMOREFs.entityProps(managedObjectReference, new String[]{"configManager"}).get("configManager");
                ManagedObjectReference managedObjectReference2 = hostConfigManager.getNetworkSystem();
                HostVirtualSwitchSpec hostVirtualSwitchSpec = new HostVirtualSwitchSpec();
                hostVirtualSwitchSpec.setNumPorts(8);
                this.vimPort.addVirtualSwitch(managedObjectReference2, this.virtualswitchid, hostVirtualSwitchSpec);
                System.out.println("Successfully created vswitch : " + this.virtualswitchid);
            }
            catch (AlreadyExistsFaultMsg alreadyExistsFaultMsg) {
                System.out.println("Failed : Switch already exists  Reason : " + alreadyExistsFaultMsg.getMessage());
            }
            catch (HostConfigFaultFaultMsg hostConfigFaultFaultMsg) {
                System.out.println("Failed : Configuration failures.  Reason : " + hostConfigFaultFaultMsg.getMessage());
            }
            catch (ResourceInUseFaultMsg resourceInUseFaultMsg) {
                System.out.println("Failed adding switch: " + this.virtualswitchid + " Reason : " + resourceInUseFaultMsg.getMessage());
            }
            catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
                System.out.println("Failed adding switch: " + this.virtualswitchid + " Reason : " + runtimeFaultFaultMsg.getMessage());
            }
            catch (Exception exception) {
                System.out.println("Failed adding switch: " + this.virtualswitchid + " Reason : " + exception.getMessage());
            }
        } else {
            System.out.println("Host not found");
        }
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        this.addVirtualSwitch();
    }
}

