/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.host;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.AlreadyExistsFaultMsg;
import com.vmware.vim25.HostConfigFaultFaultMsg;
import com.vmware.vim25.HostConfigManager;
import com.vmware.vim25.HostNetworkPolicy;
import com.vmware.vim25.HostPortGroupSpec;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.util.Map;

@Sample(name="add-virtual-switch-port-group", description="add a Virtual Machine Port Group to a vSwitch")
public class AddVirtualSwitchPortGroup
extends ConnectedVimServiceBase {
    private String host;
    private String portgroupname;
    private String virtualswitchid;

    @Option(name="hostname", required=false, description="Name of the host")
    public void setHost(String string) {
        this.host = string;
    }

    @Option(name="portgroupname", description="Name of the port group")
    public void setPortgroupname(String string) {
        this.portgroupname = string;
    }

    @Option(name="vswitchid", description="Name of the vSwitch to add portgroup to")
    public void setVirtualswitchid(String string) {
        this.virtualswitchid = string;
    }

    void addVirtualSwitchPortGroup() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "HostSystem");
        ManagedObjectReference managedObjectReference = map.get(this.host);
        try {
            if (managedObjectReference != null) {
                HostConfigManager hostConfigManager = (HostConfigManager)this.getMOREFs.entityProps(managedObjectReference, new String[]{"configManager"}).get("configManager");
                ManagedObjectReference managedObjectReference2 = hostConfigManager.getNetworkSystem();
                HostPortGroupSpec hostPortGroupSpec = new HostPortGroupSpec();
                hostPortGroupSpec.setName(this.portgroupname);
                hostPortGroupSpec.setVswitchName(this.virtualswitchid);
                hostPortGroupSpec.setPolicy(new HostNetworkPolicy());
                this.vimPort.addPortGroup(managedObjectReference2, hostPortGroupSpec);
                System.out.println("Successfully created : " + this.virtualswitchid + "/" + this.portgroupname);
            } else {
                System.out.println("Host not found");
            }
        }
        catch (AlreadyExistsFaultMsg alreadyExistsFaultMsg) {
            System.out.println("Failed creating : " + this.virtualswitchid + "/" + this.portgroupname);
            System.out.println("Portgroup name already exists");
        }
        catch (HostConfigFaultFaultMsg hostConfigFaultFaultMsg) {
            System.out.println("Failed : Configuration failures.  Reason : " + hostConfigFaultFaultMsg.getMessage());
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            System.out.println("Failed creating : " + this.virtualswitchid + "/" + this.portgroupname);
        }
        catch (Exception exception) {
            System.out.println("Failed creating : " + this.virtualswitchid + "/" + this.portgroupname);
        }
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        this.addVirtualSwitchPortGroup();
    }
}

