/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.host;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.DVPortgroupConfigSpec;
import com.vmware.vim25.DVSCapability;
import com.vmware.vim25.DVSConfigSpec;
import com.vmware.vim25.DVSCreateSpec;
import com.vmware.vim25.DVSPolicy;
import com.vmware.vim25.DistributedVirtualSwitchProductSpec;
import com.vmware.vim25.DuplicateNameFaultMsg;
import com.vmware.vim25.DvsFaultFaultMsg;
import com.vmware.vim25.DvsNotAuthorizedFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidNameFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFoundFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInfoState;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

@Sample(name="dvs-create", description="This sample demonstrates how to create/update Distributed Virtual Switch")
public class DVSCreate
extends ConnectedVimServiceBase {
    private String dcName = null;
    private String dvsName = null;
    private String dvsDesc = null;
    private String dvsVersion = null;
    private String noOfPorts;
    private String portGroupName = null;
    private String option = null;

    @Option(name="option", description="\"createdvs\" for creating a new DVS | \"addportgroup\" for adding a port group to DVS")
    public void setOption(String string) {
        this.option = string;
    }

    @Option(name="dcname", required=false, description="datacenter name")
    public void setDcName(String string) {
        this.dcName = string;
    }

    @Option(name="dvsname", required=true, description="Distributed Virtual Switch name")
    public void setDvsName(String string) {
        this.dvsName = string;
    }

    @Option(name="dvsdesc", required=false, description="Description string of the switch")
    public void setDvsDesc(String string) {
        this.dvsDesc = string;
    }

    @Option(name="dvsversion", required=false, description="Distributed Virtual Switch either 4.0, 4.1.0, 5.0.0 or 5.1.0")
    public void setDvsVersion(String string) {
        this.dvsVersion = string;
    }

    @Option(name="numports", required=false, description="Number of ports in the portgroup.")
    public void setNoOfPorts(String string) {
        this.noOfPorts = string;
    }

    @Option(name="portgroupname", required=false, description="name of port group")
    public void setPortGroupName(String string) {
        this.portGroupName = string;
    }

    void validate() {
        if (this.option != null) {
            if (!this.option.equals("createdvs") && !this.option.equals("addportgroup")) {
                throw new IllegalArgumentException("Expected valid --option. createdvs or addportgroup");
            }
        } else {
            throw new IllegalArgumentException("Expected --option argument. createdvs or addportgroup");
        }
        if (this.option.equals("createdvs") && (this.dcName == null || this.dvsName == null)) {
            throw new IllegalArgumentException("Expected --dcname and --dvsname arguments");
        }
        if (this.option.equals("addportgroup") && (this.dvsName == null || this.noOfPorts == null || this.portGroupName == null)) {
            throw new IllegalArgumentException("Expected --dvsname, --numports and --portgroupname arguments");
        }
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    DVSConfigSpec getDVSConfigSpec(String string, String string2) {
        DVSConfigSpec dVSConfigSpec = new DVSConfigSpec();
        dVSConfigSpec.setName(string);
        if (string2 != null) {
            dVSConfigSpec.setDescription(string2);
        }
        DVSPolicy dVSPolicy = new DVSPolicy();
        dVSPolicy.setAutoPreInstallAllowed(new Boolean(true));
        dVSPolicy.setAutoUpgradeAllowed(new Boolean(true));
        dVSPolicy.setPartialUpgradeAllowed(new Boolean(true));
        return dVSConfigSpec;
    }

    DistributedVirtualSwitchProductSpec getDVSProductSpec(String string) throws RuntimeFaultFaultMsg {
        List list = this.vimPort.queryAvailableDvsSpec(this.serviceContent.getDvSwitchManager(), null);
        DistributedVirtualSwitchProductSpec distributedVirtualSwitchProductSpec = null;
        if (string != null) {
            for (DistributedVirtualSwitchProductSpec distributedVirtualSwitchProductSpec2 : list) {
                if (!string.equalsIgnoreCase(distributedVirtualSwitchProductSpec2.getVersion())) continue;
                distributedVirtualSwitchProductSpec = distributedVirtualSwitchProductSpec2;
            }
            if (distributedVirtualSwitchProductSpec == null) {
                throw new IllegalArgumentException("DVS Version " + string + " not supported.");
            }
        } else {
            distributedVirtualSwitchProductSpec = (DistributedVirtualSwitchProductSpec)list.get(list.size() - 1);
        }
        return distributedVirtualSwitchProductSpec;
    }

    void createDVS(String string, String string2, String string3, String string4) throws InvalidCollectorVersionFaultMsg, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, DuplicateNameFaultMsg, DvsFaultFaultMsg, DvsNotAuthorizedFaultMsg, InvalidNameFaultMsg, NotFoundFaultMsg {
        DistributedVirtualSwitchProductSpec distributedVirtualSwitchProductSpec = this.getDVSProductSpec(string4);
        ManagedObjectReference managedObjectReference = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "Datacenter").get(string);
        if (managedObjectReference == null) {
            System.out.println("Datacenter " + string + " not found.");
            return;
        }
        ManagedObjectReference managedObjectReference2 = (ManagedObjectReference)this.getMOREFs.entityProps(managedObjectReference, new String[]{"networkFolder"}).get("networkFolder");
        DVSCreateSpec dVSCreateSpec = new DVSCreateSpec();
        List list = this.vimPort.queryDvsCompatibleHostSpec(this.serviceContent.getDvSwitchManager(), distributedVirtualSwitchProductSpec);
        DVSCapability dVSCapability = new DVSCapability();
        dVSCapability.getCompatibleHostComponentProductInfo().addAll(list);
        dVSCreateSpec.setCapability(dVSCapability);
        dVSCreateSpec.setConfigSpec(this.getDVSConfigSpec(string2, string3));
        dVSCreateSpec.setProductInfo(distributedVirtualSwitchProductSpec);
        ManagedObjectReference managedObjectReference3 = this.vimPort.createDVSTask(managedObjectReference2, dVSCreateSpec);
        if (!this.getTaskResultAfterDone(managedObjectReference3)) {
            throw new RuntimeException("Failure: Creating Distributed Virtual Switch");
        }
        System.out.printf("Success: Creating Distributed Virtual Switch", new Object[0]);
    }

    void addPortGroup(String string, int n, String string2) throws RemoteException, InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, DuplicateNameFaultMsg, DvsFaultFaultMsg, InvalidNameFaultMsg, InvalidCollectorVersionFaultMsg {
        ManagedObjectReference managedObjectReference = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "VmwareDistributedVirtualSwitch").get(string);
        if (managedObjectReference != null) {
            DVPortgroupConfigSpec dVPortgroupConfigSpec = new DVPortgroupConfigSpec();
            dVPortgroupConfigSpec.setName(string2);
            dVPortgroupConfigSpec.setNumPorts(Integer.valueOf(n));
            dVPortgroupConfigSpec.setType("earlyBinding");
            ArrayList<DVPortgroupConfigSpec> arrayList = new ArrayList<DVPortgroupConfigSpec>();
            arrayList.add(dVPortgroupConfigSpec);
            ManagedObjectReference managedObjectReference2 = this.vimPort.addDVPortgroupTask(managedObjectReference, arrayList);
            if (!this.getTaskResultAfterDone(managedObjectReference2)) {
                throw new RuntimeException("Failure: Adding Port Group");
            }
        } else {
            System.out.println("DVS Switch " + string + " Not Found");
            return;
        }
        System.out.printf("Success: Adding Port Group", new Object[0]);
    }

    @Action
    public void run() throws DuplicateNameFaultMsg, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, DvsFaultFaultMsg, InvalidCollectorVersionFaultMsg, InvalidNameFaultMsg, RemoteException, NotFoundFaultMsg, DvsNotAuthorizedFaultMsg {
        this.validate();
        if (this.option.equals("createdvs")) {
            this.createDVS(this.dcName, this.dvsName, this.dvsDesc, this.dvsVersion);
        } else if (this.option.equals("addportgroup")) {
            this.addPortGroup(this.dvsName, Integer.parseInt(this.noOfPorts), this.portGroupName);
        } else {
            throw new IllegalArgumentException("unknown option: " + this.option);
        }
    }
}

