/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.host;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ArrayOfHostVirtualNic;
import com.vmware.vim25.HostConfigFaultFaultMsg;
import com.vmware.vim25.HostConfigManager;
import com.vmware.vim25.HostVirtualNic;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFoundFaultMsg;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.util.List;

@Sample(name="remove-virtual-nic", description="removes a Virtual Nic from a PortGroup on a vSwitch")
public class RemoveVirtualNic
extends ConnectedVimServiceBase {
    ManagedObjectReference propCollectorRef = null;
    ManagedObjectReference rootFolder;
    String datacenter;
    String host;
    String portgroupname;

    @Option(name="datacentername", required=false, description="Name of datacenter")
    public void setDatacenter(String string) {
        this.datacenter = string;
    }

    @Option(name="hostname", description="name of host")
    public void setHost(String string) {
        this.host = string;
    }

    @Option(name="portgroupname", description="Name of port group to remove Virtual Nic from")
    public void setPortgroupname(String string) {
        this.portgroupname = string;
    }

    void init() {
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.rootFolder = this.serviceContent.getRootFolder();
    }

    void removeVirtualNic() {
        ManagedObjectReference managedObjectReference = null;
        try {
            Object object;
            HostConfigManager hostConfigManager;
            if (this.datacenter != null && this.host != null || this.datacenter != null && this.host == null) {
                hostConfigManager = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "Datacenter", new RetrieveOptions());
                ManagedObjectReference managedObjectReference2 = hostConfigManager.get(this.datacenter);
                if (managedObjectReference2 == null) {
                    System.out.println("Datacenter not found");
                    return;
                }
                ManagedObjectReference managedObjectReference3 = (ManagedObjectReference)this.getMOREFs.entityProps(managedObjectReference2, new String[]{"hostFolder"}).get("hostFolder");
                object = this.getMOREFs.inFolderByType(managedObjectReference3, "HostSystem", new RetrieveOptions());
                managedObjectReference = (ManagedObjectReference)object.get(this.host);
            } else if (this.datacenter == null && this.host != null) {
                hostConfigManager = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "HostSystem", new RetrieveOptions());
                managedObjectReference = (ManagedObjectReference)hostConfigManager.get(this.host);
            }
            if (managedObjectReference != null) {
                hostConfigManager = (HostConfigManager)this.getMOREFs.entityProps(managedObjectReference, new String[]{"configManager"}).get("configManager");
                object = hostConfigManager.getNetworkSystem();
                ArrayOfHostVirtualNic arrayOfHostVirtualNic = (ArrayOfHostVirtualNic)this.getMOREFs.entityProps((ManagedObjectReference)object, new String[]{"networkInfo.vnic"}).get("networkInfo.vnic");
                List list = arrayOfHostVirtualNic.getHostVirtualNic();
                boolean bl = false;
                for (HostVirtualNic hostVirtualNic : list) {
                    String string = hostVirtualNic.getPortgroup();
                    if (!string.equals(this.portgroupname)) continue;
                    this.vimPort.removeVirtualNic((ManagedObjectReference)object, hostVirtualNic.getDevice());
                    bl = true;
                }
                if (bl) {
                    System.out.println("Successfully removed virtual nic from portgroup : " + this.portgroupname);
                } else {
                    System.out.println("No virtual nic found on portgroup : " + this.portgroupname);
                }
            } else {
                System.out.println("Host not found");
            }
        }
        catch (HostConfigFaultFaultMsg hostConfigFaultFaultMsg) {
            System.out.println("Failed : Configuration falilures. ");
        }
        catch (NotFoundFaultMsg notFoundFaultMsg) {
            System.out.println("Failed : " + (Object)((Object)notFoundFaultMsg));
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            System.out.println("Failed : " + (Object)((Object)runtimeFaultFaultMsg));
        }
        catch (Exception exception) {
            System.out.println("Failed : " + exception);
        }
    }

    @Action
    public void run() {
        this.init();
        this.removeVirtualNic();
    }
}

