/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.httpfileaccess;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.connection.KeepAlive;
import com.vmware.vim25.AlreadyExistsFaultMsg;
import com.vmware.vim25.ArrayOfDatastoreHostMount;
import com.vmware.vim25.DatastoreHostMount;
import com.vmware.vim25.DuplicateNameFaultMsg;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.HostMountInfo;
import com.vmware.vim25.InsufficientResourcesFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidNameFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFoundFaultMsg;
import com.vmware.vim25.OutOfBoundsFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VirtualMachineFileInfo;
import com.vmware.vim25.VmConfigFaultFaultMsg;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.ws.BindingProvider;

@Sample(name="put-vm-files", description="This sample puts VM files in specified Datacenter and Datastore and register and reconfigure the particular VM. The VM you use, should be downloaded from the vSphere you are uploading to. The name of the VM, VM folder, and VM disk files should all be the same. The name of the VM should be unique and unused on the Host. This works best if you use a VM you obtained through GetVMFiles.")
public class PutVMFiles
extends ConnectedVimServiceBase {
    private String cookieValue = "";
    private ManagedObjectReference registeredVMRef = null;
    boolean verbose = true;
    String vmName = null;
    String localPath = null;
    String datacenter = null;
    String datastore = null;

    @Option(name="vmname", description="Name of the virutal machine to upload. Should be unique and unused. Should be the same as the name of the vm folder and vm file names.")
    public void setVmName(String string) {
        this.vmName = string;
    }

    @Option(name="localpath", description="Local path from which files will be copied. This should be the path holding the virtual machine folder but not the vm folder itself.")
    public void setLocalPath(String string) {
        this.localPath = string;
    }

    @Option(name="datacentername", description="Name of the target datacenter")
    public void setDatacenter(String string) {
        this.datacenter = string;
    }

    @Option(name="datastorename", description="Name of the target datastore")
    public void setDatastore(String string) {
        this.datastore = string;
    }

    @Option(name="verbose", required=false, description="defaults to 'true' and prints more information, set to 'false' to print less.")
    public void setVerbose(Boolean bl) {
        this.verbose = bl;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new PutVMFilesException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    boolean customValidation() {
        boolean bl;
        block5: {
            bl = false;
            try {
                if (this.datacenter == null || this.datacenter.length() == 0 || this.datastore == null || this.datastore.length() == 0) break block5;
                ManagedObjectReference managedObjectReference = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "Datacenter").get(this.datacenter);
                if (managedObjectReference != null) {
                    ManagedObjectReference managedObjectReference2 = this.getMOREFs.inContainerByType(managedObjectReference, "Datastore").get(this.datastore);
                    if (managedObjectReference2 == null) {
                        System.out.println("Specified Datastore with name " + this.datastore + " was not" + " found in specified Datacenter");
                        return bl;
                    }
                    bl = true;
                    break block5;
                }
                System.out.println("Specified Datacenter with name " + this.datacenter + " not Found");
                return bl;
            }
            catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
                throw new PutVMFilesException((Throwable)runtimeFaultFaultMsg);
            }
            catch (InvalidPropertyFaultMsg invalidPropertyFaultMsg) {
                throw new PutVMFilesException((Throwable)invalidPropertyFaultMsg);
            }
        }
        return bl;
    }

    String[] getDirFiles(File file) {
        if (file.exists() && file.isDirectory()) {
            return file.list();
        }
        throw new RuntimeException("Local Path Doesn't Exist: " + file.toString());
    }

    void putVMFiles(String string, File file) {
        HttpURLConnection httpURLConnection;
        String string2 = this.connection.getUrl();
        String string3 = string2.substring(0, string2.lastIndexOf("sdk") - 1);
        String string4 = string3 + "/folder" + string + "?dcPath=" + this.datacenter + "&dsName=" + this.datastore;
        string4 = string4.replaceAll("\\ ", "%20");
        System.out.printf("%nPutting VM File %s ", string4);
        try {
            URL uRL = new URL(string4);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setAllowUserInteraction(true);
        }
        catch (MalformedURLException malformedURLException) {
            throw new PutVMFilesException((Throwable)malformedURLException);
        }
        catch (IOException iOException) {
            throw new PutVMFilesException((Throwable)iOException);
        }
        List list = (List)this.headers.get("Set-cookie");
        this.cookieValue = list != null ? (String)list.get(0) : "";
        StringTokenizer stringTokenizer = new StringTokenizer(this.cookieValue, ";");
        this.cookieValue = stringTokenizer.nextToken();
        String string5 = "$" + stringTokenizer.nextToken();
        String string6 = "$Version=\"1\"; " + this.cookieValue + "; " + string5;
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("Cookie", Collections.singletonList(string6));
        ((BindingProvider)this.vimPort).getRequestContext().put("javax.xml.ws.http.request.headers", hashMap);
        httpURLConnection.setRequestProperty("Cookie", string6);
        httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
        try {
            httpURLConnection.setRequestMethod("PUT");
        }
        catch (ProtocolException protocolException) {
            throw new PutVMFilesException((Throwable)protocolException);
        }
        httpURLConnection.setRequestProperty("Content-Length", "1024");
        long l = file.length();
        System.out.println("File size is: " + l);
        httpURLConnection.setChunkedStreamingMode(0);
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            outputStream = httpURLConnection.getOutputStream();
            inputStream = new BufferedInputStream(new FileInputStream(file));
            int n = 9216;
            byte[] byArray = new byte[n];
            byte[] byArray2 = null;
            int n2 = 0;
            Thread thread = KeepAlive.keepAlive(this.vimPort, this.getServiceInstanceReference());
            thread.start();
            String[] stringArray = new String[]{"\b/", "\b-", "\b\\", "\b|"};
            System.out.printf(".", new Object[0]);
            int n3 = 0;
            while ((n2 = inputStream.read(byArray, 0, n)) != -1) {
                byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                outputStream.write(byArray2, 0, n2);
                if (!this.verbose) continue;
                System.out.printf("%s", stringArray[n3++ % stringArray.length]);
            }
            System.out.printf("\b", new Object[0]);
            thread.interrupt();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PutVMFilesException((Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new PutVMFilesException((Throwable)iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                httpURLConnection.getResponseCode();
            }
            catch (IOException iOException) {
                throw new PutVMFilesException((Throwable)iOException);
            }
            httpURLConnection.disconnect();
        }
    }

    public void copyDir(String string) {
        System.out.print("Copying The Virtual Machine To Host...");
        File file = new File(this.localPath, string);
        String[] stringArray = this.getDirFiles(file);
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            String string2 = file2.getAbsolutePath().indexOf("vdisk") != -1 ? "/" + this.vmName + "/" + this.datastore + "/" + stringArray[i] : "/" + this.vmName + "/" + stringArray[i];
            this.putVMFiles(string2, file2);
            if (!this.verbose) continue;
            System.out.print("*");
        }
        System.out.println("...Done");
    }

    boolean registerVirtualMachine() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, OutOfBoundsFaultMsg, DuplicateNameFaultMsg, NotFoundFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, AlreadyExistsFaultMsg, InvalidDatastoreFaultMsg, FileFaultFaultMsg, InvalidStateFaultMsg, InvalidNameFaultMsg, InvalidCollectorVersionFaultMsg {
        Boolean bl;
        Object object;
        HostMountInfo hostMountInfo;
        DatastoreHostMount datastoreHostMount2;
        boolean bl2 = false;
        System.out.print("Registering The Virtual Machine ...");
        ManagedObjectReference managedObjectReference = null;
        ManagedObjectReference managedObjectReference2 = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "Datacenter").get(this.datacenter);
        ManagedObjectReference managedObjectReference3 = this.getMOREFs.inContainerByType(managedObjectReference2, "Datastore").get(this.datastore);
        List list = ((ArrayOfDatastoreHostMount)this.getMOREFs.entityProps(managedObjectReference3, new String[]{"host"}).get("host")).getDatastoreHostMount();
        for (DatastoreHostMount datastoreHostMount2 : list) {
            if (datastoreHostMount2 == null) {
                throw new PutVMFilesException("datastore " + this.datastore + " has no host mounts!");
            }
            hostMountInfo = datastoreHostMount2.getMountInfo();
            if (hostMountInfo == null) {
                throw new PutVMFilesException("datastoreHostMount on " + this.datastore + " has no info!");
            }
            object = hostMountInfo.isAccessible();
            bl = hostMountInfo.isMounted();
            if (object != null && ((Boolean)object).booleanValue() && (bl == null || bl.booleanValue())) {
                managedObjectReference = datastoreHostMount2.getKey();
                break;
            }
            if (!this.verbose) continue;
            System.out.print(".");
        }
        if (managedObjectReference == null) {
            throw new PutVMFilesException("No host connected to the datastore " + this.datastore);
        }
        ManagedObjectReference managedObjectReference4 = (ManagedObjectReference)this.getMOREFs.entityProps(managedObjectReference, new String[]{"parent"}).get("parent");
        datastoreHostMount2 = (ManagedObjectReference)this.getMOREFs.entityProps(managedObjectReference4, new String[]{"resourcePool"}).get("resourcePool");
        hostMountInfo = (ManagedObjectReference)this.getMOREFs.entityProps(managedObjectReference2, new String[]{"vmFolder"}).get("vmFolder");
        object = "[" + this.datastore + "] " + this.vmName + "/" + this.vmName + ".vmx";
        System.out.printf("...trying to register: %s ...", object);
        bl = this.vimPort.registerVMTask((ManagedObjectReference)hostMountInfo, (String)object, this.vmName, false, (ManagedObjectReference)datastoreHostMount2, managedObjectReference);
        if (this.getTaskResultAfterDone((ManagedObjectReference)bl)) {
            System.out.print("*");
            bl2 = true;
            this.registeredVMRef = (ManagedObjectReference)this.getMOREFs.entityProps((ManagedObjectReference)bl, new String[]{"info.result"}).get("info.result");
            System.out.print("VM registered with value " + this.registeredVMRef.getValue());
            System.out.println("...Done.");
        } else {
            System.out.print("Some Exception While Registering The VM");
            bl2 = false;
            System.out.println(" FAILED!");
        }
        return bl2;
    }

    void reconfigVirtualMachine() {
        try {
            System.out.println("ReConfigure The Virtual Machine ..........");
            VirtualMachineFileInfo virtualMachineFileInfo = new VirtualMachineFileInfo();
            virtualMachineFileInfo.setLogDirectory("[" + this.datastore + "] " + this.vmName);
            virtualMachineFileInfo.setSnapshotDirectory("[" + this.datastore + "] " + this.vmName);
            virtualMachineFileInfo.setSuspendDirectory("[" + this.datastore + "] " + this.vmName);
            virtualMachineFileInfo.setVmPathName("[" + this.datastore + "] " + this.vmName + "/" + this.vmName + ".vmx");
            VirtualMachineConfigSpec virtualMachineConfigSpec = new VirtualMachineConfigSpec();
            virtualMachineConfigSpec.setFiles(virtualMachineFileInfo);
            ManagedObjectReference managedObjectReference = this.vimPort.reconfigVMTask(this.registeredVMRef, virtualMachineConfigSpec);
            if (this.getTaskResultAfterDone(managedObjectReference)) {
                System.out.println("ReConfigure The Virtual Machine .......... Done");
            } else {
                System.out.println("Some Exception While Reconfiguring The VM ");
            }
        }
        catch (Exception exception) {
            throw new PutVMFilesException((Throwable)exception);
        }
    }

    void putVMFiles() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        boolean bl = this.customValidation();
        if (this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "VirtualMachine").containsKey(this.vmName)) {
            throw new PutVMFilesException(String.format("A VM with the name %s already exists!", this.vmName));
        }
        if (bl) {
            int n = 0;
            String[] stringArray = this.getDirFiles(new File(this.localPath));
            if (stringArray != null && stringArray.length != 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!this.validateDir(stringArray[i], this.localPath)) continue;
                    ++n;
                    this.copyDir(stringArray[i]);
                    boolean bl2 = false;
                    try {
                        bl2 = this.registerVirtualMachine();
                        if (!bl2) continue;
                        this.reconfigVirtualMachine();
                        continue;
                    }
                    catch (Exception exception) {
                        throw new PutVMFilesException((Throwable)exception);
                    }
                }
            }
            if (n == 0) {
                System.out.printf("There are no suitable VM Directories available at location %s did you use GetVMFiles first?", this.localPath);
                System.out.println();
            }
        }
    }

    boolean validateDir(String string, String string2) {
        if (string == null) {
            return false;
        }
        int n = 0;
        String[] stringArray = new String[]{"", String.format("The directory %s does not contain a matching %s.vmx file to register.%n", string, this.vmName), String.format("Skipping: %s is a hidden name", string), String.format("Skipping: %s is not a directory.", string), String.format("Skipping: Name %s does not contain the --vmname %s", string, this.vmName)};
        n = !new File(new File(string2, string), String.format("%s.vmx", this.vmName)).exists() ? 1 : n;
        n = string.startsWith(".") ? 2 : n;
        n = !new File(string2, string).isDirectory() ? 3 : n;
        int n2 = n = !string.contains(this.vmName) ? 4 : n;
        if (this.verbose) {
            System.out.println(stringArray[n]);
        }
        return n == 0;
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        try {
            this.putVMFiles();
        }
        catch (PutVMFilesException putVMFilesException) {
            System.out.println(putVMFilesException.getMessage());
        }
    }

    class PutVMFilesException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public PutVMFilesException(String string) {
            super(string);
        }

        public PutVMFilesException(Throwable throwable) {
            super(throwable);
        }
    }
}

