/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.performance;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ArrayOfPerfCounterInfo;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.ElementDescription;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PerfCounterInfo;
import com.vmware.vim25.PerfMetricId;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Sample(name="print-counters", description="This sample writes available VM, Hostsystem or ResourcePool perf counters into the file specified")
public class PrintCounters
extends ConnectedVimServiceBase {
    private ManagedObjectReference perfManager;
    private ManagedObjectReference propCollectorRef;
    String filename;
    String entityname;
    String entitytype;

    @Option(name="entitytype", description="Managed entity [HostSystem|VirtualMachine|ResourcePool]")
    public void setEntitytype(String string) {
        this.entitytype = string;
    }

    @Option(name="entityname", description="name of the managed entity")
    public void setEntityname(String string) {
        this.entityname = string;
    }

    @Option(name="filename", description="Full path of filename to write to")
    public void setFilename(String string) {
        this.filename = string;
    }

    List<ObjectContent> retrievePropertiesAllObjects(List<PropertyFilterSpec> list) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        ArrayList<ObjectContent> arrayList = new ArrayList<ObjectContent>();
        RetrieveResult retrieveResult = this.vimPort.retrievePropertiesEx(this.propCollectorRef, list, retrieveOptions);
        if (retrieveResult != null && retrieveResult.getObjects() != null && !retrieveResult.getObjects().isEmpty()) {
            arrayList.addAll(retrieveResult.getObjects());
        }
        String string = null;
        if (retrieveResult != null && retrieveResult.getToken() != null) {
            string = retrieveResult.getToken();
        }
        while (string != null && !string.isEmpty()) {
            retrieveResult = this.vimPort.continueRetrievePropertiesEx(this.propCollectorRef, string);
            string = null;
            if (retrieveResult == null) continue;
            string = retrieveResult.getToken();
            if (retrieveResult.getObjects() == null || retrieveResult.getObjects().isEmpty()) continue;
            arrayList.addAll(retrieveResult.getObjects());
        }
        return arrayList;
    }

    void printCounters() throws RuntimeFaultFaultMsg, IOException, InvalidPropertyFaultMsg {
        String string = this.entitytype;
        if (string.equalsIgnoreCase("HostSystem")) {
            this.printEntityCounters("HostSystem");
        } else if (string.equalsIgnoreCase("VirtualMachine")) {
            this.printEntityCounters("VirtualMachine");
        } else if (string.equals("ResourcePool")) {
            this.printEntityCounters("ResourcePool");
        } else {
            System.out.println("Entity Argument must be [HostSystem|VirtualMachine|ResourcePool]");
        }
    }

    List<PerfCounterInfo> getPerfCounters() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        List list = null;
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.FALSE);
        propertySpec.getPathSet().add("perfCounter");
        propertySpec.setType("PerformanceManager");
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>();
        arrayList.add(propertySpec);
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(this.perfManager);
        ArrayList<ObjectSpec> arrayList2 = new ArrayList<ObjectSpec>();
        arrayList2.add(objectSpec);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        ArrayList<PropertyFilterSpec> arrayList3 = new ArrayList<PropertyFilterSpec>();
        arrayList3.add(propertyFilterSpec);
        ArrayList<PropertyFilterSpec> arrayList4 = new ArrayList<PropertyFilterSpec>(1);
        arrayList4.add(propertyFilterSpec);
        List<ObjectContent> list2 = this.retrievePropertiesAllObjects(arrayList4);
        if (list2 != null) {
            for (ObjectContent objectContent : list2) {
                List list3 = objectContent.getPropSet();
                if (list3 == null) continue;
                for (DynamicProperty dynamicProperty : list3) {
                    List list4;
                    list = list4 = ((ArrayOfPerfCounterInfo)dynamicProperty.getVal()).getPerfCounterInfo();
                }
            }
        }
        return list;
    }

    void printEntityCounters(String string) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, IOException {
        ManagedObjectReference managedObjectReference = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), string).get(this.entityname);
        List<PerfCounterInfo> list = this.getPerfCounters();
        if (managedObjectReference != null) {
            Set<Integer> set = this.getPerfIdsAvailable(this.perfManager, managedObjectReference);
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.filename)));
            if (list != null) {
                printWriter.println("<perf-counters>");
                for (int i = 0; i < list.size(); ++i) {
                    int n;
                    PerfCounterInfo perfCounterInfo = list.get(i);
                    Integer n2 = new Integer(perfCounterInfo.getKey());
                    if (!set.contains(n2)) continue;
                    printWriter.print("  <perf-counter key=\"");
                    printWriter.print(n2);
                    printWriter.print("\" ");
                    printWriter.print("rollupType=\"");
                    printWriter.print(perfCounterInfo.getRollupType());
                    printWriter.print("\" ");
                    printWriter.print("statsType=\"");
                    printWriter.print(perfCounterInfo.getStatsType());
                    printWriter.println("\">");
                    this.printElementDescription(printWriter, "groupInfo", perfCounterInfo.getGroupInfo());
                    this.printElementDescription(printWriter, "nameInfo", perfCounterInfo.getNameInfo());
                    this.printElementDescription(printWriter, "unitInfo", perfCounterInfo.getUnitInfo());
                    printWriter.println("    <entity type=\"" + string + "\"/>");
                    List list2 = perfCounterInfo.getAssociatedCounterId();
                    int[] nArray = new int[list2.size()];
                    for (n = 0; n < list2.size(); ++n) {
                        nArray[n] = (Integer)list2.get(n);
                    }
                    if (nArray != null) {
                        for (n = 0; n < nArray.length; ++n) {
                            printWriter.println("    <associatedCounter>" + nArray[n] + "</associatedCounter>");
                        }
                    }
                    printWriter.println("  </perf-counter>");
                }
                printWriter.println("</perf-counters>");
                printWriter.flush();
                printWriter.close();
            }
            System.out.println("Check " + this.filename + " for Print Counters");
        } else {
            System.out.println(string + " " + this.entityname + " not found.");
        }
    }

    void printElementDescription(PrintWriter printWriter, String string, ElementDescription elementDescription) {
        printWriter.print("   <" + string + "-key>");
        printWriter.print(elementDescription.getKey());
        printWriter.println("</" + string + "-key>");
        printWriter.print("   <" + string + "-label>");
        printWriter.print(elementDescription.getLabel());
        printWriter.println("</" + string + "-label>");
        printWriter.print("   <" + string + "-summary>");
        printWriter.print(elementDescription.getSummary());
        printWriter.println("</" + string + "-summary>");
    }

    Set<Integer> getPerfIdsAvailable(ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference2) throws RuntimeFaultFaultMsg {
        List list;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (managedObjectReference2 != null && (list = this.vimPort.queryAvailablePerfMetric(managedObjectReference, managedObjectReference2, null, null, new Integer(300))) != null) {
            for (int i = 0; i < list.size(); ++i) {
                hashSet.add(new Integer(((PerfMetricId)list.get(i)).getCounterId()));
            }
        }
        return hashSet;
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, IOException, InvalidPropertyFaultMsg {
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.perfManager = this.serviceContent.getPerfManager();
        this.printCounters();
    }
}

