/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.performance.widgets;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;

public class LineChart
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static long mZoneOffset;
    private static final long serialVersionUID = 1L;
    private Color mLineColor = Color.red;
    private Color mLightLineColor = new Color(255, 128, 128);
    private Color mLightGridColor = new Color(192, 192, 192);
    private Color mDarkGridColor = new Color(128, 128, 128);
    private Color mFrameColor = Color.black;
    private Color mCrossColor = Color.blue;
    private Color mMaskFrameColor = new Color(128, 128, 255, 192);
    private Color mMaskColor = new Color(224, 224, 255, 192);
    private int mLineSampleInterval;
    private long mSampleInterval;
    private String mFormat;
    private String mDFormat;
    private int mAverageWindow;
    private boolean mAntialias;
    private long mTime;
    private int[] mValues;
    private float[] mAverageWindowValues;
    private int mMin;
    private int mMax;
    private DecimalFormat mIntFormat = new DecimalFormat("###,###,###,##0");
    private DecimalFormat mFloatFormat = new DecimalFormat("###,###,###,##0.00");
    private boolean mMouseOver;
    private boolean mMousePressed;
    private int mMouseX;
    private int mMouseY;

    public LineChart(int n, long l, String string, String string2, int n2, boolean bl) {
        this.mLineSampleInterval = n;
        this.mSampleInterval = l;
        this.mFormat = string;
        this.mDFormat = string2;
        this.mAverageWindow = n2;
        this.mAntialias = bl;
        this.setBackground(Color.white);
        this.setValues(new int[0], System.currentTimeMillis());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setAntialias(boolean bl) {
        this.mAntialias = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int[] nArray, long l) {
        int n;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            n = nArray[i];
            if (n > n2) {
                n2 = n;
            }
            if (n >= n3) continue;
            n3 = n;
        }
        if (n2 - n3 < 10) {
            n2 += (10 - (n2 - n3)) / 2;
            n3 -= 10 - (n2 - n3);
        }
        if (n3 < 0) {
            n2 += -n3;
            n3 = 0;
        }
        float[] fArray = new float[nArray.length];
        if (this.mAverageWindow > 1) {
            n = 0;
            for (int i = 0; i < nArray.length; ++i) {
                n += nArray[i];
                if (i >= this.mAverageWindow - 1) {
                    if (i >= this.mAverageWindow) {
                        n -= nArray[i - this.mAverageWindow];
                    }
                    fArray[i] = (float)n / (float)this.mAverageWindow;
                    continue;
                }
                fArray[i] = Float.MIN_VALUE;
            }
        }
        LineChart lineChart = this;
        synchronized (lineChart) {
            this.mTime = l;
            this.mValues = nArray;
            this.mAverageWindowValues = fArray;
            this.mMin = n3;
            this.mMax = n2;
        }
        this.repaint();
    }

    private String getFormattedTime(Date date, boolean bl) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(1);
        String string = Integer.toString(n);
        n = calendar.get(2) - 0 + 1;
        String string2 = n < 10 ? "0" + Integer.toString(n) : Integer.toString(n);
        n = calendar.get(5);
        String string3 = n < 10 ? "0" + Integer.toString(n) : Integer.toString(n);
        n = calendar.get(11);
        String string4 = n < 10 ? "0" + Integer.toString(n) : Integer.toString(n);
        n = calendar.get(12);
        String string5 = n < 10 ? "0" + Integer.toString(n) : Integer.toString(n);
        n = calendar.get(13);
        String string6 = n < 10 ? "0" + Integer.toString(n) : Integer.toString(n);
        n = calendar.get(14) / 10;
        String string7 = n < 10 ? "0" + Integer.toString(n) : Integer.toString(n);
        String string8 = bl ? MessageFormat.format(this.mDFormat, string, string2, string3, string4, string5, string6, string7) : MessageFormat.format(this.mFormat, string, string2, string3, string4, string5, string6, string7);
        return string8;
    }

    private void paintHorizontalGrid(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n6 > 0) {
            int n7 = (int)Math.ceil((float)n2 / (float)((long)n * (long)n6 / (long)(this.mMax - this.mMin)));
            int n8 = 0;
            for (int i = (int)Math.ceil((float)this.mMin / (float)n) * n; i < this.mMax; i += n) {
                int n9 = n4 + n6 - (int)((long)n6 * (long)(i - this.mMin) / (long)(this.mMax - this.mMin));
                if (n8 >= n7) {
                    n8 = 0;
                }
                if (n8 == 0) {
                    String string = this.mIntFormat.format(i);
                    graphics.setColor(this.mFrameColor);
                    graphics.drawString(string, n3 - 5 - graphics.getFontMetrics().stringWidth(string), n9 + (n2 >> 1));
                    graphics.setColor(this.mDarkGridColor);
                } else {
                    graphics.setColor(this.mLightGridColor);
                }
                ++n8;
                if (n5 <= 0) continue;
                graphics.drawLine(n3, n9, n3 + n5, n9);
            }
        }
    }

    private void paintVerticalGrid(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n4 > 0) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = MessageFormat.format(this.mFormat, "00", "00", "00", "00");
            int n6 = fontMetrics.stringWidth(string) + 10;
            int n7 = this.mValues.length > 0 && n4 > 0 ? (int)Math.ceil((float)n6 / (float)(this.mLineSampleInterval * n4 / this.mValues.length)) : 1;
            long l = (this.mTime - (long)this.mValues.length * this.mSampleInterval) / (this.mSampleInterval * (long)this.mLineSampleInterval) * (this.mSampleInterval * (long)this.mLineSampleInterval) - mZoneOffset;
            int n8 = 0;
            for (int i = 0; i < this.mValues.length; ++i) {
                long l2 = this.mTime - (long)(this.mValues.length - i - 1) * this.mSampleInterval;
                if ((l2 - l) / this.mSampleInterval % (long)this.mLineSampleInterval != 0L) continue;
                int n9 = n2 + i * n4 / (this.mValues.length - 1);
                if (n8 >= n7 || n8 == 0) {
                    string = this.getFormattedTime(new Date(l2), false);
                    if (n9 - fontMetrics.stringWidth(string) / 2 >= n2) {
                        graphics.setColor(this.mFrameColor);
                        graphics.drawString(string, n9 - fontMetrics.stringWidth(string) / 2, n3 + n5 + n);
                        graphics.setColor(this.mDarkGridColor);
                        n8 = 1;
                    } else {
                        graphics.setColor(this.mLightGridColor);
                    }
                } else {
                    graphics.setColor(this.mLightGridColor);
                    ++n8;
                }
                if (n5 <= 0) continue;
                graphics.drawLine(n9, n3, n9, n3 + n5);
            }
        }
    }

    private void paintFrame(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n3 > 0 && n4 > 0) {
            graphics.setColor(this.mFrameColor);
            graphics.drawLine(n, n2, n, n2 + n4);
            graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
        }
    }

    private void paintValues(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        if (this.mAverageWindow > 0 && this.mMousePressed) {
            graphics.setColor(this.mLightLineColor);
        } else {
            graphics.setColor(this.mLineColor);
        }
        int n8 = 0;
        int n9 = 0;
        for (n7 = 0; n7 < this.mValues.length; ++n7) {
            n6 = n + n7 * n3 / (this.mValues.length - 1);
            n5 = n2 + n4 - (int)((long)n4 * (long)(this.mValues[n7] - this.mMin) / (long)(this.mMax - this.mMin));
            if (n7 > 0) {
                graphics.drawLine(n8, n9, n6, n5);
            }
            n8 = n6;
            n9 = n5;
        }
        if (this.mAverageWindow > 0 && this.mMousePressed) {
            graphics.setColor(this.mLineColor);
            n8 = 0;
            n9 = 0;
            for (n7 = this.mAverageWindow; n7 < this.mAverageWindowValues.length; ++n7) {
                n6 = n + n7 * n3 / (this.mAverageWindowValues.length - 1);
                n5 = n2 + n4 - (int)((float)n4 * (this.mAverageWindowValues[n7] - (float)this.mMin) / (float)(this.mMax - this.mMin));
                if (n7 > this.mAverageWindow) {
                    graphics.drawLine(n8, n9, n6, n5);
                }
                n8 = n6;
                n9 = n5;
            }
        }
    }

    private void paintOverlayAt(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string, long l) {
        int n8;
        int n9;
        graphics.setColor(this.mCrossColor);
        graphics.drawLine(n6, n3, n6, n3 + n5);
        graphics.drawLine(n2, n7, n2 + n4, n7);
        String string2 = string + " : " + this.getFormattedTime(new Date(l), true);
        int n10 = graphics.getFontMetrics().stringWidth(string2);
        if (n6 + 5 + n10 < n2 + n4) {
            n9 = n6 + 4;
            n8 = n7 + 5 + n < n3 + n5 ? n7 + 4 : n7 - 4 - n;
        } else {
            n9 = n6 - 4 - n10;
            n8 = n7 + 5 + n < n3 + n5 ? n7 + 4 : n7 - 4 - n;
        }
        graphics.setColor(this.mMaskFrameColor);
        graphics.drawRect(n9 - 1, n8 - 1, n10 + 2, n + 2);
        graphics.setColor(this.mMaskColor);
        graphics.fillRect(n9 - 1, n8 - 1, n10 + 2, n + 2);
        graphics.setColor(this.mCrossColor);
        graphics.drawString(string2, n9, n8 + n);
    }

    private void paintOverlay(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (this.mMouseOver && this.mMouseX >= n2 && this.mMouseX <= n2 + n4) {
            int n6 = Math.round((float)(this.mValues.length - 1) * (float)(this.mMouseX - n2) / (float)n4);
            int n7 = 0;
            int n8 = 0;
            String string = null;
            long l = 0L;
            boolean bl = false;
            if (this.mAverageWindow > 0 && this.mMousePressed) {
                if (n6 >= this.mAverageWindow && n6 < this.mAverageWindowValues.length) {
                    n7 = n2 + n6 * n4 / (this.mAverageWindowValues.length - 1);
                    n8 = n3 + n5 - (int)((float)n5 * (this.mAverageWindowValues[n6] - (float)this.mMin) / (float)(this.mMax - this.mMin));
                    string = this.mFloatFormat.format(this.mAverageWindowValues[n6]);
                    l = this.mTime - (long)(this.mAverageWindowValues.length - n6 - 1) * this.mSampleInterval;
                    bl = true;
                }
            } else if (n6 >= 0 && n6 < this.mValues.length) {
                n7 = n2 + n6 * n4 / (this.mValues.length - 1);
                n8 = n3 + n5 - (int)((long)n5 * (long)(this.mValues[n6] - this.mMin) / (long)(this.mMax - this.mMin));
                string = this.mIntFormat.format(this.mValues[n6]);
                l = this.mTime - (long)(this.mValues.length - n6 - 1) * this.mSampleInterval;
                bl = true;
            }
            if (bl) {
                this.paintOverlayAt(graphics, n, n2, n3, n4, n5, n7, n8, string, l);
            }
        }
    }

    @Override
    public synchronized void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        if (graphics.getClass().getName().indexOf("Graphics2D") >= 0) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.mAntialias) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
        int n = 1;
        while ((this.mMax - this.mMin) / n > 20) {
            n *= 10;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.stringWidth(this.mIntFormat.format(this.mMax));
        int n3 = fontMetrics.getAscent();
        int n4 = insets.left + n2 + 5;
        int n5 = insets.top + 5;
        int n6 = dimension.width - n4 - insets.right - 1 - 5;
        int n7 = dimension.height - n5 - insets.bottom - 1 - n3;
        this.paintHorizontalGrid(graphics, n, n3, n4, n5, n6, n7);
        if (this.mValues.length > 1) {
            this.paintVerticalGrid(graphics, n3, n4, n5, n6, n7);
        }
        this.paintFrame(graphics, n4, n5, n6, n7);
        if (n6 > 0 && n7 > 0 && this.mValues.length > 1) {
            this.paintValues(graphics, n4, n5, n6, n7);
            this.paintOverlay(graphics, n3, n4, n5, n6, n7);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mMousePressed = true;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.mMousePressed = false;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mMouseOver = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mMouseOver = false;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mMouseX = mouseEvent.getX();
        this.mMouseY = mouseEvent.getY();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.mMouseX = mouseEvent.getX();
        this.mMouseY = mouseEvent.getY();
        this.repaint();
    }

    static {
        Calendar calendar = Calendar.getInstance();
        mZoneOffset = calendar.get(15);
    }
}

