/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.scsilun;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ArrayOfManagedObjectReference;
import com.vmware.vim25.ArrayOfScsiLun;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.HostScsiDiskPartition;
import com.vmware.vim25.HostVmfsVolume;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.ScsiLun;
import com.vmware.vim25.ScsiLunDurableName;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.VmfsDatastoreInfo;
import java.util.ArrayList;
import java.util.List;

@Sample(name="scsi-lun", description="This sample displays the CanonicalName,Vendor,Model,Data,Namespace and NamespaceId of the host SCSI LUN name")
public class SCSILunName
extends ConnectedVimServiceBase {
    ManagedObjectReference propCollectorRef;
    ManagedObjectReference host;
    private String hostname;

    @Option(name="hostname", description="host for which SCSI details will be displayed")
    public void setHostname(String string) {
        this.hostname = string;
    }

    List<ObjectContent> retrievePropertiesAllObjects(List<PropertyFilterSpec> list) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        ArrayList<ObjectContent> arrayList = new ArrayList<ObjectContent>();
        RetrieveResult retrieveResult = this.vimPort.retrievePropertiesEx(this.propCollectorRef, list, retrieveOptions);
        if (retrieveResult != null && retrieveResult.getObjects() != null && !retrieveResult.getObjects().isEmpty()) {
            arrayList.addAll(retrieveResult.getObjects());
        }
        String string = null;
        if (retrieveResult != null && retrieveResult.getToken() != null) {
            string = retrieveResult.getToken();
        }
        while (string != null && !string.isEmpty()) {
            retrieveResult = this.vimPort.continueRetrievePropertiesEx(this.propCollectorRef, string);
            string = null;
            if (retrieveResult == null) continue;
            string = retrieveResult.getToken();
            if (retrieveResult.getObjects() == null || retrieveResult.getObjects().isEmpty()) continue;
            arrayList.addAll(retrieveResult.getObjects());
        }
        return arrayList;
    }

    TraversalSpec getHostSystemTraversalSpec() {
        SelectionSpec selectionSpec = new SelectionSpec();
        selectionSpec.setName("VisitFolders");
        TraversalSpec traversalSpec = new TraversalSpec();
        traversalSpec.setName("computeResourceToHostSystem");
        traversalSpec.setType("ComputeResource");
        traversalSpec.setPath("host");
        traversalSpec.setSkip(Boolean.valueOf(false));
        traversalSpec.getSelectSet().add(selectionSpec);
        TraversalSpec traversalSpec2 = new TraversalSpec();
        traversalSpec2.setName("hostFolderToComputeResource");
        traversalSpec2.setType("Folder");
        traversalSpec2.setPath("childEntity");
        traversalSpec2.setSkip(Boolean.valueOf(false));
        traversalSpec2.getSelectSet().add(selectionSpec);
        TraversalSpec traversalSpec3 = new TraversalSpec();
        traversalSpec3.setName("DataCenterToHostFolder");
        traversalSpec3.setType("Datacenter");
        traversalSpec3.setPath("hostFolder");
        traversalSpec3.setSkip(Boolean.valueOf(false));
        traversalSpec3.getSelectSet().add(selectionSpec);
        TraversalSpec traversalSpec4 = new TraversalSpec();
        traversalSpec4.setName("VisitFolders");
        traversalSpec4.setType("Folder");
        traversalSpec4.setPath("childEntity");
        traversalSpec4.setSkip(Boolean.valueOf(false));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(selectionSpec);
        arrayList.add(traversalSpec3);
        arrayList.add(traversalSpec2);
        arrayList.add(traversalSpec);
        traversalSpec4.getSelectSet().addAll(arrayList);
        return traversalSpec4;
    }

    ManagedObjectReference getHostByHostName(String string) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        ManagedObjectReference managedObjectReference = null;
        ManagedObjectReference managedObjectReference2 = this.serviceContent.getRootFolder();
        TraversalSpec traversalSpec = this.getHostSystemTraversalSpec();
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.FALSE);
        propertySpec.getPathSet().add("name");
        propertySpec.setType("HostSystem");
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(managedObjectReference2);
        objectSpec.setSkip(Boolean.TRUE);
        objectSpec.getSelectSet().add(traversalSpec);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>(1);
        arrayList.add(propertyFilterSpec);
        List<ObjectContent> list = this.retrievePropertiesAllObjects(arrayList);
        if (list != null) {
            for (ObjectContent objectContent : list) {
                ManagedObjectReference managedObjectReference3 = objectContent.getObj();
                String string2 = null;
                List list2 = objectContent.getPropSet();
                DynamicProperty[] dynamicPropertyArray = list2.toArray(new DynamicProperty[list2.size()]);
                if (dynamicPropertyArray != null) {
                    for (DynamicProperty dynamicProperty : dynamicPropertyArray) {
                        string2 = (String)dynamicProperty.getVal();
                    }
                }
                if (string2 == null || !string2.equals(string)) continue;
                managedObjectReference = managedObjectReference3;
                break;
            }
        } else {
            System.out.println("The Object Content is Null");
        }
        return managedObjectReference;
    }

    List<SelectionSpec> buildFullTraversal() {
        TraversalSpec traversalSpec = new TraversalSpec();
        traversalSpec.setName("rpToVm");
        traversalSpec.setType("ResourcePool");
        traversalSpec.setPath("vm");
        traversalSpec.setSkip(Boolean.FALSE);
        TraversalSpec traversalSpec2 = new TraversalSpec();
        traversalSpec2.setName("vAppToVM");
        traversalSpec2.setType("VirtualApp");
        traversalSpec2.setPath("vm");
        TraversalSpec traversalSpec3 = new TraversalSpec();
        traversalSpec3.setType("HostSystem");
        traversalSpec3.setPath("vm");
        traversalSpec3.setName("hToVm");
        traversalSpec3.getSelectSet().add(this.getSelectionSpec("VisitFolders"));
        traversalSpec3.setSkip(Boolean.FALSE);
        TraversalSpec traversalSpec4 = new TraversalSpec();
        traversalSpec4.setType("Datacenter");
        traversalSpec4.setPath("datastore");
        traversalSpec4.setName("dcToDs");
        traversalSpec4.setSkip(Boolean.FALSE);
        TraversalSpec traversalSpec5 = new TraversalSpec();
        traversalSpec5.setType("ResourcePool");
        traversalSpec5.setPath("resourcePool");
        traversalSpec5.setSkip(Boolean.FALSE);
        traversalSpec5.setName("rpToRp");
        traversalSpec5.getSelectSet().add(this.getSelectionSpec("rpToRp"));
        TraversalSpec traversalSpec6 = new TraversalSpec();
        traversalSpec6.setType("ComputeResource");
        traversalSpec6.setPath("resourcePool");
        traversalSpec6.setSkip(Boolean.FALSE);
        traversalSpec6.setName("crToRp");
        traversalSpec6.getSelectSet().add(this.getSelectionSpec("rpToRp"));
        TraversalSpec traversalSpec7 = new TraversalSpec();
        traversalSpec7.setSkip(Boolean.FALSE);
        traversalSpec7.setType("ComputeResource");
        traversalSpec7.setPath("host");
        traversalSpec7.setName("crToH");
        TraversalSpec traversalSpec8 = new TraversalSpec();
        traversalSpec8.setSkip(Boolean.FALSE);
        traversalSpec8.setType("Datacenter");
        traversalSpec8.setPath("hostFolder");
        traversalSpec8.setName("dcToHf");
        traversalSpec8.getSelectSet().add(this.getSelectionSpec("VisitFolders"));
        TraversalSpec traversalSpec9 = new TraversalSpec();
        traversalSpec9.setName("vAppToRp");
        traversalSpec9.setType("VirtualApp");
        traversalSpec9.setPath("resourcePool");
        traversalSpec9.getSelectSet().add(this.getSelectionSpec("rpToRp"));
        TraversalSpec traversalSpec10 = new TraversalSpec();
        traversalSpec10.setType("Datacenter");
        traversalSpec10.setSkip(Boolean.FALSE);
        traversalSpec10.setPath("vmFolder");
        traversalSpec10.setName("dcToVmf");
        traversalSpec10.getSelectSet().add(this.getSelectionSpec("VisitFolders"));
        TraversalSpec traversalSpec11 = new TraversalSpec();
        traversalSpec11.setType("Folder");
        traversalSpec11.setPath("childEntity");
        traversalSpec11.setSkip(Boolean.FALSE);
        traversalSpec11.setName("VisitFolders");
        ArrayList<SelectionSpec> arrayList = new ArrayList<SelectionSpec>();
        arrayList.add(this.getSelectionSpec("crToRp"));
        arrayList.add(this.getSelectionSpec("crToH"));
        arrayList.add(this.getSelectionSpec("dcToVmf"));
        arrayList.add(this.getSelectionSpec("dcToHf"));
        arrayList.add(this.getSelectionSpec("vAppToRp"));
        arrayList.add(this.getSelectionSpec("vAppToVM"));
        arrayList.add(this.getSelectionSpec("dcToDs"));
        arrayList.add(this.getSelectionSpec("hToVm"));
        arrayList.add(this.getSelectionSpec("rpToVm"));
        arrayList.add(this.getSelectionSpec("VisitFolders"));
        traversalSpec11.getSelectSet().addAll(arrayList);
        ArrayList<SelectionSpec> arrayList2 = new ArrayList<SelectionSpec>();
        arrayList2.add((SelectionSpec)traversalSpec11);
        arrayList2.add((SelectionSpec)traversalSpec6);
        arrayList2.add((SelectionSpec)traversalSpec7);
        arrayList2.add((SelectionSpec)traversalSpec10);
        arrayList2.add((SelectionSpec)traversalSpec8);
        arrayList2.add((SelectionSpec)traversalSpec9);
        arrayList2.add((SelectionSpec)traversalSpec2);
        arrayList2.add((SelectionSpec)traversalSpec4);
        arrayList2.add((SelectionSpec)traversalSpec3);
        arrayList2.add((SelectionSpec)traversalSpec);
        arrayList2.add((SelectionSpec)traversalSpec5);
        return arrayList2;
    }

    SelectionSpec getSelectionSpec(String string) {
        SelectionSpec selectionSpec = new SelectionSpec();
        selectionSpec.setName(string);
        return selectionSpec;
    }

    List<DynamicProperty> getDynamicPropArray(ManagedObjectReference managedObjectReference, String string, String string2) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.FALSE);
        propertySpec.getPathSet().add(string2);
        propertySpec.setType(string);
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(managedObjectReference);
        objectSpec.setSkip(Boolean.FALSE);
        objectSpec.getSelectSet().addAll(this.buildFullTraversal());
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>(1);
        arrayList.add(propertyFilterSpec);
        List<ObjectContent> list = this.retrievePropertiesAllObjects(arrayList);
        ObjectContent objectContent = list.get(0);
        List list2 = objectContent.getPropSet();
        return list2;
    }

    void getVMFS(ManagedObjectReference managedObjectReference, String string) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        List<DynamicProperty> list = this.getDynamicPropArray(this.host, "HostSystem", "datastore");
        ArrayOfManagedObjectReference arrayOfManagedObjectReference = (ArrayOfManagedObjectReference)list.get(0).getVal();
        List list2 = arrayOfManagedObjectReference.getManagedObjectReference();
        boolean bl = false;
        for (int i = 0; i < list2.size(); ++i) {
            List<DynamicProperty> list3 = this.getDynamicPropArray((ManagedObjectReference)list2.get(i), "Datastore", "info");
            String string2 = list3.get(0).getVal().getClass().toString();
            if (!string2.equals("class com.vmware.vim.VmfsDatastoreInfo")) continue;
            VmfsDatastoreInfo vmfsDatastoreInfo = (VmfsDatastoreInfo)list3.get(0).getVal();
            HostVmfsVolume hostVmfsVolume = vmfsDatastoreInfo.getVmfs();
            String string3 = vmfsDatastoreInfo.getName();
            List list4 = hostVmfsVolume.getExtent();
            for (int j = 0; j < list4.size(); ++j) {
                if (!((HostScsiDiskPartition)list4.get(j)).getDiskName().equals(string)) continue;
                bl = true;
                System.out.println(" " + string3 + "\n");
            }
        }
        if (!bl) {
            System.out.println(" None\n");
        }
    }

    void getVMs(ManagedObjectReference managedObjectReference, String string) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        List<DynamicProperty> list = this.getDynamicPropArray(this.host, "HostSystem", "datastore");
        ArrayOfManagedObjectReference arrayOfManagedObjectReference = (ArrayOfManagedObjectReference)list.get(0).getVal();
        List list2 = arrayOfManagedObjectReference.getManagedObjectReference();
        boolean bl = false;
        for (int i = 0; i < list2.size(); ++i) {
            List<DynamicProperty> list3 = this.getDynamicPropArray((ManagedObjectReference)list2.get(i), "Datastore", "info");
            String string2 = list3.get(0).getVal().getClass().toString();
            if (!string2.equals("class com.vmware.vim.VmfsDatastoreInfo")) continue;
            VmfsDatastoreInfo vmfsDatastoreInfo = (VmfsDatastoreInfo)list3.get(0).getVal();
            HostVmfsVolume hostVmfsVolume = vmfsDatastoreInfo.getVmfs();
            List list4 = hostVmfsVolume.getExtent();
            for (int j = 0; j < list4.size(); ++j) {
                List<DynamicProperty> list5;
                ArrayOfManagedObjectReference arrayOfManagedObjectReference2;
                List list6;
                if (!((HostScsiDiskPartition)list4.get(j)).getDiskName().equals(string) || (list6 = (arrayOfManagedObjectReference2 = (ArrayOfManagedObjectReference)(list5 = this.getDynamicPropArray((ManagedObjectReference)list2.get(i), "Datastore", "vm")).get(0).getVal()).getManagedObjectReference()) == null) continue;
                for (int k = 0; k < list6.size(); ++k) {
                    bl = true;
                    List<DynamicProperty> list7 = this.getDynamicPropArray((ManagedObjectReference)list6.get(k), "VirtualMachine", "name");
                    String string3 = list7.get(0).getVal().toString();
                    System.out.println(" " + string3);
                }
            }
        }
        if (!bl) {
            System.out.println(" None\n");
        }
    }

    public void printLunInfo(ManagedObjectReference managedObjectReference) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        List<DynamicProperty> list = this.getDynamicPropArray(managedObjectReference, "HostSystem", "config.storageDevice.scsiLun");
        ArrayOfScsiLun arrayOfScsiLun = (ArrayOfScsiLun)list.get(0).getVal();
        List list2 = arrayOfScsiLun.getScsiLun();
        if (list2 != null && list2.size() > 0) {
            for (int i = 0; i < list2.size(); ++i) {
                System.out.println("\nSCSI LUN " + (i + 1));
                System.out.println("--------------");
                String string = ((ScsiLun)list2.get(i)).getCanonicalName();
                if (((ScsiLun)list2.get(i)).getDurableName() != null) {
                    ScsiLunDurableName scsiLunDurableName = ((ScsiLun)list2.get(i)).getDurableName();
                    List list3 = scsiLunDurableName.getData();
                    String string2 = scsiLunDurableName.getNamespace();
                    byte by = scsiLunDurableName.getNamespaceId();
                    System.out.print("\nData            : ");
                    for (int j = 0; j < list3.size(); ++j) {
                        System.out.print(list3.get(j) + " ");
                    }
                    System.out.println("\nCanonical Name  : " + string);
                    System.out.println("Namespace       : " + string2);
                    System.out.println("Namespace ID    : " + by);
                    System.out.println("\nVMFS Affected ");
                    this.getVMFS(managedObjectReference, string);
                    System.out.println("Virtual Machines ");
                    this.getVMs(managedObjectReference, string);
                    continue;
                }
                System.out.println("\nDurable name for " + ((ScsiLun)list2.get(i)).getCanonicalName() + " does not exist");
            }
        }
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.host = this.getHostByHostName(this.hostname);
        this.printLunInfo(this.host);
    }
}

