/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.security.credstore;

import com.vmware.security.credstore.CredentialStore;
import com.vmware.security.credstore.CredentialStoreFactory;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class CredentialStoreAdmin {
    private static void printUsage() {
        System.out.println("The CredentialStoreAdmin class is a command-line tool that provides complete access to the credential store backing file on the local machine.");
        System.out.println("\tcommon        [required]:");
        System.out.println("\thelp: Display help for the commands for this tool");
        System.out.println("\tadd: Add a user account and password for a specified host to the credential store");
        System.out.println("\tlist: List all host names and user accounts contained in the credential store; use with:-");
        System.out.println("\t--showpw: argument to display in cleartext");
        System.out.println("\t-h: argument to list user name and password for the host");
        System.out.println("\tremove: Remove the user account and password from the credential store for the specified account");
        System.out.println("\tclear: Clear all content from the credential store");
        System.out.println("\nArguments:");
        System.out.println("-f: filename. Optional. Specify a different name, including path, for the credential store backing file");
        System.out.println("-h: hostname. Required for add, get, and remove. Optional for list");
        System.out.println("-u: user account. Required for add, get, and remove");
        System.out.println("-p: password. Required for add");
        System.out.println("--showpw: Displays password in cleartext");
        System.out.println("\nCommand Usage Examples:");
        System.out.println("run.bat com.vmware.security.credstore.CredentialStoreAdmin clear");
        System.out.println("run.bat com.vmware.security.credstore.CredentialStoreAdmin add -h hostname -u user -p password");
        System.out.println("run.bat com.vmware.security.credstore.CredentialStoreAdmin list -h hostname");
    }

    private static CredentialStore getCredentialStoreObject(boolean bl, File file) throws IOException {
        String string;
        CredentialStore credentialStore = bl ? CredentialStoreFactory.getCredentialStore(file) : ((string = System.getenv("VI_CREDSTORE")) == null ? CredentialStoreFactory.getCredentialStore() : CredentialStoreFactory.getCredentialStore(new File(string)));
        return credentialStore;
    }

    private static void missingOptionValueExit() {
        System.out.println("Missing option value.");
        CredentialStoreAdmin.printUsage();
        System.exit(1);
    }

    public static void main(String[] stringArray) throws IllegalBlockSizeException, BadPaddingException {
        if (stringArray.length == 0) {
            CredentialStoreAdmin.printUsage();
            System.exit(0);
        }
        String string = "--showpw";
        String string2 = "-f";
        String string3 = "-h";
        String string4 = "-u";
        String string5 = "-p";
        String string6 = "help";
        String string7 = "add";
        String string8 = "get";
        String string9 = "remove";
        String string10 = "clear";
        String string11 = "list";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string12 = "";
        String string13 = "";
        File file = null;
        String string14 = "";
        String string15 = "";
        String string16 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].charAt(0) == '-') {
                if (stringArray[i].compareTo(string) == 0) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].compareTo(string2) == 0) {
                    bl2 = true;
                    if (++i == stringArray.length) {
                        CredentialStoreAdmin.missingOptionValueExit();
                    }
                    file = new File(stringArray[i]);
                    continue;
                }
                if (stringArray[i].compareTo(string3) == 0) {
                    bl3 = true;
                    if (++i == stringArray.length) {
                        CredentialStoreAdmin.missingOptionValueExit();
                    }
                    string14 = stringArray[i];
                    continue;
                }
                if (stringArray[i].compareTo(string4) == 0) {
                    bl4 = true;
                    if (++i == stringArray.length) {
                        CredentialStoreAdmin.missingOptionValueExit();
                    }
                    string15 = stringArray[i];
                    continue;
                }
                if (stringArray[i].compareTo(string5) == 0) {
                    bl5 = true;
                    if (++i == stringArray.length) {
                        CredentialStoreAdmin.missingOptionValueExit();
                    }
                    string16 = stringArray[i];
                    continue;
                }
                System.out.println("Invalid flag " + stringArray[i] + "\n");
                CredentialStoreAdmin.printUsage();
                System.exit(1);
                continue;
            }
            if (i != 0) {
                System.out.println("Incorrect usage");
                CredentialStoreAdmin.printUsage();
                System.exit(1);
            }
            if (stringArray[i].compareTo(string6) == 0) {
                string12 = stringArray[i];
                continue;
            }
            if (string12.length() > 0) {
                string12 = stringArray[i];
                continue;
            }
            string13 = stringArray[i];
        }
        if (string12.length() > 0) {
            CredentialStoreAdmin.printUsage();
            System.exit(0);
        }
        if (string13.length() == 0) {
            System.out.println("Missing common.");
            CredentialStoreAdmin.printUsage();
            System.exit(1);
        }
        try {
            Iterator<String> iterator;
            if (string13.compareTo(string7) == 0) {
                if (bl3 && bl4 && bl5) {
                    CredentialStore credentialStore;
                    if (bl) {
                        System.out.println("Invalid option(s) specified for command " + string13);
                        CredentialStoreAdmin.printUsage();
                        System.exit(1);
                    }
                    if (((Boolean)((Object)(iterator = Boolean.valueOf((credentialStore = CredentialStoreAdmin.getCredentialStoreObject(bl2, file)).addPassword(string14, string15, string16))))).booleanValue()) {
                        System.out.println("Entry added successfully");
                    }
                } else {
                    System.out.println("Missing argument(s) for command " + string13);
                    CredentialStoreAdmin.printUsage();
                    System.exit(1);
                }
                System.exit(0);
            }
            if (string13.compareTo(string8) == 0) {
                if (bl3 && bl4) {
                    CredentialStore credentialStore;
                    if (bl || bl5) {
                        System.out.println("Invalid option(s) specified for command " + string13);
                        CredentialStoreAdmin.printUsage();
                        System.exit(1);
                    }
                    if ((iterator = (credentialStore = CredentialStoreAdmin.getCredentialStoreObject(bl2, file)).getPassword(string14, string15)) != null) {
                        System.out.println((String)((Object)iterator));
                    } else {
                        System.out.println("No entry found for specified host and user");
                    }
                } else {
                    System.out.println("Missing argument(s) for command " + string13);
                    CredentialStoreAdmin.printUsage();
                    System.exit(1);
                }
                System.exit(0);
            }
            if (string13.compareTo(string9) == 0) {
                if (bl3 && bl4) {
                    if (bl || bl5) {
                        System.out.println("Invalid option(s) specified for command " + string13);
                        CredentialStoreAdmin.printUsage();
                        System.exit(1);
                    }
                    CredentialStore credentialStore = CredentialStoreAdmin.getCredentialStoreObject(bl2, file);
                    credentialStore.removePassword(string14, string15);
                    System.out.println("Entry removed from the credstore...");
                } else {
                    System.out.println("Missing argument(s) for command " + string13);
                    CredentialStoreAdmin.printUsage();
                    System.exit(1);
                }
                System.exit(0);
            }
            if (string13.compareTo(string10) == 0) {
                if (bl3 || bl4 || bl5 || bl) {
                    System.out.println("Invalid option(s) specified for command " + string13);
                    CredentialStoreAdmin.printUsage();
                    System.exit(1);
                }
                CredentialStore credentialStore = CredentialStoreAdmin.getCredentialStoreObject(bl2, file);
                credentialStore.clearPasswords();
                System.out.println("All entries cleared from the credstore...");
                System.exit(0);
            }
            if (string13.compareTo(string11) == 0) {
                if (bl4 || bl5) {
                    System.out.println("Invalid option(s) specified for command " + string13);
                    CredentialStoreAdmin.printUsage();
                    System.exit(1);
                }
                CredentialStore credentialStore = CredentialStoreAdmin.getCredentialStoreObject(bl2, file);
                if (bl3) {
                    for (String string17 : credentialStore.getUsernames(string14)) {
                        if (bl) {
                            System.out.print(string17 + "\t");
                            System.out.println(credentialStore.getPassword(string14, string17));
                            continue;
                        }
                        System.out.println(string17);
                    }
                } else {
                    for (String string18 : credentialStore.getHosts()) {
                        for (String string19 : credentialStore.getUsernames(string18)) {
                            if (bl) {
                                System.out.print(string18 + "\t" + string19 + "\t");
                                System.out.println(credentialStore.getPassword(string18, string19));
                                continue;
                            }
                            System.out.println(string18 + "\t" + string19);
                        }
                    }
                }
                System.exit(0);
            }
            System.out.println("Invalid command " + string13);
            System.exit(1);
            CredentialStoreAdmin.printUsage();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        System.exit(0);
    }
}

