/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapp;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ConcurrentAccessFaultMsg;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.HttpNfcLeaseDeviceUrl;
import com.vmware.vim25.HttpNfcLeaseInfo;
import com.vmware.vim25.HttpNfcLeaseState;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidPowerStateFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.OvfCreateDescriptorParams;
import com.vmware.vim25.OvfCreateDescriptorResult;
import com.vmware.vim25.OvfFile;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInProgressFaultMsg;
import com.vmware.vim25.TimedoutFaultMsg;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VmConfigFaultFaultMsg;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.ws.BindingProvider;

@Sample(name="ovf-manager-export-vapp", description="This sample demonstrates OVFManager.\nExports VMDK's and OVF Descriptor of all VM's in the vApps")
public class OVFManagerExportVAPP
extends ConnectedVimServiceBase {
    private ManagedObjectReference propCollectorRef;
    private volatile long TOTAL_BYTES = 0L;
    private volatile long TOTAL_BYTES_WRITTEN = 0L;
    private volatile HttpNfcLeaseExtender leaseExtender;
    private volatile boolean vmdkFlag;
    private String cookieValue;
    String host;
    String vApp = null;
    String localpath = null;

    @Option(name="vapp", description="Name of the vapp")
    public void setvApp(String string) {
        this.vApp = string;
    }

    @Option(name="localpath", description="local System Folder path")
    public void setLocalpath(String string) {
        this.localpath = string;
    }

    @Option(name="host", description="Name of the host")
    public void setHost(String string) {
        this.host = string;
    }

    void printHttpNfcLeaseInfo(HttpNfcLeaseInfo httpNfcLeaseInfo, String string) {
        System.out.println("########################################################");
        System.out.println("HttpNfcLeaseInfo");
        System.out.println("Lease Timeout: " + httpNfcLeaseInfo.getLeaseTimeout());
        System.out.println("Total Disk capacity: " + httpNfcLeaseInfo.getTotalDiskCapacityInKB());
        List list = httpNfcLeaseInfo.getDeviceUrl();
        if (list != null) {
            int n = 1;
            for (HttpNfcLeaseDeviceUrl httpNfcLeaseDeviceUrl : list) {
                System.out.println("HttpNfcLeaseDeviceUrl : " + n++);
                System.out.println("   Device URL Import Key: " + httpNfcLeaseDeviceUrl.getImportKey());
                System.out.println("   Device URL Key: " + httpNfcLeaseDeviceUrl.getKey());
                System.out.println("   Device URL : " + httpNfcLeaseDeviceUrl.getUrl());
                System.out.println("   Updated device URL: " + httpNfcLeaseDeviceUrl.getUrl().replace("*", string));
                System.out.println("   SSL Thumbprint : " + httpNfcLeaseDeviceUrl.getSslThumbprint());
            }
        } else {
            System.out.println("No Device URLS Found");
            System.out.println("########################################################");
        }
    }

    long writeVMDKFile(String string, String string2) throws IOException {
        URL uRL = new URL(string2);
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
        httpsURLConnection.setDoInput(true);
        httpsURLConnection.setDoOutput(true);
        httpsURLConnection.setAllowUserInteraction(true);
        List list = (List)this.headers.get("Set-cookie");
        this.cookieValue = (String)list.get(0);
        StringTokenizer stringTokenizer = new StringTokenizer(this.cookieValue, ";");
        this.cookieValue = stringTokenizer.nextToken();
        String string3 = "$" + stringTokenizer.nextToken();
        String string4 = "$Version=\"1\"; " + this.cookieValue + "; " + string3;
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("Cookie", Collections.singletonList(string4));
        ((BindingProvider)this.vimPort).getRequestContext().put("javax.xml.ws.http.request.headers", hashMap);
        httpsURLConnection.setRequestProperty("Cookie", string4);
        httpsURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
        httpsURLConnection.setRequestProperty("Expect", "100-continue");
        httpsURLConnection.setRequestMethod("GET");
        httpsURLConnection.setRequestProperty("Content-Length", "1024");
        InputStream inputStream = httpsURLConnection.getInputStream();
        String string5 = this.localpath + "/" + string;
        FileOutputStream fileOutputStream = new FileOutputStream(new File(string5));
        byte[] byArray = new byte[102400];
        int n = 0;
        long l = 0L;
        while ((n = inputStream.read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
            l += (long)n;
        }
        System.out.println("   Exported File " + string + " : " + l);
        inputStream.close();
        ((OutputStream)fileOutputStream).close();
        return l;
    }

    void exportVApp() throws RuntimeFaultFaultMsg, TaskInProgressFaultMsg, FileFaultFaultMsg, InvalidStateFaultMsg, InvalidPowerStateFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg, IOException, TimedoutFaultMsg, VmConfigFaultFaultMsg, ConcurrentAccessFaultMsg {
        File file = new File(this.localpath);
        if (!file.exists()) {
            System.out.println("Wrong or invalid path " + this.localpath);
            return;
        }
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "HostSystem", new RetrieveOptions());
        ManagedObjectReference managedObjectReference = map.get(this.host);
        if (managedObjectReference == null) {
            System.out.println("Host Not Found");
        } else {
            Map<String, ManagedObjectReference> map2 = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "VirtualApp", new RetrieveOptions());
            ManagedObjectReference managedObjectReference2 = map2.get(this.vApp);
            if (managedObjectReference2 != null) {
                OvfCreateDescriptorParams ovfCreateDescriptorParams = new OvfCreateDescriptorParams();
                ManagedObjectReference managedObjectReference3 = this.vimPort.exportVApp(managedObjectReference2);
                System.out.println("Getting the HTTP NFCLEASE for the vApp: " + this.vApp);
                Object[] objectArray = this.waitForValues.wait(managedObjectReference3, new String[]{"state"}, new String[]{"state"}, new Object[][]{{HttpNfcLeaseState.READY, HttpNfcLeaseState.ERROR}});
                if (objectArray[0].equals(HttpNfcLeaseState.READY)) {
                    HttpNfcLeaseInfo httpNfcLeaseInfo = (HttpNfcLeaseInfo)this.getMOREFs.entityProps(managedObjectReference3, new String[]{"info"}).get("info");
                    httpNfcLeaseInfo.setLeaseTimeout(300000000);
                    this.printHttpNfcLeaseInfo(httpNfcLeaseInfo, this.host);
                    long l = httpNfcLeaseInfo.getTotalDiskCapacityInKB() * 1024L;
                    System.out.println("************ " + l);
                    this.TOTAL_BYTES = l;
                    OVFManagerExportVAPP oVFManagerExportVAPP = new OVFManagerExportVAPP();
                    oVFManagerExportVAPP.getClass();
                    this.leaseExtender = oVFManagerExportVAPP.new HttpNfcLeaseExtender(managedObjectReference3, this.vimPort);
                    Thread thread = new Thread(this.leaseExtender);
                    thread.start();
                    List list = httpNfcLeaseInfo.getDeviceUrl();
                    if (list != null) {
                        Object object;
                        Object object2;
                        String string;
                        ArrayList<OvfFile> arrayList = new ArrayList<OvfFile>();
                        for (int i = 0; i < list.size(); ++i) {
                            System.out.println("Downloading Files:");
                            string = ((HttpNfcLeaseDeviceUrl)list.get(i)).getKey();
                            object2 = ((HttpNfcLeaseDeviceUrl)list.get(i)).getUrl();
                            object = ((String)object2).substring(((String)object2).lastIndexOf("/") + 1);
                            System.out.println("   Absolute File Name: " + (String)object);
                            System.out.println("   VMDK URL: " + ((String)object2).replace("*", this.host));
                            long l2 = this.writeVMDKFile((String)object, ((String)object2).replace("*", this.host));
                            OvfFile ovfFile = new OvfFile();
                            ovfFile.setPath((String)object);
                            ovfFile.setDeviceId(string);
                            ovfFile.setSize(l2);
                            arrayList.add(ovfFile);
                        }
                        ovfCreateDescriptorParams.getOvfFiles().addAll(arrayList);
                        OvfCreateDescriptorResult ovfCreateDescriptorResult = this.vimPort.createDescriptor(this.serviceContent.getOvfManager(), managedObjectReference2, ovfCreateDescriptorParams);
                        System.out.println();
                        string = this.localpath + "/" + this.vApp + ".ovf";
                        object2 = new File(string);
                        object = new FileWriter((File)object2);
                        ((Writer)object).write(ovfCreateDescriptorResult.getOvfDescriptor());
                        ((OutputStreamWriter)object).close();
                        System.out.println("OVF Desriptor Written to file " + this.vApp + ".ovf");
                        System.out.println("DONE");
                        if (!ovfCreateDescriptorResult.getError().isEmpty()) {
                            System.out.println("SOME ERRORS");
                        }
                        if (!ovfCreateDescriptorResult.getWarning().isEmpty()) {
                            System.out.println("SOME WARNINGS");
                        }
                    } else {
                        System.out.println("No Device URLS");
                    }
                    System.out.println("Completed Downloading the files");
                    this.vmdkFlag = true;
                    thread.interrupt();
                    this.vimPort.httpNfcLeaseProgress(managedObjectReference3, 100);
                    this.vimPort.httpNfcLeaseComplete(managedObjectReference3);
                } else {
                    System.out.println("HttpNfcLeaseState not ready");
                    System.out.println("HttpNfcLeaseState: " + objectArray);
                }
            } else {
                System.out.println("vApp Not Found");
            }
        }
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, TaskInProgressFaultMsg, VmConfigFaultFaultMsg, IOException, InvalidPropertyFaultMsg, FileFaultFaultMsg, ConcurrentAccessFaultMsg, InvalidStateFaultMsg, InvalidCollectorVersionFaultMsg, InvalidPowerStateFaultMsg, TimedoutFaultMsg {
        this.exportVApp();
    }

    private class HttpNfcLeaseExtender
    implements Runnable {
        private ManagedObjectReference httpNfcLease = null;

        public HttpNfcLeaseExtender(ManagedObjectReference managedObjectReference, VimPortType vimPortType) {
            this.httpNfcLease = managedObjectReference;
            OVFManagerExportVAPP.this.vimPort = vimPortType;
        }

        @Override
        public void run() {
            try {
                System.out.println("---------------------- Thread for Checking the HTTP NFCLEASE vmdkFlag: " + OVFManagerExportVAPP.this.vmdkFlag + "----------------------");
                while (!OVFManagerExportVAPP.this.vmdkFlag) {
                    System.out.println("#### TOTAL_BYTES_WRITTEN " + OVFManagerExportVAPP.this.TOTAL_BYTES_WRITTEN);
                    System.out.println("#### TOTAL_BYTES " + OVFManagerExportVAPP.this.TOTAL_BYTES);
                    try {
                        OVFManagerExportVAPP.this.vimPort.httpNfcLeaseProgress(this.httpNfcLease, 0);
                        Thread.sleep(290000000L);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println("---------------------- Thread interrupted ----------------------");
                        break;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

