/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vm;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.InsufficientResourcesFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.MigrationFaultFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.TimedoutFaultMsg;
import com.vmware.vim25.VirtualMachineRelocateSpec;
import com.vmware.vim25.VmConfigFaultFaultMsg;
import java.util.Map;

@Sample(name="vm-relocate", description="Used to relocate a linked clone using disk move type")
public class VMRelocate
extends ConnectedVimServiceBase {
    static final String[] diskMoveTypes = new String[]{"moveChildMostDiskBacking", "moveAllDiskBackingsAndAllowSharing"};
    private ManagedObjectReference propCollectorRef;
    String vmname = null;
    String diskMoveType = null;
    String datastoreName = null;

    @Option(name="vmname", description="name of the virtual machine")
    public void setVmname(String string) {
        this.vmname = string;
    }

    @Option(name="diskmovetype", description="Either of\n[moveChildMostDiskBacking | moveAllDiskBackingsAndAllowSharing]")
    public void setDiskMoveType(String string) {
        this.check(string, diskMoveTypes);
        this.diskMoveType = string;
    }

    @Option(name="datastorename", description="Name of the datastore")
    public void setDatastoreName(String string) {
        this.datastoreName = string;
    }

    void relocate() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidDatastoreFaultMsg, FileFaultFaultMsg, MigrationFaultFaultMsg, InvalidStateFaultMsg, TimedoutFaultMsg, InvalidCollectorVersionFaultMsg {
        ManagedObjectReference managedObjectReference = this.getMOREFs.vmByVMname(this.vmname, this.propCollectorRef);
        ManagedObjectReference managedObjectReference2 = null;
        Map<String, ManagedObjectReference> map = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "Datastore");
        if (map.containsKey(this.datastoreName)) {
            managedObjectReference2 = map.get(this.datastoreName);
        }
        if (managedObjectReference2 == null) {
            System.out.println("Datastore " + this.datastoreName + " Not Found");
            return;
        }
        if (managedObjectReference != null) {
            VirtualMachineRelocateSpec virtualMachineRelocateSpec = new VirtualMachineRelocateSpec();
            String string = this.diskMoveType;
            if (string.equalsIgnoreCase("moveChildMostDiskBacking")) {
                virtualMachineRelocateSpec.setDiskMoveType("moveChildMostDiskBacking");
            } else if (string.equalsIgnoreCase("moveAllDiskBackingsAndAllowSharing")) {
                virtualMachineRelocateSpec.setDiskMoveType("moveAllDiskBackingsAndAllowSharing");
            }
            virtualMachineRelocateSpec.setDatastore(managedObjectReference2);
            ManagedObjectReference managedObjectReference3 = this.vimPort.relocateVMTask(managedObjectReference, virtualMachineRelocateSpec, null);
            if (this.getTaskResultAfterDone(managedObjectReference3)) {
                System.out.println("Linked Clone relocated successfully.");
            } else {
                System.out.println("Failure -: Linked clone cannot be relocated");
            }
        } else {
            System.out.println("Virtual Machine " + this.vmname + " doesn't exist");
        }
    }

    boolean customValidation() {
        boolean bl = true;
        String string = this.diskMoveType;
        if (!string.equalsIgnoreCase("moveChildMostDiskBacking") && !string.equalsIgnoreCase("moveAllDiskBackingsAndAllowSharing")) {
            System.out.println("diskmovetype option must be either moveChildMostDiskBacking or moveAllDiskBackingsAndAllowSharing");
            bl = false;
        }
        return bl;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    boolean check(String string, String[] stringArray) {
        boolean bl = false;
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            bl = true;
        }
        return bl;
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, InsufficientResourcesFaultFaultMsg, VmConfigFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidPropertyFaultMsg, FileFaultFaultMsg, InvalidStateFaultMsg, MigrationFaultFaultMsg, InvalidCollectorVersionFaultMsg, TimedoutFaultMsg {
        this.customValidation();
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.relocate();
    }
}

