/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.client.wssecurity;

import com.vmware.sso.client.wssecurity.WsSecuritySignature;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class WsSecuritySignatureImpl
implements WsSecuritySignature {
    protected final XMLSignatureFactory xmlSigFactory = XMLSignatureFactory.getInstance();
    private final PrivateKey _privateKey;
    private final X509Certificate _userCert;

    public PrivateKey getPrivateKey() {
        return this._privateKey;
    }

    public X509Certificate getUserCert() {
        return this._userCert;
    }

    public WsSecuritySignatureImpl(PrivateKey privateKey, X509Certificate x509Certificate) {
        this._privateKey = privateKey;
        this._userCert = x509Certificate;
    }

    @Override
    public SOAPMessage sign(SOAPMessage sOAPMessage) throws SignatureException, SOAPException {
        try {
            CanonicalizationMethod canonicalizationMethod = this.xmlSigFactory.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null);
            SignatureMethod signatureMethod = this.xmlSigFactory.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", null);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.createSoapBodyUuid(sOAPMessage));
            arrayList.add(this.createTimestampUuid(sOAPMessage));
            List<Reference> list = this.createSignatureReferences(arrayList);
            SignedInfo signedInfo = this.xmlSigFactory.newSignedInfo(canonicalizationMethod, signatureMethod, list);
            KeyInfoFactory keyInfoFactory = KeyInfoFactory.getInstance();
            KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(new DOMStructure(this.createKeyInfoContent(sOAPMessage))));
            XMLSignature xMLSignature = this.xmlSigFactory.newXMLSignature(signedInfo, keyInfo, null, this.addUseKeySignatureId(sOAPMessage), null);
            DOMSignContext dOMSignContext = new DOMSignContext(this.getPrivateKey(), sOAPMessage.getSOAPHeader().getFirstChild());
            dOMSignContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
            xMLSignature.sign(dOMSignContext);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("Error while creating SOAP request signature");
            noSuchAlgorithmException.printStackTrace();
            throw new SignatureException("Error while creating SOAP request signature", noSuchAlgorithmException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            System.out.println("Error while creating SOAP request signature");
            invalidAlgorithmParameterException.printStackTrace();
            throw new SignatureException("Error while creating SOAP request signature", invalidAlgorithmParameterException);
        }
        catch (MarshalException marshalException) {
            System.out.println("Error while creating SOAP request signature");
            marshalException.printStackTrace();
            throw new SignatureException("Error while creating SOAP request signature", marshalException);
        }
        catch (XMLSignatureException xMLSignatureException) {
            System.out.println("Error while creating SOAP request signature");
            xMLSignatureException.printStackTrace();
            throw new SignatureException("Error while creating SOAP request signature", xMLSignatureException);
        }
        return sOAPMessage;
    }

    protected abstract String addUseKeySignatureId(SOAPMessage var1);

    protected abstract Node createKeyInfoContent(SOAPMessage var1);

    protected List<Reference> createSignatureReferences(ArrayList<String> arrayList) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        ArrayList<Reference> arrayList2 = new ArrayList<Reference>();
        for (String string : arrayList) {
            if (string == null) continue;
            Reference reference = this.xmlSigFactory.newReference("#" + string, this.xmlSigFactory.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha512", null), Collections.singletonList(this.xmlSigFactory.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null)), null, null);
            arrayList2.add(reference);
        }
        return Collections.unmodifiableList(arrayList2);
    }

    protected String createTimestampUuid(SOAPMessage sOAPMessage) throws SOAPException {
        NodeList nodeList = sOAPMessage.getSOAPHeader().getOwnerDocument().getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp");
        assert (nodeList.getLength() <= 1);
        if (nodeList.getLength() == 1) {
            assert (nodeList.item(0).getNodeType() == 1);
            Element element = (Element)nodeList.item(0);
            String string = "_" + UUID.randomUUID().toString();
            element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", element.getPrefix() + ":" + "Id", string);
            return string;
        }
        System.out.println("Timestamp element not found in the message");
        return null;
    }

    protected String createSoapBodyUuid(SOAPMessage sOAPMessage) throws SOAPException {
        String string = "_" + UUID.randomUUID().toString();
        sOAPMessage.getSOAPBody().addAttribute(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id", "wsu"), string);
        return string;
    }
}

