/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.samples;

import com.vmware.sso.client.samples.AcquireBearerTokenByUserCredentialSample;
import com.vmware.sso.client.samples.AcquireHoKTokenByUserCredentialSample;
import com.vmware.sso.client.soaphandlers.HeaderHandlerResolver;
import com.vmware.sso.client.soaphandlers.SamlTokenHandler;
import com.vmware.sso.client.soaphandlers.TimeStampHandler;
import com.vmware.sso.client.soaphandlers.WsSecuritySignatureAssertionHandler;
import com.vmware.sso.client.utils.SecurityUtil;
import com.vmware.sso.client.utils.Utils;
import com.vmware.vim25.InvalidLocaleFaultMsg;
import com.vmware.vim25.InvalidLoginFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VimService;
import com.vmware.vsphere.soaphandlers.HeaderCookieExtractionHandler;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.soap.SOAPFaultException;
import org.w3c.dom.Element;

public class LoginByTokenSample {
    public static VimPortType vimPort;
    public static ManagedObjectReference SVC_INST_REF;
    private static VimService vimService;
    private static HandlerResolver defaultHandler;
    private static ServiceContent serviceContent;
    private static boolean isConnected;

    private static void clearHandlerResolver(String string, String string2) {
        vimService.setHandlerResolver(defaultHandler);
        vimPort = vimService.getVimPort();
        Map map = ((BindingProvider)vimPort).getRequestContext();
        map.put("javax.xml.ws.service.endpoint.address", string);
        map.put("javax.xml.ws.session.maintain", true);
        HashMap<String, List<String>> hashMap = (HashMap<String, List<String>>)map.get("javax.xml.ws.http.request.headers");
        if (hashMap == null) {
            hashMap = new HashMap<String, List<String>>();
        }
        hashMap.put("Cookie", Arrays.asList(string2));
        map.put("javax.xml.ws.http.request.headers", hashMap);
    }

    public static void getCurrentTime() {
        try {
            XMLGregorianCalendar xMLGregorianCalendar = vimPort.currentTime(SVC_INST_REF);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd 'T' HH:mm:ss.SSSZ");
            System.out.println("Server current time: " + simpleDateFormat.format(xMLGregorianCalendar.toGregorianCalendar().getTime()));
        }
        catch (SOAPFaultException sOAPFaultException) {
            sOAPFaultException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String loginUsingSAMLToken(Element element, String string, PrivateKey privateKey, X509Certificate x509Certificate) throws RuntimeFaultFaultMsg, InvalidLocaleFaultMsg, InvalidLoginFaultMsg {
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        vimService = new VimService();
        SVC_INST_REF.setType("ServiceInstance");
        SVC_INST_REF.setValue("ServiceInstance");
        vimPort = vimService.getVimPort();
        Map map = ((BindingProvider)vimPort).getRequestContext();
        map.put("javax.xml.ws.service.endpoint.address", string);
        map.put("javax.xml.ws.session.maintain", false);
        serviceContent = vimPort.retrieveServiceContent(SVC_INST_REF);
        if (Utils.isHoKToken(element)) {
            return LoginByTokenSample.getSessionCookieUsingHokToken(element, string, privateKey, x509Certificate);
        }
        return LoginByTokenSample.getSessionCookieUsingBearerToken(element, string);
    }

    public static void logout() throws RuntimeFaultFaultMsg {
        if (isConnected) {
            vimPort.logout(serviceContent.getSessionManager());
        }
        System.out.println("Logged out....");
        isConnected = false;
    }

    public static void main(String[] stringArray) throws DatatypeConfigurationException, RuntimeFaultFaultMsg, InvalidLocaleFaultMsg, InvalidLoginFaultMsg {
        if (stringArray.length < 4) {
            LoginByTokenSample.printUsage();
            return;
        }
        Utils.trustAllHttpsCertificates();
        System.out.println("Acquiring a bearer token using the AcquireBearerTokenByUserCredentialSample sample");
        Element element = AcquireBearerTokenByUserCredentialSample.getToken(stringArray);
        Utils.printToken(element);
        System.out.println("Bearer Token received....");
        System.out.println("Connecting to the vCenter " + stringArray[3] + "....");
        System.out.println("Invoking the loginUsingSAMLToken method");
        LoginByTokenSample.loginUsingSAMLToken(element, stringArray[3], null, null);
        System.out.println("Now getting the current time on the server....");
        LoginByTokenSample.getCurrentTime();
        LoginByTokenSample.logout();
        System.out.println("Acquiring a Holder-Of-Key token using the AcquireHoKTokenByUserCredentialSample sample....");
        SecurityUtil securityUtil = SecurityUtil.generateKeyCertPair();
        element = AcquireHoKTokenByUserCredentialSample.getToken(stringArray, securityUtil.getPrivateKey(), securityUtil.getUserCert());
        Utils.printToken(element);
        System.out.println("HoK Token received....");
        System.out.println("Connecting to the vCenter " + stringArray[3] + "....");
        LoginByTokenSample.loginUsingSAMLToken(element, stringArray[3], securityUtil.getPrivateKey(), securityUtil.getUserCert());
        System.out.println("Now getting the current time on the server....");
        LoginByTokenSample.getCurrentTime();
        LoginByTokenSample.logout();
    }

    private static void printUsage() {
        System.out.println("run.bat com.vmware.vsphere.samples.LoginByTokenSample [sso url] [username] [password] [vCenter url]");
    }

    private static String getSessionCookieUsingBearerToken(Element element, String string) throws InvalidLocaleFaultMsg, InvalidLoginFaultMsg, RuntimeFaultFaultMsg {
        HeaderCookieExtractionHandler headerCookieExtractionHandler = new HeaderCookieExtractionHandler();
        Object object = new HeaderHandlerResolver();
        ((HeaderHandlerResolver)object).addHandler(new TimeStampHandler());
        ((HeaderHandlerResolver)object).addHandler(new SamlTokenHandler(element));
        ((HeaderHandlerResolver)object).addHandler(headerCookieExtractionHandler);
        vimService.setHandlerResolver((HandlerResolver)object);
        vimPort = vimService.getVimPort();
        object = ((BindingProvider)vimPort).getRequestContext();
        object.put("javax.xml.ws.service.endpoint.address", string);
        object.put("javax.xml.ws.session.maintain", true);
        vimPort.loginByToken(serviceContent.getSessionManager(), null);
        String string2 = headerCookieExtractionHandler.getCookie();
        isConnected = true;
        LoginByTokenSample.clearHandlerResolver(string, string2);
        return string2;
    }

    private static String getSessionCookieUsingHokToken(Element element, String string, PrivateKey privateKey, X509Certificate x509Certificate) throws InvalidLocaleFaultMsg, InvalidLoginFaultMsg, RuntimeFaultFaultMsg {
        HeaderCookieExtractionHandler headerCookieExtractionHandler = new HeaderCookieExtractionHandler();
        Object object = new HeaderHandlerResolver();
        ((HeaderHandlerResolver)object).addHandler(new TimeStampHandler());
        ((HeaderHandlerResolver)object).addHandler(new SamlTokenHandler(element));
        ((HeaderHandlerResolver)object).addHandler(headerCookieExtractionHandler);
        ((HeaderHandlerResolver)object).addHandler(new WsSecuritySignatureAssertionHandler(privateKey, x509Certificate, Utils.getNodeProperty(element, "ID")));
        vimService.setHandlerResolver((HandlerResolver)object);
        vimPort = vimService.getVimPort();
        object = ((BindingProvider)vimPort).getRequestContext();
        object.put("javax.xml.ws.service.endpoint.address", string);
        object.put("javax.xml.ws.session.maintain", true);
        vimPort.loginByToken(serviceContent.getSessionManager(), null);
        String string2 = headerCookieExtractionHandler.getCookie();
        isConnected = true;
        LoginByTokenSample.clearHandlerResolver(string, string2);
        return string2;
    }

    static {
        SVC_INST_REF = new ManagedObjectReference();
        vimService = new VimService();
        defaultHandler = vimService.getHandlerResolver();
    }
}

