/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.client.soaphandlers;

import com.vmware.sso.client.soaphandlers.SSOHeaderHandler;
import com.vmware.sso.client.utils.Utils;
import com.vmware.sso.client.wssecurity.WsSecuritySignatureCertificate;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class WsSecurityUserCertificateSignatureHandler
extends SSOHeaderHandler {
    private final PrivateKey _privateKey;
    private final X509Certificate _userCert;

    public WsSecurityUserCertificateSignatureHandler(PrivateKey privateKey, X509Certificate x509Certificate) {
        this._privateKey = privateKey;
        this._userCert = x509Certificate;
    }

    public boolean handleMessage(SOAPMessageContext sOAPMessageContext) {
        if (Utils.isOutgoingMessage(sOAPMessageContext)) {
            WsSecuritySignatureCertificate wsSecuritySignatureCertificate = new WsSecuritySignatureCertificate(this._privateKey, this._userCert);
            try {
                wsSecuritySignatureCertificate.sign(sOAPMessageContext.getMessage());
            }
            catch (SignatureException signatureException) {
                System.out.println("Could not sign the SOAPMessage - SignatureException");
                signatureException.printStackTrace();
                throw new RuntimeException(signatureException);
            }
            catch (SOAPException sOAPException) {
                System.out.println("Could not sign the SOAPMessage - SOAPException");
                sOAPException.printStackTrace();
                throw new RuntimeException(sOAPException);
            }
        }
        return true;
    }
}

