/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.PreCompInfo;
import org.bouncycastle.math.ec.WNafPreCompInfo;

public abstract class WNafUtil {
    private static int[] DEFAULT_WINDOW_SIZE_CUTOFFS = new int[]{13, 41, 121, 337, 897, 2305};

    public static int[] generateCompactNaf(BigInteger bigInteger) {
        if (bigInteger.bitLength() >>> 16 != 0) {
            throw new IllegalArgumentException("'k' must have bitlength < 2^16");
        }
        BigInteger bigInteger2 = bigInteger.shiftLeft(1).add(bigInteger);
        int n = bigInteger2.bitLength() - 1;
        int[] nArray = new int[n + 1 >> 1];
        int n2 = 0;
        int n3 = 0;
        for (int i = 1; i <= n; ++i) {
            boolean bl;
            boolean bl2 = bigInteger2.testBit(i);
            if (bl2 == (bl = bigInteger.testBit(i))) {
                ++n3;
                continue;
            }
            int n4 = bl ? -1 : 1;
            nArray[n2++] = n4 << 16 | n3;
            n3 = 0;
        }
        if (nArray.length > n2) {
            nArray = WNafUtil.trim(nArray, n2);
        }
        return nArray;
    }

    public static int[] generateCompactWindowNaf(int n, BigInteger bigInteger) {
        if (n == 2) {
            return WNafUtil.generateCompactNaf(bigInteger);
        }
        if (n < 2 || n > 16) {
            throw new IllegalArgumentException("'width' must be in the range [2, 16]");
        }
        if (bigInteger.bitLength() >>> 16 != 0) {
            throw new IllegalArgumentException("'k' must have bitlength < 2^16");
        }
        int[] nArray = new int[bigInteger.bitLength() / n + 1];
        int n2 = 1 << n;
        int n3 = n2 - 1;
        int n4 = n2 >>> 1;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        while (n6 <= bigInteger.bitLength()) {
            if (bigInteger.testBit(n6) == bl) {
                ++n6;
                continue;
            }
            bigInteger = bigInteger.shiftRight(n6);
            int n7 = bigInteger.intValue() & n3;
            if (bl) {
                ++n7;
            }
            boolean bl2 = bl = (n7 & n4) != 0;
            if (bl) {
                n7 -= n2;
            }
            int n8 = n5 > 0 ? n6 - 1 : n6;
            nArray[n5++] = n7 << 16 | n8;
            n6 = n;
        }
        if (nArray.length > n5) {
            nArray = WNafUtil.trim(nArray, n5);
        }
        return nArray;
    }

    public static byte[] generateJSF(BigInteger bigInteger, BigInteger bigInteger2) {
        int n = Math.max(bigInteger.bitLength(), bigInteger2.bitLength()) + 1;
        byte[] byArray = new byte[n];
        BigInteger bigInteger3 = bigInteger;
        BigInteger bigInteger4 = bigInteger2;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (bigInteger3.signum() > 0 || bigInteger4.signum() > 0 || n3 > 0 || n4 > 0) {
            int n5;
            int n6 = bigInteger3.intValue() + n3 & 7;
            int n7 = bigInteger4.intValue() + n4 & 7;
            int n8 = n6 & 1;
            if (n8 != 0 && n6 + (n8 -= n6 & 2) == 4 && (n7 & 3) == 2) {
                n8 = -n8;
            }
            if ((n5 = n7 & 1) != 0 && n7 + (n5 -= n7 & 2) == 4 && (n6 & 3) == 2) {
                n5 = -n5;
            }
            if (n3 << 1 == 1 + n8) {
                n3 = 1 - n3;
            }
            if (n4 << 1 == 1 + n5) {
                n4 = 1 - n4;
            }
            bigInteger3 = bigInteger3.shiftRight(1);
            bigInteger4 = bigInteger4.shiftRight(1);
            byArray[n2++] = (byte)(n8 << 4 | n5 & 0xF);
        }
        if (byArray.length > n2) {
            byArray = WNafUtil.trim(byArray, n2);
        }
        return byArray;
    }

    public static byte[] generateNaf(BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger.shiftLeft(1).add(bigInteger);
        int n = bigInteger2.bitLength() - 1;
        byte[] byArray = new byte[n];
        for (int i = 1; i <= n; ++i) {
            boolean bl;
            boolean bl2 = bigInteger2.testBit(i);
            byArray[i - 1] = (byte)(bl2 == (bl = bigInteger.testBit(i)) ? 0 : (bl ? -1 : 1));
        }
        return byArray;
    }

    public static byte[] generateWindowNaf(int n, BigInteger bigInteger) {
        if (n == 2) {
            return WNafUtil.generateNaf(bigInteger);
        }
        if (n < 2 || n > 8) {
            throw new IllegalArgumentException("'width' must be in the range [2, 8]");
        }
        byte[] byArray = new byte[bigInteger.bitLength() + 1];
        int n2 = 1 << n;
        int n3 = n2 - 1;
        int n4 = n2 >>> 1;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        while (n6 <= bigInteger.bitLength()) {
            if (bigInteger.testBit(n6) == bl) {
                ++n6;
                continue;
            }
            bigInteger = bigInteger.shiftRight(n6);
            int n7 = bigInteger.intValue() & n3;
            if (bl) {
                ++n7;
            }
            boolean bl2 = bl = (n7 & n4) != 0;
            if (bl) {
                n7 -= n2;
            }
            n5 += n5 > 0 ? n6 - 1 : n6;
            byArray[n5++] = (byte)n7;
            n6 = n;
        }
        if (byArray.length > n5) {
            byArray = WNafUtil.trim(byArray, n5);
        }
        return byArray;
    }

    public static WNafPreCompInfo getWNafPreCompInfo(PreCompInfo preCompInfo) {
        if (preCompInfo != null && preCompInfo instanceof WNafPreCompInfo) {
            return (WNafPreCompInfo)preCompInfo;
        }
        return new WNafPreCompInfo();
    }

    public static int getWindowSize(int n) {
        return WNafUtil.getWindowSize(n, DEFAULT_WINDOW_SIZE_CUTOFFS);
    }

    public static int getWindowSize(int n, int[] nArray) {
        int n2;
        for (n2 = 0; n2 < nArray.length && n >= nArray[n2]; ++n2) {
        }
        return n2 + 2;
    }

    public static WNafPreCompInfo precompute(ECPoint eCPoint, int n, boolean bl) {
        int n2;
        ECPoint[] eCPointArray;
        int n3;
        int n4;
        ECCurve eCCurve = eCPoint.getCurve();
        WNafPreCompInfo wNafPreCompInfo = WNafUtil.getWNafPreCompInfo(eCCurve.getPreCompInfo(eCPoint));
        ECPoint[] eCPointArray2 = wNafPreCompInfo.getPreComp();
        if (eCPointArray2 == null) {
            eCPointArray2 = new ECPoint[]{eCPoint};
        }
        if ((n4 = eCPointArray2.length) < (n3 = 1 << Math.max(0, n - 2))) {
            eCPointArray = wNafPreCompInfo.getTwiceP();
            if (eCPointArray == null) {
                eCPointArray = eCPointArray2[0].twice().normalize();
                wNafPreCompInfo.setTwiceP((ECPoint)eCPointArray);
            }
            eCPointArray2 = WNafUtil.resizeTable(eCPointArray2, n3);
            for (n2 = n4; n2 < n3; ++n2) {
                eCPointArray2[n2] = eCPointArray.add(eCPointArray2[n2 - 1]);
            }
            eCCurve.normalizeAll(eCPointArray2);
        }
        wNafPreCompInfo.setPreComp(eCPointArray2);
        if (bl) {
            eCPointArray = wNafPreCompInfo.getPreCompNeg();
            if (eCPointArray == null) {
                n2 = 0;
                eCPointArray = new ECPoint[n3];
            } else {
                n2 = eCPointArray.length;
                if (n2 < n3) {
                    eCPointArray = WNafUtil.resizeTable(eCPointArray, n3);
                }
            }
            while (n2 < n3) {
                eCPointArray[n2] = eCPointArray2[n2].negate();
                ++n2;
            }
            wNafPreCompInfo.setPreCompNeg(eCPointArray);
        }
        eCCurve.setPreCompInfo(eCPoint, wNafPreCompInfo);
        return wNafPreCompInfo;
    }

    private static byte[] trim(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private static int[] trim(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        return nArray2;
    }

    private static ECPoint[] resizeTable(ECPoint[] eCPointArray, int n) {
        ECPoint[] eCPointArray2 = new ECPoint[n];
        System.arraycopy(eCPointArray, 0, eCPointArray2, 0, eCPointArray.length);
        return eCPointArray2;
    }
}

