﻿/*

 ********************************************************

 * Copyright (c) VMware, Inc.2010, 2016. All Rights Reserved.

 ********************************************************

 *

 * DISCLAIMER. THIS PROGRAM IS PROVIDED TO YOU "AS IS" WITHOUT

 * WARRANTIES OR CONDITIONS OF ANY KIND, WHETHER ORAL OR WRITTEN,

 * EXPRESS OR IMPLIED. THE AUTHOR SPECIFICALLY DISCLAIMS ANY IMPLIED

 * WARRANTIES OR CONDITIONS OF MERCHANTABILITY, SATISFACTORY QUALITY,

 * NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.

 */



namespace AcquireHoKTokenByUserCredentialSample

{

    using System;

    using System.Net;

    using System.Security.Cryptography.X509Certificates;

    using System.ServiceModel;

    using VMware.Binding.WsTrust;

    using vmware.sso;



    public class AcquireHoKTokenByUserCredential

    {

        # region Private function definition



        /// <summary>

        ///  This method is used to print message if there is insufficient parameter

        /// </summary>

        private static void PrintUsage()

        {

            Console.WriteLine("AcquireHoKTokenByUserCredentialSample [sso url] [username] [password]");

        }



        # endregion



        # region public function definition



        /// <summary>

        ///  This method is used to get Token

        /// </summary>

        /// <param name="args">string Array [sso url] [username] [password]</param>

        public static RequestSecurityTokenResponseType GetToken(String[] args)

        {

            var ssoUrl = args[0];

            var ssoUserName = args[1];

            var ssoPassword = args[2];



            try

            {

                ServicePointManager.SecurityProtocol |= SecurityProtocolType.Tls12;

                SamlTokenHelper.SetupServerCertificateValidation();

                X509Certificate2 signingCertificate = SamlTokenHelper.GetCertificate();

                var service = SamlTokenHelper.GetSTSService(ssoUrl, ssoUserName, ssoPassword, signingCertificate);

                var response = service.Issue(SamlTokenHelper.GetHokRequestSecurityTokenType());

                return response.RequestSecurityTokenResponse;

            }

            catch (Exception ex)

            {

                Console.WriteLine(ex.ToString());

                throw ex;

            }

        }



        /// <summary>

        /// Main function of the application

        /// </summary>

        /// <param name="args">string args [sso url] [username] [password]</param>

        public static void Main(string[] args)

        {

            if (args.Length < 3)

            {

                PrintUsage();

            }

            else

            {

                SamlTokenHelper.PrintToken(GetToken(args).RequestedSecurityToken);

            }



            Console.WriteLine("Press Any Key To Exit.");

            Console.ReadLine();

        }



        # endregion

    }

}