# Optimizing VimService.cs by stripping serializer hint attributes.



param(

   [ValidateScript({Test-Path $_ })]

	[string] $SourceFileName,



   [ValidateScript({Test-Path $_ -IsValid})]

   [string] $DestinationFileName

)



$streamReader = New-Object System.IO.StreamReader($SourceFileName);

$streamWriter = New-Object System.IO.StreamWriter($DestinationFileName);



try {

   $line = $streamReader.ReadLine();

   while ($line -ne $null) {



		# Searched attributes

		$xmlIncludeAttribute = "[System.Xml.Serialization.XmlIncludeAttribute("

		$serviceKnownTypeAttribute = "[System.ServiceModel.ServiceKnownTypeAttribute("

		$serviceContractAttribute = "[System.ServiceModel.ServiceContractAttribute("



		$lineTrimmed = $line.TrimStart();



		if ($lineTrimmed.StartsWith($xmlIncludeAttribute) -or `

			 $lineTrimmed.StartsWith($serviceKnownTypeAttribute)){

			# Comment out the attribute

			$line = "//$lineTrimmed"



		} elseif ($lineTrimmed.StartsWith($serviceContractAttribute)){

		    # Insert XmlSerializerAssemblyAttribute

			$xmlSerializerAttribute = "    [System.Xml.Serialization.XmlSerializerAssemblyAttribute]"

			$line = $xmlSerializerAttribute + [Environment]::NewLine + $line

		}



		$streamWriter.WriteLine($line);



		$line = $streamReader.ReadLine();

   }

} finally {

   if ($streamReader){

      $streamReader.Close();

   }

   if ($streamWriter){

	   $streamWriter.Close();

   }

}