/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.hyperic.hq.plugin.system.UnixLogTrackPlugin;
import org.hyperic.hq.plugin.system.WindowsLogTrackPlugin;
import org.hyperic.hq.product.PlatformDetector;
import org.hyperic.hq.product.PlatformResource;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.NetInfo;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.vmware.VMwareGuestInfo;

public class SigarPlatformDetector
extends PlatformDetector {
    private static final String PROP_PLATFORM_IP_IGNORE = "platform.ip.ignore";
    private static final String PROP_PLATFORM_IP_DISCOVER = "platform.ip.discover";
    private static final String VM_KIND_PROP_NAME = "vm_kind";
    private static final String VM_KIND_VMWARE = "VMware";
    private static final String VM_KIND_OTHER = "other";
    private String fqdn;
    private String ip;
    private boolean ipDiscover;
    private final Map ipIgnore = new HashMap();
    private boolean hasControlActions;
    private String macAddress = null;

    public SigarPlatformDetector() {
    }

    public SigarPlatformDetector(boolean hasPlatformControlActions) {
        this.hasControlActions = hasPlatformControlActions;
    }

    public void init(PluginManager manager) throws PluginException {
        String filter;
        super.init(manager);
        Properties props = manager.getProperties();
        this.fqdn = props.getProperty("platform.fqdn");
        this.ip = props.getProperty("platform.ip");
        this.macAddress = props.getProperty("platform.macaddr");
        this.ipDiscover = !"false".equals(props.getProperty(PROP_PLATFORM_IP_DISCOVER));
        String prop = "platform.networkConnected";
        String networkConnected = props.getProperty("platform.networkConnected");
        if ("false".equals(networkConnected)) {
            this.ipDiscover = false;
            this.getLog().warn((Object)"platform.networkConnected is deprecated, use platform.ip.discover=false instead");
        }
        if ((filter = props.getProperty(PROP_PLATFORM_IP_IGNORE)) != null) {
            StringTokenizer tok = new StringTokenizer(filter, ",");
            while (tok.hasMoreTokens()) {
                this.ipIgnore.put(tok.nextToken(), Boolean.TRUE);
            }
        }
    }

    private void setValue(ConfigResponse cprops, String key, String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        cprops.setValue(key, value);
    }

    private void getPlatformVmKind(ConfigResponse cprops, Sigar sigar) {
        String vmtoolsd = VMwareGuestInfo.findVMwareToolsCommand((Sigar)sigar);
        String vmKindValue = StringUtils.isNotBlank((String)vmtoolsd) ? VM_KIND_VMWARE : VM_KIND_OTHER;
        cprops.setValue(VM_KIND_PROP_NAME, vmKindValue);
    }

    public PlatformResource getPlatformResource(ConfigResponse config) throws PluginException {
        PlatformResource platform = new PlatformResource();
        if (this.hasControlActions) {
            platform.setControlConfig();
        }
        ConfigResponse cprops = new ConfigResponse();
        platform.setPlatformTypeName(OperatingSystem.getInstance().getName());
        Sigar sigar = new Sigar();
        HashMap<String, Boolean> ips = new HashMap<String, Boolean>();
        platform.setDescription(OperatingSystem.getInstance().getDescription());
        String fqdn = this.fqdn;
        String ip = null;
        ips.putAll(this.ipIgnore);
        try {
            String msg;
            if (fqdn == null) {
                fqdn = sigar.getFQDN();
            }
            platform.setFqdn(fqdn);
            platform.setName(SigarPlatformDetector.getPlatformDisplayName());
            String[] interfaces = sigar.getNetInterfaceList();
            if (this.ip != null) {
                this.getLog().info((Object)("Adding dummy ip address=" + this.ip));
                platform.addInterface(this.ip, "255.255.255.0", "00:00:00:00:00:00");
            }
            for (String name : interfaces) {
                String mac;
                String address;
                NetInterfaceConfig ifconfig;
                try {
                    ifconfig = sigar.getNetInterfaceConfig(name);
                }
                catch (SigarException e) {
                    this.getLog().debug((Object)("getNetInterfaceConfig(" + name + "): " + e.getMessage()), (Throwable)e);
                    continue;
                }
                long flags = ifconfig.getFlags();
                if ((flags & 1L) <= 0L || (flags & 0x10L) > 0L || (address = ifconfig.getAddress()).equals("0.0.0.0")) continue;
                String string = mac = this.macAddress == null ? ifconfig.getHwaddr() : this.macAddress;
                if ((flags & 8L) > 0L) {
                    if (!address.equals("127.0.0.1")) continue;
                    mac = "00:00:00:00:00:00";
                } else if (ip == null) {
                    ip = address;
                }
                if (SigarPlatformDetector.isWin32()) {
                    String MS_LOOPBACK = "Microsoft Loopback Adapter";
                    if ("Microsoft Loopback Adapter".equals(ifconfig.getDescription())) continue;
                }
                if (!this.ipDiscover && (flags & 8L) <= 0L) {
                    this.getLog().info((Object)("platform.ip.discover=false, skipping interface=" + name + ", ip=" + address));
                    continue;
                }
                if (ips.get(address) != null) continue;
                ips.put(address, Boolean.TRUE);
                this.getLog().info((Object)("adding interface name=" + ifconfig.getName() + ", address=" + address + ", netmask=" + ifconfig.getNetmask() + ", mac=" + mac));
                platform.addInterface(address, ifconfig.getNetmask(), mac);
            }
            try {
                Mem mem = sigar.getMem();
                cprops.setValue("ram", mem.getRam() + " MB");
            }
            catch (SigarException e) {
                String msg2 = "Error getting memory info: " + e.getMessage();
                this.getLog().warn((Object)msg2);
                this.getLog().debug((Object)msg2, (Throwable)e);
            }
            try {
                CpuInfo[] infos = sigar.getCpuInfoList();
                CpuInfo info = infos[0];
                int numSockets = info.getTotalSockets();
                int numCores = info.getCoresPerSocket();
                int numTotal = info.getTotalCores();
                platform.setCpuCount(new Integer(numSockets));
                String cpuSpeed = info.getMhz() + " MHz";
                if (numTotal > 1) {
                    cpuSpeed = numTotal + " @ " + cpuSpeed;
                    if (numCores != 1) {
                        cpuSpeed = cpuSpeed + " (" + numSockets + "x" + numCores + ")";
                    }
                }
                cprops.setValue("cpuSpeed", cpuSpeed);
            }
            catch (SigarException e) {
                msg = "Error getting cpu info: " + e.getMessage();
                this.getLog().warn((Object)msg);
                this.getLog().debug((Object)msg, (Throwable)e);
                platform.setCpuCount(new Integer(1));
            }
            this.setValue(cprops, "ip", ip);
            try {
                NetInfo info = sigar.getNetInfo();
                this.setValue(cprops, "primaryDNS", info.getPrimaryDns());
                this.setValue(cprops, "secondaryDNS", info.getSecondaryDns());
                this.setValue(cprops, "defaultGateway", info.getDefaultGateway());
            }
            catch (SigarException e) {
                msg = "Error getting net info: " + e.getMessage();
                this.getLog().warn((Object)msg);
                this.getLog().debug((Object)msg, (Throwable)e);
            }
            this.getPlatformVmKind(cprops, sigar);
        }
        catch (SigarException se) {
            String msg = "Error retrieving system information: " + se.getMessage();
            throw new PluginException(msg, (Throwable)se);
        }
        finally {
            sigar.close();
        }
        cprops.setValue("arch", OperatingSystem.getInstance().getArch());
        cprops.setValue("version", OperatingSystem.getInstance().getVersion());
        cprops.setValue("vendor", OperatingSystem.getInstance().getVendor());
        cprops.setValue("vendorVersion", OperatingSystem.getInstance().getVendorVersion());
        platform.setCustomProperties(cprops);
        ConfigResponse mconfig = new ConfigResponse();
        if (SigarPlatformDetector.isWin32()) {
            WindowsLogTrackPlugin.setDefaultConfig(mconfig);
        } else {
            UnixLogTrackPlugin.setDefaultConfig(mconfig);
        }
        platform.setMeasurementConfig(mconfig, 4);
        return platform;
    }
}

