/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.filter;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.types.FilterSet;

public class TokenReplacer {
    private static final String DEFAULT_TOKEN_BEGIN = "${";
    private static final String DEFAULT_TOKEN_END = "}";
    private FilterSet filter;
    private Map filters = new HashMap();

    public TokenReplacer() {
        this.clear();
    }

    public TokenReplacer(Map filters) {
        this();
        this.addFilters(filters);
    }

    public void clear() {
        this.filters.clear();
        this.filter = new FilterSet();
        this.filter.setBeginToken(DEFAULT_TOKEN_BEGIN);
        this.filter.setEndToken(DEFAULT_TOKEN_END);
    }

    public void setBeginToken(String token) {
        this.filter.setBeginToken(token);
    }

    public void setEndToken(String token) {
        this.filter.setEndToken(token);
    }

    public void addFilter(String name, String value) {
        this.filters.put(name, value);
        this.filter.addFilter(name, value);
    }

    public void addFilters(Map filters) {
        this.filters.putAll(filters);
        Set keys = filters.keySet();
        for (String key : keys) {
            this.filter.addFilter(key, filters.get(key).toString());
        }
    }

    public Map getFilters() {
        return this.filters;
    }

    public String getFilter(String name) {
        return (String)this.filters.get(name);
    }

    public String replaceTokens(String input) {
        return this.filter.replaceTokens(input);
    }

    public Properties replaceProperties(Properties source) {
        return this.replaceProperties(source, source);
    }

    public Properties replaceProperties(Properties source, Map filters) {
        this.addFilters(filters);
        Properties props = new Properties();
        Enumeration<?> en = source.propertyNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String value = source.getProperty(name);
            props.setProperty(this.replaceTokens(name), this.replaceTokens(value));
        }
        return props;
    }

    public static String replace(String input, Map filters) {
        TokenReplacer replacer = new TokenReplacer(filters);
        return replacer.replaceTokens(input);
    }
}

