/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class BERInputStream
extends InputStream {
    private ByteBuffer buffer;

    public BERInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
        buffer.mark();
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(ByteBuffer buf) {
        this.buffer = buf;
    }

    public int read() throws IOException {
        try {
            return this.buffer.get() & 0xFF;
        }
        catch (BufferUnderflowException ex) {
            throw new IOException("Unexpected end of input stream at position " + this.getPosition());
        }
    }

    public int available() throws IOException {
        return this.buffer.remaining();
    }

    public void close() throws IOException {
    }

    public synchronized void mark(int readlimit) {
        this.buffer.mark();
    }

    public boolean markSupported() {
        return true;
    }

    public int read(byte[] b) throws IOException {
        if (this.buffer.remaining() <= 0) {
            return -1;
        }
        int read = Math.min(this.buffer.remaining(), b.length);
        this.buffer.get(b, 0, read);
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buffer.remaining() <= 0) {
            return -1;
        }
        int read = Math.min(this.buffer.remaining(), b.length);
        this.buffer.get(b, off, len);
        return read;
    }

    public synchronized void reset() throws IOException {
        this.buffer.reset();
    }

    public long skip(long n) throws IOException {
        long skipped = Math.min((long)this.buffer.remaining(), n);
        this.buffer.position((int)((long)this.buffer.position() + skipped));
        return skipped;
    }

    public long getPosition() {
        return this.buffer.position();
    }

    public boolean isMarked() {
        return true;
    }

    public int getAvailableBytes() {
        return this.buffer.limit();
    }
}

