/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.hyperic.util.StringUtil;
import org.hyperic.util.units.UnitNumber;
import org.hyperic.util.units.UnitsFormat;

public class TimeUtil {
    public static final String DATE_FORMAT = "MM-dd-yy-HH-mm-ss";
    public static final String DISPLAY_DATE_FORMAT = "MM/dd/yyyy hh:mm:ss aaa";
    public static final long MILLIS_IN_MINUTE = 60000L;
    public static final long MILLIS_IN_HOUR = 3600000L;
    public static final long MILLIS_IN_DAY = 86400000L;
    public static final long MILLIS_IN_WEEK = 604800000L;

    private TimeUtil() {
    }

    public static String toString(long time) {
        UnitNumber number = new UnitNumber(time, 5, 13);
        return UnitsFormat.format(number).toString();
    }

    public static long parseComplexTime(String str, long baseTime, boolean futureTime) throws ParseException {
        String dur;
        int offset;
        String[] exp = StringUtil.explode(str, " ").toArray(new String[0]);
        if (exp.length < 1) {
            throw new ParseException("No time found to parse", 0);
        }
        Calendar resCal = Calendar.getInstance();
        resCal.setTime(new Date(baseTime));
        int useIdx = 0;
        if (exp[useIdx].equalsIgnoreCase("now")) {
            ++useIdx;
        } else if (exp[useIdx].equalsIgnoreCase("yesterday")) {
            resCal.add(6, -1);
            ++useIdx;
        } else if (exp[useIdx].equalsIgnoreCase("tomorrow")) {
            resCal.add(6, 1);
            ++useIdx;
        } else {
            int weekday = TimeUtil.getWeekDay(exp[useIdx]);
            if (weekday != -1) {
                int curDay = resCal.get(7);
                if (futureTime) {
                    if (weekday < curDay) {
                        weekday += 7;
                    }
                } else if (weekday > curDay) {
                    weekday -= 7;
                }
                resCal.add(7, weekday - curDay);
                ++useIdx;
            } else {
                int month = TimeUtil.getMonth(exp[useIdx]);
                if (month != -1) {
                    int curMonth = resCal.get(2);
                    if (futureTime) {
                        if (month < curMonth) {
                            month += 7;
                        }
                    } else if (month > curMonth) {
                        month -= 7;
                    }
                    resCal.add(2, month - curMonth);
                    ++useIdx;
                } else {
                    Date newDate = null;
                    Date newTime = null;
                    newDate = TimeUtil.parseSimpleDate(exp[useIdx]);
                    if (newDate == null) {
                        newTime = TimeUtil.parseSimpleTime(exp[useIdx]);
                        if (newTime != null) {
                            ++useIdx;
                        }
                    } else if (++useIdx != exp.length && (newTime = TimeUtil.parseSimpleTime(exp[useIdx])) != null) {
                        ++useIdx;
                    }
                    if (newDate == null && newTime == null) {
                        throw new ParseException("Invalid date/time specified", 0);
                    }
                    if (newDate != null) {
                        resCal.setTime(newDate);
                    }
                    if (newTime != null) {
                        Calendar tmpCal = Calendar.getInstance();
                        tmpCal.setTime(newTime);
                        resCal.set(13, 0);
                        long newMillis = tmpCal.get(11) * 60 * 60 * 1000 + tmpCal.get(12) * 60 * 1000;
                        long curTimeMillis = resCal.get(11) * 60 * 60 * 1000 + resCal.get(12) * 60 * 1000;
                        if (newDate == null) {
                            if (futureTime) {
                                if (curTimeMillis > newMillis) {
                                    newMillis += 86400000L;
                                }
                            } else if (curTimeMillis < newMillis) {
                                newMillis -= 86400000L;
                            }
                            resCal.add(13, (int)((newMillis - curTimeMillis) / 1000L));
                        } else {
                            resCal.add(13, (int)(newMillis / 1000L));
                        }
                    }
                }
            }
        }
        if (useIdx == exp.length) {
            return resCal.getTime().getTime();
        }
        if (useIdx != exp.length - 3 || !exp[useIdx].equals("+") && !exp[useIdx].equals("-")) {
            throw new ParseException("Invalid time offset specified, '" + exp[useIdx] + "'", 0);
        }
        try {
            offset = Integer.parseInt(exp[useIdx + 1]);
        }
        catch (NumberFormatException exc) {
            throw new ParseException("Error parsing offset value: " + exp[useIdx + 1] + " is not a number", 0);
        }
        if (exp[useIdx].equals("-")) {
            offset *= -1;
        }
        if ((dur = exp[useIdx + 2]).regionMatches(true, 0, "seconds", 0, dur.length())) {
            resCal.add(13, offset);
        } else if (dur.regionMatches(true, 0, "minutes", 0, dur.length())) {
            resCal.add(12, offset);
        } else if (dur.regionMatches(true, 0, "hours", 0, dur.length())) {
            resCal.add(10, offset);
        } else if (dur.regionMatches(true, 0, "days", 0, dur.length())) {
            resCal.add(6, offset);
        } else if (dur.regionMatches(true, 0, "weeks", 0, dur.length())) {
            resCal.add(3, offset);
        } else if (dur.regionMatches(true, 0, "months", 0, dur.length())) {
            resCal.add(2, offset);
        } else if (dur.regionMatches(true, 0, "years", 0, dur.length())) {
            resCal.add(1, offset);
        } else {
            throw new ParseException("Invalid offset duration '" + dur + "'", 0);
        }
        return resCal.getTime().getTime();
    }

    private static Date parseSimpleDate(String str) {
        DateFormat df = DateFormat.getDateInstance(3);
        df.setLenient(false);
        try {
            return df.parse(str);
        }
        catch (ParseException exc) {
            return null;
        }
    }

    private static Date parseSimpleTime(String str) {
        SimpleDateFormat tf = new SimpleDateFormat("hh:mma");
        SimpleDateFormat tf2 = new SimpleDateFormat("HH:mm");
        tf.setLenient(false);
        tf2.setLenient(false);
        try {
            return tf.parse(str);
        }
        catch (ParseException exc) {
            try {
                return tf2.parse(str);
            }
            catch (ParseException iexc) {
                return null;
            }
        }
    }

    private static int getWeekDay(String str) {
        if (str.length() < 3) {
            return -1;
        }
        if (str.regionMatches(true, 0, "sunday", 0, str.length())) {
            return 1;
        }
        if (str.regionMatches(true, 0, "monday", 0, str.length())) {
            return 2;
        }
        if (str.regionMatches(true, 0, "tuesday", 0, str.length())) {
            return 3;
        }
        if (str.regionMatches(true, 0, "wednesday", 0, str.length())) {
            return 4;
        }
        if (str.regionMatches(true, 0, "thursday", 0, str.length())) {
            return 5;
        }
        if (str.regionMatches(true, 0, "friday", 0, str.length())) {
            return 6;
        }
        if (str.regionMatches(true, 0, "saturday", 0, str.length())) {
            return 7;
        }
        return -1;
    }

    private static int getMonth(String str) {
        if (str.length() < 3) {
            return -1;
        }
        if (str.regionMatches(true, 0, "january", 0, str.length())) {
            return 0;
        }
        if (str.regionMatches(true, 0, "february", 0, str.length())) {
            return 1;
        }
        if (str.regionMatches(true, 0, "march", 0, str.length())) {
            return 2;
        }
        if (str.regionMatches(true, 0, "april", 0, str.length())) {
            return 3;
        }
        if (str.regionMatches(true, 0, "may", 0, str.length())) {
            return 4;
        }
        if (str.regionMatches(true, 0, "june", 0, str.length())) {
            return 5;
        }
        if (str.regionMatches(true, 0, "july", 0, str.length())) {
            return 6;
        }
        if (str.regionMatches(true, 0, "august", 0, str.length())) {
            return 7;
        }
        if (str.regionMatches(true, 0, "september", 0, str.length())) {
            return 8;
        }
        if (str.regionMatches(true, 0, "october", 0, str.length())) {
            return 9;
        }
        if (str.regionMatches(true, 0, "november", 0, str.length())) {
            return 10;
        }
        if (str.regionMatches(true, 0, "december", 0, str.length())) {
            return 11;
        }
        return -1;
    }

    public static long getInterval(long begin, long end, int points) {
        return (end - begin) / (long)points;
    }
}

