/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.autoinventory;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hyperic.hq.appdef.shared.AIIpValue;
import org.hyperic.hq.appdef.shared.AIPlatformValue;
import org.hyperic.hq.appdef.shared.AIServerExtValue;
import org.hyperic.hq.appdef.shared.AIServerValue;
import org.hyperic.hq.appdef.shared.AIServiceTypeValue;
import org.hyperic.hq.appdef.shared.AIServiceValue;
import org.hyperic.hq.common.SystemException;
import org.hyperic.hq.product.MeasurementInfo;
import org.hyperic.hq.product.MeasurementInfos;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.EncodingException;

public class AICompare {
    private AICompare() {
    }

    public static boolean compareAIPlatforms(AIPlatformValue p1, AIPlatformValue p2) {
        AIIpValue[] ips2;
        if (!(AICompare.compare(p1.getPlatformTypeName(), p2.getPlatformTypeName()) && AICompare.compare(p1.getFqdn(), p2.getFqdn()) && AICompare.compare(p1.getName(), p2.getName()) && AICompare.compare(p1.getLocation(), p2.getLocation()) && AICompare.compare(p1.getDescription(), p2.getDescription()) && AICompare.configsEqual(p1.getProductConfig(), p2.getProductConfig()) && AICompare.configsEqual(p1.getControlConfig(), p2.getControlConfig()) && AICompare.configsEqual(p1.getMeasurementConfig(), p2.getMeasurementConfig()) && AICompare.configsEqual(p1.getCustomProperties(), p2.getCustomProperties()))) {
            return false;
        }
        AIIpValue[] ips1 = p1.getAIIpValues();
        if (ips1.length != (ips2 = p2.getAIIpValues()).length) {
            return false;
        }
        for (int i = 0; i < ips1.length; ++i) {
            boolean foundMatchingIP = false;
            for (int j = 0; j < ips2.length; ++j) {
                if (!AICompare.compare(ips1[i].getAddress(), ips2[j].getAddress()) || !AICompare.compare(ips1[i].getMACAddress(), ips2[j].getMACAddress()) || !AICompare.compare(ips1[i].getNetmask(), ips2[j].getNetmask())) continue;
                foundMatchingIP = true;
                break;
            }
            if (foundMatchingIP) continue;
            return false;
        }
        AIServerValue[] sarray1 = p1.getAIServerValues();
        AIServerValue[] sarray2 = p2.getAIServerValues();
        return AICompare.compareAIServers(Arrays.asList(sarray1), Arrays.asList(sarray2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean compareAIServers(Collection servers1, Collection servers2) {
        if (servers1.size() != servers2.size()) {
            return false;
        }
        for (AIServerValue s1 : servers1) {
            boolean foundMatchingServer = false;
            for (AIServerValue s2 : servers2) {
                if (!AICompare.configsEqual(s1.getProductConfig(), s2.getProductConfig()) || !AICompare.configsEqual(s1.getControlConfig(), s2.getControlConfig()) || !AICompare.configsEqual(s1.getMeasurementConfig(), s2.getMeasurementConfig()) || !AICompare.configsEqual(s1.getResponseTimeConfig(), s2.getResponseTimeConfig()) || !AICompare.configsEqual(s1.getCustomProperties(), s2.getCustomProperties()) || !AICompare.compare(s1.getName(), s2.getName()) || !AICompare.compare(s1.getServerTypeName(), s2.getServerTypeName()) || !AICompare.compare(s1.getDescription(), s2.getDescription()) || !AICompare.compare(s1.getAutoinventoryIdentifier(), s2.getAutoinventoryIdentifier()) || !AICompare.compare(s1.getInstallPath(), s2.getInstallPath())) continue;
                if (s1 instanceof AIServerExtValue) {
                    AIServiceValue[] svc2;
                    if (!(s2 instanceof AIServerExtValue)) return false;
                    AIServerExtValue se1 = (AIServerExtValue)s1;
                    AIServerExtValue se2 = (AIServerExtValue)s2;
                    if (se1.getPlaceholder() != se2.getPlaceholder()) {
                        return false;
                    }
                    AIServiceValue[] svc1 = se1.getAIServiceValues();
                    if (!AICompare.compareAIServices(svc1, svc2 = se2.getAIServiceValues())) {
                        return false;
                    }
                    if (!AICompare.aIServiceTypesEqual(se1.getAiServiceTypes(), se2.getAiServiceTypes())) {
                        return false;
                    }
                } else if (s2 instanceof AIServerExtValue) {
                    return false;
                }
                foundMatchingServer = true;
                break;
            }
            if (foundMatchingServer) continue;
            return false;
        }
        return true;
    }

    public static boolean compareAIServices(AIServiceValue[] services1, AIServiceValue[] services2) {
        if (services1 == null) {
            return services2 == null;
        }
        if (services2 == null) {
            return false;
        }
        if (services1.length != services2.length) {
            return false;
        }
        for (int i = 0; i < services1.length; ++i) {
            boolean foundMatchingService = false;
            AIServiceValue s1 = services1[i];
            for (int j = 0; j < services2.length; ++j) {
                AIServiceValue s2 = services2[j];
                if (!AICompare.compare(s1.getServiceTypeName(), s2.getServiceTypeName()) || !AICompare.configsEqual(s1.getProductConfig(), s2.getProductConfig()) || !AICompare.configsEqual(s1.getControlConfig(), s2.getControlConfig()) || !AICompare.configsEqual(s1.getMeasurementConfig(), s2.getMeasurementConfig()) || !AICompare.configsEqual(s1.getResponseTimeConfig(), s2.getResponseTimeConfig()) || !AICompare.configsEqual(s1.getCustomProperties(), s2.getCustomProperties()) || !AICompare.compare(s1.getName(), s2.getName()) || !AICompare.compare(s1.getDescription(), s2.getDescription())) continue;
                foundMatchingService = true;
                break;
            }
            if (foundMatchingService) continue;
            return false;
        }
        return true;
    }

    public static boolean aIServiceTypesEqual(AIServiceTypeValue[] serviceTypes1, AIServiceTypeValue[] serviceTypes2) {
        if (serviceTypes1 == null) {
            return serviceTypes2 == null;
        }
        if (serviceTypes2 == null) {
            return false;
        }
        if (serviceTypes1.length != serviceTypes2.length) {
            return false;
        }
        for (int i = 0; i < serviceTypes1.length; ++i) {
            boolean foundMatchingServiceType = false;
            AIServiceTypeValue s1 = serviceTypes1[i];
            for (int j = 0; j < serviceTypes2.length; ++j) {
                AIServiceTypeValue s2 = serviceTypes2[j];
                if (!AICompare.aiServiceTypesEqual(s1, s2)) continue;
                foundMatchingServiceType = true;
                break;
            }
            if (foundMatchingServiceType) continue;
            return false;
        }
        return true;
    }

    public static boolean aiServiceTypesEqual(AIServiceTypeValue s1, AIServiceTypeValue s2) {
        return AICompare.compare(s1.getDescription(), s2.getDescription()) && AICompare.compare(s1.getName(), s2.getName()) && AICompare.compare(s1.getServiceName(), s2.getServiceName()) && AICompare.configsEqual(s1.getPluginClasses(), s2.getPluginClasses()) && AICompare.configsEqual(s1.getProperties(), s2.getProperties()) && AICompare.configSchemasEqual(s1.getCustomProperties(), s2.getCustomProperties()) && AICompare.compare(s1.getControlActions(), s2.getControlActions()) && AICompare.measurementInfosEqual(s1.getMeasurements(), s2.getMeasurements());
    }

    public static boolean measurementInfosEqual(byte[] m1, byte[] m2) {
        if (m1 == m2) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        if (m1.length == 0 && m2.length == 0) {
            return true;
        }
        try {
            MeasurementInfos mi1 = MeasurementInfos.decode(m1);
            MeasurementInfos mi2 = MeasurementInfos.decode(m2);
            if (!mi1.equals(mi2)) {
                return false;
            }
            Set measurementNames = mi1.getMeasurementNames();
            for (String measurementName : measurementNames) {
                boolean measurementsEqual = AICompare.compare(mi1.getMeasurement(measurementName), mi2.getMeasurement(measurementName));
                if (measurementsEqual) continue;
                return false;
            }
            return true;
        }
        catch (EncodingException e) {
            throw new SystemException(e.getMessage(), e);
        }
    }

    public static boolean configSchemasEqual(byte[] c1, byte[] c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        if (c1.length != c2.length) {
            return false;
        }
        if (c1.length == 0 && c2.length == 0) {
            return true;
        }
        try {
            ConfigSchema cs1 = ConfigSchema.decode((byte[])c1);
            ConfigSchema cs2 = ConfigSchema.decode((byte[])c2);
            boolean configNamesEqual = AICompare.compare(cs1.getOptionNames(), cs2.getOptionNames());
            if (!configNamesEqual) {
                return false;
            }
            String[] optionNames = cs1.getOptionNames();
            for (int i = 0; i < optionNames.length; ++i) {
                ConfigOption option1 = cs1.getOption(optionNames[i]);
                ConfigOption option2 = cs2.getOption(optionNames[i]);
                if (AICompare.compare(option1.getName(), option2.getName()) || AICompare.compare(option1.getDescription(), option2.getDescription())) continue;
                return false;
            }
            return true;
        }
        catch (EncodingException e) {
            throw new SystemException(e.getMessage());
        }
    }

    public static boolean configsEqual(byte[] c1, byte[] c2) {
        if (c1 == null != (c2 == null)) {
            return false;
        }
        if (c1 == c2 || Arrays.equals(c1, c2)) {
            return true;
        }
        if (c1.length != c2.length) {
            return false;
        }
        if (c1.length == 0 && c2.length == 0) {
            return true;
        }
        try {
            ConfigResponse cr1 = ConfigResponse.decode((byte[])c1);
            ConfigResponse cr2 = ConfigResponse.decode((byte[])c2);
            return cr1.equals((Object)cr2);
        }
        catch (EncodingException e) {
            throw new SystemException(e.getMessage(), e);
        }
    }

    public static ConfigDiff configsDiff(byte[] newConf, byte[] oldConf) throws EncodingException {
        ConfigDiff res = new ConfigDiff();
        if (oldConf == null != (newConf == null)) {
            res.setNewConf(ConfigResponse.decode((byte[])(oldConf != null ? oldConf : newConf)));
            return res;
        }
        if (oldConf == newConf || Arrays.equals(oldConf, newConf)) {
            return res;
        }
        if (oldConf.length == 0 && newConf.length == 0) {
            return res;
        }
        try {
            ConfigResponse cr1 = ConfigResponse.decode((byte[])oldConf);
            ConfigResponse cr2 = ConfigResponse.decode((byte[])newConf);
            Map m1 = cr1.getConfig();
            Map m2 = cr2.getConfig();
            for (String k1 : m1.keySet()) {
                String v1 = (String)m1.get(k1);
                String v2 = (String)m2.get(k1);
                if (v2 == null) {
                    res.getDeletedConf().setValue(k1, v1);
                    continue;
                }
                if (!(v1 == null && v2 != null || v1 != null && v2 == null) && v1.equals(v2)) continue;
                res.getChangedConf().setValue(k1, v2);
            }
            for (String k2 : m2.keySet()) {
                if (m1.containsKey(k2)) continue;
                res.getNewConf().setValue(k2, (String)m2.get(k2));
            }
            return res;
        }
        catch (EncodingException e) {
            throw new SystemException(e.getMessage(), e);
        }
    }

    private static boolean compare(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    private static boolean compare(MeasurementInfo m1, MeasurementInfo m2) {
        if (m1 == m2) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        return AICompare.compare(m1.getAlias(), m2.getAlias()) && AICompare.compare(m1.getCategory(), m2.getCategory()) && AICompare.compare(m1.getGroup(), m2.getGroup()) && AICompare.compare(m1.getName(), m2.getName()) && AICompare.compare(m1.getRate(), m2.getRate()) && AICompare.compare(m1.getTemplate(), m2.getTemplate()) && AICompare.compare(m1.getUnits(), m2.getUnits()) && m1.getCollectionType() == m2.getCollectionType() && m1.getInterval() == m2.getInterval() && m1.isDefaultOn() == m2.isDefaultOn() && m1.isIndicator() == m2.isIndicator();
    }

    private static boolean compare(String[] strArray1, String[] strArray2) {
        if (strArray1 == strArray2) {
            return true;
        }
        if (strArray1 == null || strArray2 == null) {
            return false;
        }
        HashSet<String> set1 = new HashSet<String>(Arrays.asList(strArray1));
        HashSet<String> set2 = new HashSet<String>(Arrays.asList(strArray2));
        return set1.equals(set2);
    }

    public static class ConfigDiff {
        protected ConfigResponse newConf = new ConfigResponse();
        protected ConfigResponse changedConf = new ConfigResponse();
        protected ConfigResponse deletedConf = new ConfigResponse();

        public ConfigResponse getNewConf() {
            return this.newConf;
        }

        public void setNewConf(ConfigResponse newConf) {
            this.newConf = newConf;
        }

        public ConfigResponse getChangedConf() {
            return this.changedConf;
        }

        public void setChangedConf(ConfigResponse changedConf) {
            this.changedConf = changedConf;
        }

        public ConfigResponse getDeletedConf() {
            return this.deletedConf;
        }

        public void setDeletedConf(ConfigResponse deletedConf) {
            this.deletedConf = deletedConf;
        }
    }
}

