/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.shared.lather;

import org.hyperic.hq.measurement.shared.MeasurementConfigEntity;
import org.hyperic.hq.measurement.shared.MeasurementConfigList;
import org.hyperic.lather.LatherKeyNotFoundException;
import org.hyperic.lather.LatherRemoteException;
import org.hyperic.lather.LatherValue;

public class MeasurementGetConfigs_result
extends LatherValue {
    private static final String PROP_PLUGINNAME = "pluginName";
    private static final String PROP_PLUGINTYPE = "pluginType";
    private static final String PROP_PLUGINCONFIG = "pluginConfig";
    private static final String PROP_NENTS = "nEnts";

    public void setConfigs(MeasurementConfigList configs) {
        MeasurementConfigEntity[] ents = configs.getEntities();
        for (int i = 0; i < ents.length; ++i) {
            this.addStringToList(PROP_PLUGINNAME, ents[i].getPluginName());
            this.addStringToList(PROP_PLUGINTYPE, ents[i].getPluginType());
            this.addByteAToList(PROP_PLUGINCONFIG, ents[i].getConfig());
        }
        this.setIntValue(PROP_NENTS, ents.length);
    }

    public MeasurementConfigList getConfigs() throws LatherRemoteException {
        int nEnts = this.getIntValue(PROP_NENTS);
        if (nEnts == 0) {
            MeasurementConfigList res = new MeasurementConfigList();
            res.setEntities(new MeasurementConfigEntity[0]);
            return res;
        }
        String[] pluginNames = this.getStringList(PROP_PLUGINNAME);
        String[] pluginTypes = this.getStringList(PROP_PLUGINTYPE);
        byte[][] configs = this.getByteAList(PROP_PLUGINCONFIG);
        MeasurementConfigEntity[] ents = new MeasurementConfigEntity[nEnts];
        if (nEnts != pluginNames.length || nEnts != pluginTypes.length || nEnts != configs.length) {
            throw new LatherRemoteException("Config size mismatch");
        }
        for (int i = 0; i < nEnts; ++i) {
            ents[i] = new MeasurementConfigEntity();
            ents[i].setPluginName(pluginNames[i]);
            ents[i].setPluginType(pluginTypes[i]);
            ents[i].setConfig(configs[i]);
        }
        MeasurementConfigList res = new MeasurementConfigList();
        res.setEntities(ents);
        return res;
    }

    public void validate() throws LatherRemoteException {
        try {
            this.getIntValue(PROP_NENTS);
        }
        catch (LatherKeyNotFoundException exc) {
            throw new LatherRemoteException("All values not set");
        }
    }
}

