/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security.ruleset;

import com.sun.deploy.security.ruleset.RuleAction;

public class DRSResult {
    private Type type;
    private Exception exception;
    private int index;
    private String message;
    private String version;
    private boolean isForced;

    public Type getType() {
        return this.type;
    }

    public Exception getException() {
        return this.exception;
    }

    public int getIndex() {
        return this.index;
    }

    public String getMessage() {
        return this.message;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean getIsForced() {
        return this.isForced;
    }

    public DRSResult() {
        this.type = Type.DEFAULT;
        this.index = -1;
    }

    public DRSResult(Exception exception) {
        this.type = Type.EXCEPTION;
        this.exception = exception;
        this.index = -1;
    }

    public DRSResult(RuleAction ruleAction, int n) {
        this.index = n;
        if (ruleAction.isBlock()) {
            this.type = Type.BLOCK;
            this.message = ruleAction.getBlockedMessage();
        } else if (ruleAction.isRun()) {
            this.type = Type.RUN;
            this.version = ruleAction.getVersionString();
            this.isForced = ruleAction.isVersionForced();
        } else {
            this.type = Type.DEFAULT;
        }
    }

    public String toString() {
        if (this.type == Type.EXCEPTION) {
            return "DRSResult type EXCEPTION: " + this.exception;
        }
        if (this.type == Type.BLOCK) {
            return "DRSResult type BLOCK from rule " + this.index;
        }
        if (this.type == Type.RUN) {
            return "DRSResult type RUN from rule " + this.index + (this.version == null ? "" : "version = " + this.version + " force = " + this.isForced);
        }
        return "DRSResult type DEFAULT " + (this.index >= 0 ? "from rule " + this.index : "not matching any rule");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        EXCEPTION,
        RUN,
        BLOCK,
        DEFAULT;

    }
}

