/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tanukisoftware.wrapper.WrapperManager;

public class WrapperProcessInputStream
extends InputStream {
    private long m_ptr;
    private boolean m_closed;
    private ByteArrayInputStream m_bais;

    private WrapperProcessInputStream() {
    }

    private native int nativeRead(boolean var1);

    private native void nativeClose();

    private native int nativeRead2(byte[] var1, int var2, int var3, boolean var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        WrapperProcessInputStream wrapperProcessInputStream = this;
        synchronized (wrapperProcessInputStream) {
            if (!this.m_closed) {
                this.nativeClose();
                this.m_closed = true;
            }
        }
    }

    public boolean markSupported() {
        return false;
    }

    public boolean ready() {
        return !this.m_closed || this.m_bais.available() > 0;
    }

    public int read() throws IOException {
        if (!this.m_closed) {
            return this.nativeRead(true);
        }
        if (this.m_bais != null) {
            return this.m_bais.read();
        }
        throw new IOException(WrapperManager.getRes().getString("Stream is closed."));
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        WrapperProcessInputStream wrapperProcessInputStream = this;
        synchronized (wrapperProcessInputStream) {
            int c;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (!this.ready()) {
                return -1;
            }
            if (!this.m_closed) {
                c = this.nativeRead2(b, off, len, false);
                if (c == -1) {
                    c = this.nativeRead2(b, off, len, true);
                }
            } else {
                c = this.m_bais.read(b, off, len);
            }
            return c == 0 ? -1 : c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAndCloseOpenFDs() {
        WrapperProcessInputStream wrapperProcessInputStream = this;
        synchronized (wrapperProcessInputStream) {
            if (this.m_closed) {
                return;
            }
            try {
                int msg;
                byte[] buffer = new byte[]{};
                int i = 0;
                while ((msg = this.nativeRead(false)) != -1) {
                    int newSize = buffer.length + 1;
                    byte[] temp = new byte[newSize];
                    System.arraycopy(buffer, 0, temp, 0, buffer.length);
                    buffer = temp;
                    buffer[i++] = (byte)msg;
                }
                this.m_bais = new ByteArrayInputStream(buffer);
                this.close();
            }
            catch (IOException ioe) {
                System.out.println(WrapperManager.getRes().getString("WrapperProcessStream encountered a ReadError: "));
                ioe.printStackTrace();
            }
        }
    }
}

