/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Packet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.ws.handler.MessageContext;

class MessageContextImpl
implements MessageContext {
    private final Set<String> handlerScopeProps;
    private final Packet packet;
    private final Map<String, Object> asMapIncludingInvocationProperties;

    public MessageContextImpl(Packet packet) {
        this.packet = packet;
        this.asMapIncludingInvocationProperties = packet.asMapIncludingInvocationProperties();
        this.handlerScopeProps = packet.getHandlerScopePropertyNames(false);
    }

    protected void updatePacket() {
        throw new UnsupportedOperationException("wrong call");
    }

    @Override
    public void setScope(String string, MessageContext.Scope scope) {
        if (!this.containsKey(string)) {
            throw new IllegalArgumentException("Property " + string + " does not exist.");
        }
        if (scope == MessageContext.Scope.APPLICATION) {
            this.handlerScopeProps.remove(string);
        } else {
            this.handlerScopeProps.add(string);
        }
    }

    @Override
    public MessageContext.Scope getScope(String string) {
        if (!this.containsKey(string)) {
            throw new IllegalArgumentException("Property " + string + " does not exist.");
        }
        if (this.handlerScopeProps.contains(string)) {
            return MessageContext.Scope.HANDLER;
        }
        return MessageContext.Scope.APPLICATION;
    }

    @Override
    public int size() {
        return this.asMapIncludingInvocationProperties.size();
    }

    @Override
    public boolean isEmpty() {
        return this.asMapIncludingInvocationProperties.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.asMapIncludingInvocationProperties.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.asMapIncludingInvocationProperties.containsValue(object);
    }

    @Override
    public Object put(String string, Object object) {
        if (!this.asMapIncludingInvocationProperties.containsKey(string)) {
            this.handlerScopeProps.add(string);
        }
        return this.asMapIncludingInvocationProperties.put(string, object);
    }

    @Override
    public Object get(Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = this.asMapIncludingInvocationProperties.get(object);
        if (object.equals("javax.xml.ws.binding.attachments.outbound") || object.equals("javax.xml.ws.binding.attachments.inbound")) {
            HashMap<String, DataHandler> hashMap = (HashMap<String, DataHandler>)object2;
            if (hashMap == null) {
                hashMap = new HashMap<String, DataHandler>();
            }
            AttachmentSet attachmentSet = this.packet.getMessage().getAttachments();
            for (Attachment attachment : attachmentSet) {
                String string = attachment.getContentId();
                if (string.indexOf("@jaxws.sun.com") == -1) {
                    Object v = hashMap.get(string);
                    if (v != null || (v = hashMap.get("<" + string + ">")) != null) continue;
                    hashMap.put(attachment.getContentId(), attachment.asDataHandler());
                    continue;
                }
                hashMap.put(attachment.getContentId(), attachment.asDataHandler());
            }
            return hashMap;
        }
        return object2;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        for (String string : map.keySet()) {
            if (this.asMapIncludingInvocationProperties.containsKey(string)) continue;
            this.handlerScopeProps.add(string);
        }
        this.asMapIncludingInvocationProperties.putAll(map);
    }

    @Override
    public void clear() {
        this.asMapIncludingInvocationProperties.clear();
    }

    @Override
    public Object remove(Object object) {
        this.handlerScopeProps.remove(object);
        return this.asMapIncludingInvocationProperties.remove(object);
    }

    @Override
    public Set<String> keySet() {
        return this.asMapIncludingInvocationProperties.keySet();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.asMapIncludingInvocationProperties.entrySet();
    }

    @Override
    public Collection<Object> values() {
        return this.asMapIncludingInvocationProperties.values();
    }
}

